/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.httpcomponents;

import com.gooddata.sdk.service.httpcomponents.HttpClient4ClientHttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;

final class HttpClient4ClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpClient httpClient;
    private final HttpUriRequest httpRequest;
    private final HttpContext httpContext;
    private ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream(1024);

    HttpClient4ClientHttpRequest(HttpClient httpClient, HttpUriRequest httpRequest, HttpContext httpContext) {
        this.httpClient = httpClient;
        this.httpRequest = httpRequest;
        this.httpContext = httpContext;
    }

    public String getMethodValue() {
        return this.httpRequest.getMethod();
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.httpRequest.getMethod());
    }

    public URI getURI() {
        return this.httpRequest.getURI();
    }

    HttpContext getHttpContext() {
        return this.httpContext;
    }

    protected OutputStream getBodyInternal(HttpHeaders headers) {
        return this.bufferedOutput;
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        byte[] bytes = this.bufferedOutput.toByteArray();
        if (bytes.length > 0 && this.httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)this.httpRequest;
            ByteArrayEntity requestEntity = new ByteArrayEntity(bytes);
            entityRequest.setEntity((HttpEntity)requestEntity);
        }
        HttpHeaders headersToUse = this.getHeaders();
        headersToUse.putAll((Map)headers);
        for (String headerName : headersToUse.keySet()) {
            if ("Content-Length".equalsIgnoreCase(headerName)) continue;
            String headerValue = StringUtils.collectionToCommaDelimitedString((Collection)headersToUse.get((Object)headerName));
            this.httpRequest.setHeader(headerName, headerValue);
        }
        HttpResponse httpResponse = this.httpClient.execute(this.httpRequest, this.httpContext);
        return new HttpClient4ClientHttpResponse(httpResponse);
    }
}

