/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.httpcomponents;

import com.gooddata.sdk.common.HttpClient4ComponentsClientHttpRequestFactory;
import com.gooddata.sdk.common.UriPrefixingClientHttpRequestFactory;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.service.DeprecationWarningRequestInterceptor;
import com.gooddata.sdk.service.GoodDataEndpoint;
import com.gooddata.sdk.service.GoodDataRestProvider;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.HeaderSettingRequestInterceptor;
import com.gooddata.sdk.service.RequestIdInterceptor;
import com.gooddata.sdk.service.ResponseMissingRequestIdInterceptor;
import com.gooddata.sdk.service.gdc.DataStoreService;
import com.gooddata.sdk.service.httpcomponents.GoodDataHttpClientBuilder;
import com.gooddata.sdk.service.retry.RetryableRestTemplate;
import com.gooddata.sdk.service.util.ResponseErrorHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public abstract class SingleEndpointGoodDataRestProvider
implements GoodDataRestProvider {
    private final Logger logger = LoggerFactory.getLogger(SingleEndpointGoodDataRestProvider.class);
    protected final GoodDataEndpoint endpoint;
    protected final GoodDataSettings settings;
    protected HttpClient httpClient;
    protected RestTemplate restTemplate;

    protected SingleEndpointGoodDataRestProvider(GoodDataEndpoint endpoint, GoodDataSettings settings, GoodDataHttpClientBuilder builder) {
        this.endpoint = endpoint;
        this.settings = settings;
        this.restTemplate = this.createRestTemplate(endpoint, settings, builder.buildHttpClient(this.createHttpClientBuilder(settings), endpoint, settings));
    }

    @Override
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @Override
    public GoodDataSettings getSettings() {
        return this.settings;
    }

    @Override
    public Optional<DataStoreService> getDataStoreService(Supplier<String> stagingUriSupplier) {
        try {
            Class.forName("com.github.sardine.Sardine", false, this.getClass().getClassLoader());
            return Optional.of(new DataStoreService(this, stagingUriSupplier));
        }
        catch (ClassNotFoundException e) {
            this.logger.info("Optional dependency Sardine not found - WebDAV related operations are not supported");
            return Optional.empty();
        }
    }

    public GoodDataEndpoint getEndpoint() {
        return this.endpoint;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected RestTemplate createRestTemplate(GoodDataEndpoint endpoint, GoodDataSettings settings, HttpClient httpClient) {
        Validate.notNull((Object)endpoint, (String)"endpoint");
        Validate.notNull((Object)settings, (String)"settings");
        this.httpClient = (HttpClient)Validate.notNull((Object)httpClient, (String)"httpClient");
        UriPrefixingClientHttpRequestFactory factory = new UriPrefixingClientHttpRequestFactory(new HttpClient4ComponentsClientHttpRequestFactory(httpClient), URI.create(endpoint.toUri()));
        RestTemplate restTemplate = settings.getRetrySettings() == null ? new RestTemplate((ClientHttpRequestFactory)factory) : RetryableRestTemplate.create(settings.getRetrySettings(), factory);
        restTemplate.setInterceptors(Arrays.asList(new HeaderSettingRequestInterceptor(settings.getPresetHeaders()), new DeprecationWarningRequestInterceptor()));
        restTemplate.setErrorHandler((org.springframework.web.client.ResponseErrorHandler)new ResponseErrorHandler(restTemplate.getMessageConverters()));
        return restTemplate;
    }

    protected HttpClientBuilder createHttpClientBuilder(GoodDataSettings settings) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(settings.getMaxConnections());
        connectionManager.setMaxTotal(settings.getMaxConnections());
        SocketConfig.Builder socketConfig = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT);
        socketConfig.setSoTimeout(settings.getSocketTimeout());
        connectionManager.setDefaultSocketConfig(socketConfig.build());
        RequestConfig.Builder requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        requestConfig.setConnectTimeout(settings.getConnectionTimeout());
        requestConfig.setConnectionRequestTimeout(settings.getConnectionRequestTimeout());
        requestConfig.setSocketTimeout(settings.getSocketTimeout());
        requestConfig.setCookieSpec("standard");
        return HttpClientBuilder.create().setUserAgent(settings.getGoodDataUserAgent()).setConnectionManager((HttpClientConnectionManager)connectionManager).addInterceptorFirst((HttpRequestInterceptor)new RequestIdInterceptor()).addInterceptorFirst((HttpResponseInterceptor)new ResponseMissingRequestIdInterceptor()).setDefaultRequestConfig(requestConfig.build());
    }
}

