/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service;

import java.io.IOException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestIdInterceptor
implements HttpRequestInterceptor {
    public void process(HttpRequest request, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
        StringBuilder requestIdBuilder = new StringBuilder();
        Header requestIdHeader = request.getFirstHeader("X-GDC-REQUEST");
        if (requestIdHeader != null) {
            requestIdBuilder.append(requestIdHeader.getValue()).append(":");
        }
        String requestId = requestIdBuilder.append(RandomStringUtils.secure().nextAlphanumeric(16)).toString();
        request.setHeader("X-GDC-REQUEST", (Object)requestId);
    }
}

