/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.connector;

import com.gooddata.sdk.common.GoodDataException;
import com.gooddata.sdk.common.GoodDataRestException;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.connector.ConnectorType;
import com.gooddata.sdk.model.connector.Integration;
import com.gooddata.sdk.model.connector.IntegrationProcessStatus;
import com.gooddata.sdk.model.connector.ProcessExecution;
import com.gooddata.sdk.model.connector.ProcessStatus;
import com.gooddata.sdk.model.connector.Reload;
import com.gooddata.sdk.model.connector.Settings;
import com.gooddata.sdk.model.connector.Zendesk4Settings;
import com.gooddata.sdk.model.gdc.UriResponse;
import com.gooddata.sdk.model.project.Project;
import com.gooddata.sdk.model.project.ProjectTemplate;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.FutureResult;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.PollResult;
import com.gooddata.sdk.service.SimplePollHandler;
import com.gooddata.sdk.service.connector.ConnectorException;
import com.gooddata.sdk.service.connector.IntegrationNotFoundException;
import com.gooddata.sdk.service.project.ProjectService;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class ConnectorService
extends AbstractService {
    public static final UriTemplate STATUS_TEMPLATE = new UriTemplate("/gdc/projects/{project}/connectors/{connector}/integration/processes/{process}");
    private final ProjectService projectService;

    public ConnectorService(RestTemplate restTemplate, ProjectService projectService, GoodDataSettings settings) {
        super(restTemplate, settings);
        this.projectService = (ProjectService)Validate.notNull((Object)projectService, (String)"projectService");
    }

    public Integration getIntegration(Project project, ConnectorType connectorType) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)connectorType, (String)"connector");
        try {
            return (Integration)this.restTemplate.getForObject("/gdc/projects/{project}/connectors/{connector}/integration", Integration.class, new Object[]{project.getId(), connectorType.getName()});
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new IntegrationNotFoundException(project, connectorType, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new ConnectorException("Unable to get " + String.valueOf(connectorType) + " integration", e);
        }
    }

    public Integration createIntegration(Project project, Settings settings) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)settings, (String)"settings");
        Collection<ProjectTemplate> projectTemplates = this.projectService.getProjectTemplates(project);
        if (projectTemplates == null || projectTemplates.isEmpty()) {
            throw new GoodDataException("Project " + project.getId() + " doesn't contain a template reference");
        }
        ProjectTemplate template = (ProjectTemplate)Validate.notNull((Object)projectTemplates.iterator().next(), (String)"project template");
        Integration integration = this.createIntegration(project, settings.getConnectorType(), new Integration(template.getUrl()));
        this.updateSettings(project, settings);
        return integration;
    }

    public Integration createIntegration(Project project, ConnectorType connectorType, Integration integration) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)connectorType, (String)"connectorType");
        Validate.notNull((Object)integration, (String)"integration");
        try {
            return (Integration)this.restTemplate.postForObject("/gdc/projects/{project}/connectors/{connector}/integration", (Object)integration, Integration.class, new Object[]{project.getId(), connectorType.getName()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to create " + String.valueOf(connectorType) + " integration", e);
        }
    }

    public void updateIntegration(Project project, ConnectorType connectorType, Integration integration) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)connectorType, (String)"connector");
        Validate.notNull((Object)integration, (String)"integration");
        try {
            this.restTemplate.put("/gdc/projects/{project}/connectors/{connector}/integration", (Object)integration, new Object[]{project.getId(), connectorType.getName()});
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new IntegrationNotFoundException(project, connectorType, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new ConnectorException("Unable to update " + String.valueOf(connectorType) + " integration", e);
        }
    }

    public void deleteIntegration(Project project, ConnectorType connectorType) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)connectorType, (String)"connector");
        try {
            this.restTemplate.delete("/gdc/projects/{project}/connectors/{connector}/integration", new Object[]{project.getId(), connectorType.getName()});
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new IntegrationNotFoundException(project, connectorType, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new ConnectorException("Unable to delete " + String.valueOf(connectorType) + " integration", e);
        }
    }

    public Zendesk4Settings getZendesk4Settings(Project project) {
        return this.getSettings(project, ConnectorType.ZENDESK4, Zendesk4Settings.class);
    }

    public <T extends Settings> T getSettings(Project project, ConnectorType connectorType, Class<T> settingsClass) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)connectorType, (String)"connectorType");
        Validate.notNull(settingsClass, (String)"settingsClass");
        try {
            return (T)((Settings)this.restTemplate.getForObject(connectorType.getSettingsUrl(), settingsClass, new Object[]{project.getId()}));
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to get " + String.valueOf(connectorType) + " integration settings", e);
        }
    }

    public void updateSettings(Project project, Settings settings) {
        Validate.notNull((Object)settings, (String)"settings");
        Validate.notNull((Object)settings.getConnectorType(), (String)"settings.connectorType");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)project, (String)"project");
        try {
            this.restTemplate.put(settings.getConnectorType().getSettingsUrl(), (Object)settings, new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to set " + String.valueOf(settings.getConnectorType()) + " settings", e);
        }
    }

    public FutureResult<ProcessStatus> executeProcess(Project project, ProcessExecution execution) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)execution, (String)"execution");
        String connectorType = execution.getConnectorType().getName();
        try {
            UriResponse response = (UriResponse)this.restTemplate.postForObject("/gdc/projects/{project}/connectors/{connector}/integration/processes", (Object)execution, UriResponse.class, new Object[]{project.getId(), connectorType});
            return this.createProcessPollResult(((UriResponse)Validate.notNullState((Object)response, (String)"created process response")).getUri());
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to execute " + connectorType + " process", e);
        }
    }

    public FutureResult<ProcessStatus> getProcessStatus(IntegrationProcessStatus process) {
        Validate.notNull((Object)process, (String)"process");
        Validate.notNull((Object)process.getUri(), (String)"process.getUri");
        return this.createProcessPollResult(process.getUri());
    }

    public Reload getZendesk4Reload(Reload reload) {
        Validate.notNull((Object)reload, (String)"reload");
        Optional reloadUri = reload.getUri();
        if (reloadUri.isPresent()) {
            return this.getZendesk4ReloadByUri((String)reloadUri.get());
        }
        throw new IllegalArgumentException("Self link in the Reload must be present!");
    }

    public Reload getZendesk4ReloadByUri(String reloadUri) {
        Validate.notNull((Object)reloadUri, (String)"reloadUri");
        try {
            return (Reload)this.restTemplate.getForObject(reloadUri, Reload.class, new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ConnectorException("Unable to get reload", e);
        }
    }

    public Reload scheduleZendesk4Reload(Project project, Reload reload) {
        return (Reload)this.restTemplate.postForObject("/gdc/projects/{project}/connectors/zendesk4/integration/reloads", (Object)reload, Reload.class, new Object[]{project.getId()});
    }

    protected FutureResult<ProcessStatus> createProcessPollResult(String uri) {
        Map match = STATUS_TEMPLATE.match(uri);
        final String connectorType = (String)match.get("connector");
        final String processId = (String)match.get("process");
        return new PollResult<ProcessStatus>(this, new SimplePollHandler<ProcessStatus>(uri, ProcessStatus.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                ProcessStatus process = (ProcessStatus)ConnectorService.this.extractData(response, ProcessStatus.class);
                return process.isFinished();
            }

            @Override
            public void handlePollResult(ProcessStatus pollResult) {
                super.handlePollResult(pollResult);
                if (pollResult.isFailed()) {
                    throw new ConnectorException(String.format("%s process %s failed: %s", connectorType, processId, pollResult.getStatus().getDescription()));
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ConnectorException(String.format("%s process %s failed: %s", connectorType, processId, e.getText()), e);
            }
        });
    }
}

