/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl;

import com.gooddata.shadowed.http4.HttpClientConnection;
import com.gooddata.shadowed.http4.HttpConnectionMetrics;
import com.gooddata.shadowed.http4.HttpEntity;
import com.gooddata.shadowed.http4.HttpEntityEnclosingRequest;
import com.gooddata.shadowed.http4.HttpException;
import com.gooddata.shadowed.http4.HttpRequest;
import com.gooddata.shadowed.http4.HttpResponse;
import com.gooddata.shadowed.http4.HttpResponseFactory;
import com.gooddata.shadowed.http4.impl.DefaultHttpResponseFactory;
import com.gooddata.shadowed.http4.impl.HttpConnectionMetricsImpl;
import com.gooddata.shadowed.http4.impl.entity.EntityDeserializer;
import com.gooddata.shadowed.http4.impl.entity.EntitySerializer;
import com.gooddata.shadowed.http4.impl.entity.LaxContentLengthStrategy;
import com.gooddata.shadowed.http4.impl.entity.StrictContentLengthStrategy;
import com.gooddata.shadowed.http4.impl.io.DefaultHttpResponseParser;
import com.gooddata.shadowed.http4.impl.io.HttpRequestWriter;
import com.gooddata.shadowed.http4.io.EofSensor;
import com.gooddata.shadowed.http4.io.HttpMessageParser;
import com.gooddata.shadowed.http4.io.HttpMessageWriter;
import com.gooddata.shadowed.http4.io.HttpTransportMetrics;
import com.gooddata.shadowed.http4.io.SessionInputBuffer;
import com.gooddata.shadowed.http4.io.SessionOutputBuffer;
import com.gooddata.shadowed.http4.params.HttpParams;
import com.gooddata.shadowed.http4.util.Args;
import java.io.IOException;
import java.net.SocketTimeoutException;

@Deprecated
public abstract class AbstractHttpClientConnection
implements HttpClientConnection {
    private final EntitySerializer entityserializer = this.createEntitySerializer();
    private final EntityDeserializer entitydeserializer = this.createEntityDeserializer();
    private SessionInputBuffer inBuffer = null;
    private SessionOutputBuffer outbuffer = null;
    private EofSensor eofSensor = null;
    private HttpMessageParser<HttpResponse> responseParser = null;
    private HttpMessageWriter<HttpRequest> requestWriter = null;
    private HttpConnectionMetricsImpl metrics = null;

    protected abstract void assertOpen() throws IllegalStateException;

    protected EntityDeserializer createEntityDeserializer() {
        return new EntityDeserializer(new LaxContentLengthStrategy());
    }

    protected EntitySerializer createEntitySerializer() {
        return new EntitySerializer(new StrictContentLengthStrategy());
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return DefaultHttpResponseFactory.INSTANCE;
    }

    protected HttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new DefaultHttpResponseParser(buffer, null, responseFactory, params);
    }

    protected HttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new HttpRequestWriter(buffer, null, params);
    }

    protected HttpConnectionMetricsImpl createConnectionMetrics(HttpTransportMetrics inTransportMetric, HttpTransportMetrics outTransportMetric) {
        return new HttpConnectionMetricsImpl(inTransportMetric, outTransportMetric);
    }

    protected void init(SessionInputBuffer sessionInputBuffer, SessionOutputBuffer sessionOutputBuffer, HttpParams params) {
        this.inBuffer = Args.notNull(sessionInputBuffer, "Input session buffer");
        this.outbuffer = Args.notNull(sessionOutputBuffer, "Output session buffer");
        if (sessionInputBuffer instanceof EofSensor) {
            this.eofSensor = (EofSensor)((Object)sessionInputBuffer);
        }
        this.responseParser = this.createResponseParser(sessionInputBuffer, this.createHttpResponseFactory(), params);
        this.requestWriter = this.createRequestWriter(sessionOutputBuffer, params);
        this.metrics = this.createConnectionMetrics(sessionInputBuffer.getMetrics(), sessionOutputBuffer.getMetrics());
    }

    @Override
    public boolean isResponseAvailable(int timeout) throws IOException {
        this.assertOpen();
        try {
            return this.inBuffer.isDataAvailable(timeout);
        }
        catch (SocketTimeoutException ex) {
            return false;
        }
    }

    @Override
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        this.assertOpen();
        this.requestWriter.write(request);
        this.metrics.incrementRequestCount();
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        this.assertOpen();
        if (request.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.outbuffer, request, request.getEntity());
    }

    protected void doFlush() throws IOException {
        this.outbuffer.flush();
    }

    @Override
    public void flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        this.assertOpen();
        HttpResponse response = this.responseParser.parse();
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.metrics.incrementResponseCount();
        }
        return response;
    }

    @Override
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        this.assertOpen();
        HttpEntity entity = this.entitydeserializer.deserialize(this.inBuffer, response);
        response.setEntity(entity);
    }

    protected boolean isEof() {
        return this.eofSensor != null && this.eofSensor.isEof();
    }

    @Override
    public boolean isStale() {
        if (!this.isOpen()) {
            return true;
        }
        if (this.isEof()) {
            return true;
        }
        try {
            this.inBuffer.isDataAvailable(1);
            return this.isEof();
        }
        catch (SocketTimeoutException ex) {
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }
}

