/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.conn;

import com.gooddata.shadowed.http4.HttpRequest;
import com.gooddata.shadowed.http4.HttpResponse;
import com.gooddata.shadowed.http4.config.MessageConstraints;
import com.gooddata.shadowed.http4.conn.ManagedHttpClientConnection;
import com.gooddata.shadowed.http4.entity.ContentLengthStrategy;
import com.gooddata.shadowed.http4.impl.DefaultBHttpClientConnection;
import com.gooddata.shadowed.http4.io.HttpMessageParserFactory;
import com.gooddata.shadowed.http4.io.HttpMessageWriterFactory;
import com.gooddata.shadowed.http4.protocol.HttpContext;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class DefaultManagedHttpClientConnection
extends DefaultBHttpClientConnection
implements ManagedHttpClientConnection,
HttpContext {
    private final String id;
    private final Map<String, Object> attributes;
    private volatile boolean shutdown;

    public DefaultManagedHttpClientConnection(String id, int bufferSize, int fragmentSizeHint, CharsetDecoder charDecoder, CharsetEncoder charEncoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(bufferSize, fragmentSizeHint, charDecoder, charEncoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        this.id = id;
        this.attributes = new ConcurrentHashMap<String, Object>();
    }

    public DefaultManagedHttpClientConnection(String id, int bufferSize) {
        this(id, bufferSize, bufferSize, null, null, null, null, null, null, null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void shutdown() throws IOException {
        this.shutdown = true;
        super.shutdown();
    }

    @Override
    public Object getAttribute(String id) {
        return this.attributes.get(id);
    }

    @Override
    public Object removeAttribute(String id) {
        return this.attributes.remove(id);
    }

    @Override
    public void setAttribute(String id, Object obj) {
        this.attributes.put(id, obj);
    }

    @Override
    public void bind(Socket socket) throws IOException {
        if (this.shutdown) {
            socket.close();
            throw new InterruptedIOException("Connection already shutdown");
        }
        super.bind(socket);
    }

    @Override
    public Socket getSocket() {
        return super.getSocket();
    }

    @Override
    public SSLSession getSSLSession() {
        Socket socket = super.getSocket();
        return socket instanceof SSLSocket ? ((SSLSocket)socket).getSession() : null;
    }
}

