/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.execchain;

import com.gooddata.shadowed.http4.ConnectionReuseStrategy;
import com.gooddata.shadowed.http4.HttpClientConnection;
import com.gooddata.shadowed.http4.HttpEntity;
import com.gooddata.shadowed.http4.HttpException;
import com.gooddata.shadowed.http4.HttpHost;
import com.gooddata.shadowed.http4.HttpRequest;
import com.gooddata.shadowed.http4.HttpResponse;
import com.gooddata.shadowed.http4.ProtocolException;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.client.config.RequestConfig;
import com.gooddata.shadowed.http4.client.methods.CloseableHttpResponse;
import com.gooddata.shadowed.http4.client.methods.HttpExecutionAware;
import com.gooddata.shadowed.http4.client.methods.HttpRequestWrapper;
import com.gooddata.shadowed.http4.client.methods.HttpUriRequest;
import com.gooddata.shadowed.http4.client.protocol.HttpClientContext;
import com.gooddata.shadowed.http4.client.protocol.RequestClientConnControl;
import com.gooddata.shadowed.http4.client.utils.URIUtils;
import com.gooddata.shadowed.http4.conn.ConnectionKeepAliveStrategy;
import com.gooddata.shadowed.http4.conn.ConnectionRequest;
import com.gooddata.shadowed.http4.conn.HttpClientConnectionManager;
import com.gooddata.shadowed.http4.conn.routing.HttpRoute;
import com.gooddata.shadowed.http4.impl.conn.ConnectionShutdownException;
import com.gooddata.shadowed.http4.impl.execchain.ClientExecChain;
import com.gooddata.shadowed.http4.impl.execchain.ConnectionHolder;
import com.gooddata.shadowed.http4.impl.execchain.HttpResponseProxy;
import com.gooddata.shadowed.http4.impl.execchain.RequestAbortedException;
import com.gooddata.shadowed.http4.protocol.HttpContext;
import com.gooddata.shadowed.http4.protocol.HttpProcessor;
import com.gooddata.shadowed.http4.protocol.HttpRequestExecutor;
import com.gooddata.shadowed.http4.protocol.ImmutableHttpProcessor;
import com.gooddata.shadowed.http4.protocol.RequestContent;
import com.gooddata.shadowed.http4.protocol.RequestTargetHost;
import com.gooddata.shadowed.http4.protocol.RequestUserAgent;
import com.gooddata.shadowed.http4.util.Args;
import com.gooddata.shadowed.http4.util.VersionInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class MinimalClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor httpProcessor;

    public MinimalClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(connManager, "Client connection manager");
        Args.notNull(reuseStrategy, "Connection reuse strategy");
        Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.httpProcessor = new ImmutableHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getUserAgent("Apache-HttpClient", "com.gooddata.shadowed.http4.client", this.getClass())));
        this.requestExecutor = requestExecutor;
        this.connManager = connManager;
        this.reuseStrategy = reuseStrategy;
        this.keepAliveStrategy = keepAliveStrategy;
    }

    static void rewriteRequestURI(HttpRequestWrapper request, HttpRoute route, boolean normalizeUri) throws ProtocolException {
        try {
            URI uri = request.getURI();
            if (uri != null) {
                uri = uri.isAbsolute() ? URIUtils.rewriteURI(uri, null, normalizeUri ? URIUtils.DROP_FRAGMENT_AND_NORMALIZE : URIUtils.DROP_FRAGMENT) : URIUtils.rewriteURI(uri);
                request.setURI(uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), ex);
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpClientConnection managedConn;
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        MinimalClientExec.rewriteRequestURI(request, route, context.getRequestConfig().isNormalizeUri());
        ConnectionRequest connRequest = this.connManager.requestConnection(route, null);
        if (execAware != null) {
            if (execAware.isAborted()) {
                connRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            execAware.setCancellable(connRequest);
        }
        RequestConfig config = context.getRequestConfig();
        try {
            int timeout = config.getConnectionRequestTimeout();
            managedConn = connRequest.get(timeout > 0 ? (long)timeout : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            throw new RequestAbortedException("Request execution failed", cause);
        }
        ConnectionHolder releaseTrigger = new ConnectionHolder(this.log, this.connManager, managedConn);
        try {
            URI uri;
            int timeout;
            if (execAware != null) {
                if (execAware.isAborted()) {
                    releaseTrigger.close();
                    throw new RequestAbortedException("Request aborted");
                }
                execAware.setCancellable(releaseTrigger);
            }
            if (!managedConn.isOpen()) {
                timeout = config.getConnectTimeout();
                this.connManager.connect(managedConn, route, timeout > 0 ? timeout : 0, context);
                this.connManager.routeComplete(managedConn, route, context);
            }
            if ((timeout = config.getSocketTimeout()) >= 0) {
                managedConn.setSocketTimeout(timeout);
            }
            HttpHost target = null;
            HttpRequest original = request.getOriginal();
            if (original instanceof HttpUriRequest && (uri = ((HttpUriRequest)original).getURI()).isAbsolute()) {
                target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            }
            if (target == null) {
                target = route.getTargetHost();
            }
            context.setAttribute("http.target_host", target);
            context.setAttribute("http.request", request);
            context.setAttribute("http.connection", managedConn);
            context.setAttribute("http.route", route);
            this.httpProcessor.process(request, (HttpContext)context);
            HttpResponse response = this.requestExecutor.execute(request, managedConn, context);
            this.httpProcessor.process(response, (HttpContext)context);
            if (this.reuseStrategy.keepAlive(response, context)) {
                long duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                releaseTrigger.setValidFor(duration, TimeUnit.MILLISECONDS);
                releaseTrigger.markReusable();
            } else {
                releaseTrigger.markNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                releaseTrigger.releaseConnection();
                return new HttpResponseProxy(response, null);
            }
            return new HttpResponseProxy(response, releaseTrigger);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            throw ioex;
        }
        catch (HttpException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (IOException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (Error error) {
            this.connManager.shutdown();
            throw error;
        }
    }
}

