/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.protocol;

import com.gooddata.shadowed.http4.HttpEntityEnclosingRequest;
import com.gooddata.shadowed.http4.HttpException;
import com.gooddata.shadowed.http4.HttpRequest;
import com.gooddata.shadowed.http4.HttpRequestInterceptor;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.protocol.HttpContext;
import com.gooddata.shadowed.http4.protocol.HttpDateGenerator;
import com.gooddata.shadowed.http4.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

