/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.java2objc.examples.main;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatternBasedFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternBasedFilenameFilter(String fileNamePattern) {
        this.pattern = Pattern.compile(fileNamePattern);
    }

    @Override
    public boolean accept(File dir, String name) {
        Matcher matcher = this.pattern.matcher(name);
        return matcher.matches();
    }

    public static FilenameFilter getFilterForJavaFiles() {
        return new PatternBasedFilenameFilter("([a-zA-Z\\$\\_]){1}[a-zA-Z0-9\\$\\_]*\\.java");
    }
}

