/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.errorprone.annotations.Immutable;
import com.google.googlejavaformat.java.EclipseJavadocFormatter;

@Immutable
public class JavaFormatterOptions {
    static final int DEFAULT_MAX_LINE_LENGTH = 100;
    private final JavadocFormatter javadocFormatter;
    private final Style style;
    private final SortImports sortImports;

    public JavaFormatterOptions(JavadocFormatter javadocFormatter, Style style, SortImports sortImports) {
        this.javadocFormatter = javadocFormatter;
        this.style = style;
        this.sortImports = sortImports;
    }

    public JavadocFormatter javadocFormatter() {
        return this.javadocFormatter;
    }

    public int maxLineLength() {
        return 100;
    }

    public int indentationMultiplier() {
        return this.style.indentationMultiplier();
    }

    public SortImports sortImports() {
        return this.sortImports;
    }

    public static enum JavadocFormatter {
        NONE{

            @Override
            public String format(JavaFormatterOptions options, String text, int column0) {
                return text;
            }
        }
        ,
        ECLIPSE{

            @Override
            public String format(JavaFormatterOptions options, String text, int column0) {
                return EclipseJavadocFormatter.formatJavadoc(text, column0, options);
            }
        };


        public abstract String format(JavaFormatterOptions var1, String var2, int var3);
    }

    public static enum Style {
        GOOGLE(1),
        AOSP(2);

        private final int indentationMultiplier;

        private Style(int indentationMultiplier) {
            this.indentationMultiplier = indentationMultiplier;
        }

        int indentationMultiplier() {
            return this.indentationMultiplier;
        }
    }

    public static enum SortImports {
        NO,
        ONLY,
        ALSO;

    }
}

