/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.rclass.IRInnerClass;
import com.sun.codemodel.JFieldRef;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;

public class IdAnnotationHelper
extends TargetAnnotationHelper {
    private final IRClass rClass;

    public IdAnnotationHelper(ProcessingEnvironment processingEnv, Class<? extends Annotation> target, IRClass rClass) {
        super(processingEnv, target);
        this.rClass = rClass;
    }

    public boolean containsIdValue(Integer idValue, IRClass.Res res) {
        IRInnerClass rInnerClass = this.rClass.get(res);
        return rInnerClass.containsIdValue(idValue);
    }

    public boolean containsField(String name, IRClass.Res res) {
        IRInnerClass rInnerClass = this.rClass.get(res);
        return rInnerClass.containsField(name);
    }

    public List<String> extractAnnotationResources(Element element, IRClass.Res res, boolean useElementName) {
        return super.extractAnnotationResources(element, this.getTarget(), this.rClass.get(res), useElementName);
    }

    public List<JFieldRef> extractAnnotationFieldRefs(EBeanHolder holder, Element element, IRClass.Res res, boolean useElementName) {
        return super.extractAnnotationFieldRefs(holder, element, this.getTarget(), this.rClass.get(res), useElementName);
    }

    public JFieldRef extractOneAnnotationFieldRef(EBeanHolder holder, Element element, IRClass.Res res, boolean useElementName) {
        List<JFieldRef> jFieldRefs = this.extractAnnotationFieldRefs(holder, element, res, useElementName);
        if (jFieldRefs.size() == 1) {
            return jFieldRefs.get(0);
        }
        return null;
    }
}

