/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.annotations.EActivity;
import com.googlecode.androidannotations.annotations.EApplication;
import com.googlecode.androidannotations.annotations.EBean;
import com.googlecode.androidannotations.annotations.EFragment;
import com.googlecode.androidannotations.annotations.EProvider;
import com.googlecode.androidannotations.annotations.EReceiver;
import com.googlecode.androidannotations.annotations.EService;
import com.googlecode.androidannotations.annotations.EView;
import com.googlecode.androidannotations.annotations.EViewGroup;
import com.googlecode.androidannotations.annotations.Trace;
import com.googlecode.androidannotations.annotations.ViewById;
import com.googlecode.androidannotations.annotations.rest.Delete;
import com.googlecode.androidannotations.annotations.rest.Get;
import com.googlecode.androidannotations.annotations.rest.Head;
import com.googlecode.androidannotations.annotations.rest.Options;
import com.googlecode.androidannotations.annotations.rest.Post;
import com.googlecode.androidannotations.annotations.rest.Put;
import com.googlecode.androidannotations.annotations.rest.Rest;
import com.googlecode.androidannotations.annotations.sharedpreferences.DefaultBoolean;
import com.googlecode.androidannotations.annotations.sharedpreferences.DefaultFloat;
import com.googlecode.androidannotations.annotations.sharedpreferences.DefaultInt;
import com.googlecode.androidannotations.annotations.sharedpreferences.DefaultLong;
import com.googlecode.androidannotations.annotations.sharedpreferences.DefaultString;
import com.googlecode.androidannotations.annotations.sharedpreferences.SharedPref;
import com.googlecode.androidannotations.api.sharedpreferences.SharedPreferencesHelper;
import com.googlecode.androidannotations.helper.AndroidManifest;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.model.AndroidSystemServices;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.processing.InstanceStateProcessor;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

public class ValidatorHelper {
    private static final List<String> ANDROID_SHERLOCK_MENU_ITEM_QUALIFIED_NAMES = Arrays.asList("android.view.MenuItem", "com.actionbarsherlock.view.MenuItem");
    private static final List<String> ANDROID_FRAGMENT_QUALIFIED_NAMES = Arrays.asList("android.app.Fragment", "android.support.v4.app.Fragment");
    private static final String METHOD_NAME_SET_ROOT_URL = "setRootUrl";
    private static final List<String> VALID_PREF_RETURN_TYPES = Arrays.asList("int", "boolean", "float", "long", CanonicalNameConstants.STRING);
    private static final List<String> INVALID_PREF_METHOD_NAMES = Arrays.asList("edit", "getSharedPreferences", "clear", "getEditor", "apply");
    private static final Collection<Integer> VALID_LOG_LEVELS = Arrays.asList(2, 3, 4, 5, 6);
    private static final List<Class<? extends Annotation>> VALID_ENHANCED_VIEW_SUPPORT_ANNOTATIONS = Arrays.asList(EActivity.class, EViewGroup.class, EView.class, EBean.class, EFragment.class);
    private static final List<Class<? extends Annotation>> VALID_ENHANCED_COMPONENT_ANNOTATIONS = Arrays.asList(EApplication.class, EActivity.class, EViewGroup.class, EView.class, EBean.class, EService.class, EReceiver.class, EProvider.class, EFragment.class);
    protected final TargetAnnotationHelper annotationHelper;
    private static final List<Class<? extends Annotation>> REST_ANNOTATION_CLASSES = Arrays.asList(Get.class, Head.class, Options.class, Post.class, Put.class, Delete.class);

    public ValidatorHelper(TargetAnnotationHelper targetAnnotationHelper) {
        this.annotationHelper = targetAnnotationHelper;
    }

    public void isNotFinal(Element element, IsValid valid) {
        if (this.annotationHelper.isFinal(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s cannot be used on a final element");
        }
    }

    public void isNotSynchronized(Element element, IsValid valid) {
        if (this.annotationHelper.isSynchronized(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s cannot be used on a synchronized element. If you think you shall need to use the synchronized keyword for a specific use case, please post on the mailing list.");
        }
    }

    public void isInterface(TypeElement element, IsValid valid) {
        if (!this.annotationHelper.isInterface(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on an interface");
        }
    }

    public void isTopLevel(TypeElement element, IsValid valid) {
        if (!this.annotationHelper.isTopLevel(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on a top level type");
        }
    }

    public void doesNotExtendOtherInterfaces(TypeElement element, IsValid valid) {
        if (element.getInterfaces().size() > 0) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on an interface that does not extend other interfaces");
        }
    }

    public void doesNotReturnPrimitive(ExecutableElement element, IsValid valid) {
        if (element.getReturnType().getKind().isPrimitive()) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s cannot return primitive");
        }
    }

    public void doesNotReturnArray(ExecutableElement element, IsValid valid) {
        if (element.getReturnType().getKind() == TypeKind.ARRAY) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s cannot return array");
        }
    }

    public void isNotPrivate(Element element, IsValid valid) {
        if (this.annotationHelper.isPrivate(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s cannot be used on a private element");
        }
    }

    public void enclosingElementHasEBeanAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasClassAnnotation(element, enclosingElement, validatedElements, EBean.class, valid);
    }

    public void enclosingElementHasEActivity(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasClassAnnotation(element, enclosingElement, validatedElements, EActivity.class, valid);
    }

    public void enclosingElementHasEActivityOrEFragment(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        List<Class<? extends Annotation>> validAnnotations = Arrays.asList(EActivity.class, EFragment.class);
        this.hasOneOfClassAnnotations(element, enclosingElement, validatedElements, validAnnotations, valid);
    }

    public void enclosingElementHasEFragment(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasClassAnnotation(element, enclosingElement, validatedElements, EFragment.class, valid);
    }

    public void hasEActivity(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.hasClassAnnotation(element, element, validatedElements, EActivity.class, valid);
    }

    public void hasEActivityOrEFragment(Element element, AnnotationElements validatedElements, IsValid valid) {
        List<Class<? extends Annotation>> validAnnotations = Arrays.asList(EActivity.class, EFragment.class);
        this.hasOneOfClassAnnotations(element, element, validatedElements, validAnnotations, valid);
    }

    public void enclosingElementHasEnhancedViewSupportAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasOneOfClassAnnotations(element, enclosingElement, validatedElements, VALID_ENHANCED_VIEW_SUPPORT_ANNOTATIONS, valid);
    }

    public void enclosingElementHasEnhancedComponentAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        Element enclosingElement = element.getEnclosingElement();
        this.hasOneOfClassAnnotations(element, enclosingElement, validatedElements, VALID_ENHANCED_COMPONENT_ANNOTATIONS, valid);
    }

    private void hasClassAnnotation(Element reportElement, Element element, AnnotationElements validatedElements, Class<? extends Annotation> validAnnotation, IsValid valid) {
        ArrayList<Class<? extends Annotation>> validAnnotations = new ArrayList<Class<? extends Annotation>>();
        validAnnotations.add(validAnnotation);
        this.hasOneOfClassAnnotations(reportElement, element, validatedElements, validAnnotations, valid);
    }

    private void hasOneOfClassAnnotations(Element reportElement, Element element, AnnotationElements validatedElements, List<Class<? extends Annotation>> validAnnotations, IsValid valid) {
        boolean foundAnnotation = false;
        for (Class<? extends Annotation> validAnnotation : validAnnotations) {
            if (element.getAnnotation(validAnnotation) == null) continue;
            Set<? extends Element> layoutAnnotatedElements = validatedElements.getRootAnnotatedElements(validAnnotation.getName());
            if (!layoutAnnotatedElements.contains(element)) {
                valid.invalidate();
            }
            foundAnnotation = true;
            break;
        }
        if (!foundAnnotation) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(reportElement, "%s can only be used in a class annotated with " + this.getFormattedValidEnhancedBeanAnnotationTypes(validAnnotations) + ".");
        }
    }

    private String getFormattedValidEnhancedBeanAnnotationTypes(List<Class<? extends Annotation>> annotations) {
        StringBuilder sb = new StringBuilder();
        if (!annotations.isEmpty()) {
            sb.append(TargetAnnotationHelper.annotationName(annotations.get(0)));
            for (int i = 1; i < annotations.size(); ++i) {
                sb.append(", ");
                sb.append(TargetAnnotationHelper.annotationName(annotations.get(i)));
            }
        }
        return sb.toString();
    }

    public void hasViewByIdAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        String error = "can only be used with annotation";
        this.elementHasAnnotation(ViewById.class, element, validatedElements, valid, error);
    }

    public void elementHasRestAnnotationOrEnclosingElementHasRestAnnotationAndElementHasMethodRestAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        String error = "can only be used in an interface annotated with";
        this.elementHasAnnotation(Rest.class, element, validatedElements, valid, error);
        if (!valid.isValid()) {
            this.enclosingElementHasRestAnnotation(element, validatedElements, valid);
            this.elementHasMethodRestAnnotation(element, validatedElements, valid);
        }
    }

    public void elementHasMethodRestAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        String error = "can only be used on a method annotated with Rest methods.";
        this.elementHasAnnotationContainsIn(REST_ANNOTATION_CLASSES, element, validatedElements, valid, error);
    }

    public void enclosingElementHasRestAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        String error = "can only be used in an interface annotated with";
        this.enclosingElementHasAnnotation(Rest.class, element, validatedElements, valid, error);
    }

    public void enclosingElementHasAnnotation(Class<? extends Annotation> annotation, Element element, AnnotationElements validatedElements, IsValid valid, String error) {
        Element enclosingElement = element.getEnclosingElement();
        this.elementHasAnnotation(annotation, enclosingElement, validatedElements, valid, error);
    }

    public void elementHasAnnotation(Class<? extends Annotation> annotation, Element element, AnnotationElements validatedElements, IsValid valid, String error) {
        Set<? extends Element> layoutAnnotatedElements = validatedElements.getRootAnnotatedElements(annotation.getName());
        if (!layoutAnnotatedElements.contains(element)) {
            valid.invalidate();
            if (element.getAnnotation(annotation) == null) {
                this.annotationHelper.printAnnotationError(element, "%s " + error + " " + TargetAnnotationHelper.annotationName(annotation));
            }
        }
    }

    public void elementHasAnnotationContainsIn(List<Class<? extends Annotation>> annotations, Element element, AnnotationElements validatedElements, IsValid valid, String error) {
        boolean isAnnoted = false;
        for (Class<? extends Annotation> annotation : annotations) {
            if (!this.elementHasAnnotation(annotation, element, validatedElements)) continue;
            isAnnoted = true;
            break;
        }
        if (!isAnnoted) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s " + error);
        }
    }

    public boolean elementHasAnnotation(Class<? extends Annotation> annotation, Element element, AnnotationElements validatedElements) {
        Set<? extends Element> layoutAnnotatedElements = validatedElements.getRootAnnotatedElements(annotation.getName());
        return layoutAnnotatedElements.contains(element);
    }

    public void throwsOnlyRestClientException(ExecutableElement element, IsValid valid) {
        List<? extends TypeMirror> thrownTypes = element.getThrownTypes();
        if (!(thrownTypes.size() <= 0 || thrownTypes.size() <= 1 && ((Object)thrownTypes.get(0)).toString().equals("org.springframework.web.client.RestClientException"))) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated methods can only declare throwing a RestClientException");
        }
    }

    public void elementHasGetOrPostAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        if (!this.elementHasAnnotation(Get.class, element) && !this.elementHasAnnotation(Post.class, element)) {
            this.annotationHelper.printAnnotationError(element, "%s can only be used in an interface annotated with Get or Post annotation");
        }
    }

    public void typeHasAnnotation(Class<? extends Annotation> annotation, Element element, IsValid valid) {
        TypeMirror elementType = element.asType();
        this.typeHasAnnotation(annotation, elementType, element, valid);
    }

    public void typeHasAnnotation(Class<? extends Annotation> annotation, TypeMirror elementType, Element reportingElement, IsValid valid) {
        Element typeElement = this.annotationHelper.getTypeUtils().asElement(elementType);
        if (!this.elementHasAnnotationSafe(annotation, typeElement)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(reportingElement, "%s can only be used on an element annotated with " + TargetAnnotationHelper.annotationName(annotation));
        }
    }

    public void typeOrTargetValueHasAnnotation(Class<? extends Annotation> annotation, Element element, IsValid valid) {
        DeclaredType targetAnnotationClassValue = this.annotationHelper.extractAnnotationClassParameter(element);
        if (targetAnnotationClassValue != null) {
            this.typeHasAnnotation(annotation, targetAnnotationClassValue, element, valid);
            if (!this.annotationHelper.getTypeUtils().isAssignable(targetAnnotationClassValue, element.asType())) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "The value of %s must be assignable into the annotated field");
            }
        } else {
            this.typeHasAnnotation(annotation, element, valid);
        }
    }

    private boolean elementHasAnnotationSafe(Class<? extends Annotation> annotation, Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotation.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean elementHasAnnotation(Class<? extends Annotation> annotation, Element element) {
        return element.getAnnotation(annotation) != null;
    }

    public void elementHasRestAnnotation(Element element, AnnotationElements validatedElements, IsValid valid) {
        String error = "can only be used in an interface annotated with";
        this.elementHasAnnotation(Rest.class, element, validatedElements, valid, error);
    }

    public void returnTypeNotGenericUnlessResponseEntity(ExecutableElement element, IsValid valid) {
        DeclaredType declaredReturnType;
        TypeMirror returnType = element.getReturnType();
        TypeKind returnKind = returnType.getKind();
        if (returnKind == TypeKind.DECLARED && !(declaredReturnType = (DeclaredType)returnType).toString().startsWith("org.springframework.http.ResponseEntity<") && declaredReturnType.getTypeArguments().size() > 0) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated methods cannot return parameterized types, except for ResponseEntity");
        }
    }

    public void hasHttpHeadersReturnType(ExecutableElement element, IsValid valid) {
        String returnType = ((Object)element.getReturnType()).toString();
        if (!returnType.equals("org.springframework.http.HttpHeaders")) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated methods can only return a HttpHeaders, not " + returnType);
        }
    }

    public void hasSetOfHttpMethodReturnType(ExecutableElement element, IsValid valid) {
        TypeMirror returnType = element.getReturnType();
        String returnTypeString = ((Object)returnType).toString();
        if (!returnTypeString.equals("java.util.Set<org.springframework.http.HttpMethod>")) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated methods can only return a Set of HttpMethod, not " + returnTypeString);
        } else {
            DeclaredType declaredType = (DeclaredType)returnType;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.size() != 1) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "%s annotated methods can only return a parameterized Set (with HttpMethod)");
            } else {
                TypeMirror typeArgument = typeArguments.get(0);
                if (!((Object)typeArgument).toString().equals("org.springframework.http.HttpMethod")) {
                    valid.invalidate();
                    this.annotationHelper.printAnnotationError(element, "%s annotated methods can only return a parameterized Set of HttpMethod, not " + ((Object)typeArgument).toString());
                }
            }
        }
    }

    public void urlVariableNamesExistInParameters(ExecutableElement element, List<String> variableNames, IsValid valid) {
        List<? extends VariableElement> parameters = element.getParameters();
        ArrayList<String> parametersName = new ArrayList<String>();
        for (VariableElement variableElement : parameters) {
            parametersName.add(variableElement.getSimpleName().toString());
        }
        for (String string : variableNames) {
            if (parametersName.contains(string)) continue;
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated method has an url variable which name could not be found in the method parameters: " + string);
            return;
        }
    }

    public void doesntThrowException(Element element, IsValid valid) {
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.getThrownTypes().size() > 0) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated methods should not declare throwing any exception");
        }
    }

    public void returnTypeIsVoidOrBoolean(ExecutableElement executableElement, IsValid valid) {
        TypeMirror returnType = executableElement.getReturnType();
        TypeKind returnKind = returnType.getKind();
        if (returnKind != TypeKind.BOOLEAN && returnKind != TypeKind.VOID && !((Object)returnType).toString().equals("java.lang.Boolean")) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with a boolean or a void return type");
        }
    }

    public void returnTypeIsVoid(ExecutableElement executableElement, IsValid valid) {
        TypeMirror returnType = executableElement.getReturnType();
        if (returnType.getKind() != TypeKind.VOID) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with a void return type");
        }
    }

    public void zeroOrOneParameter(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() > 1) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with zero or one parameter, instead of " + parameters.size());
        }
    }

    public void zeroParameter(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() > 0) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with zero parameter, instead of " + parameters.size());
        }
    }

    public void zeroOrOneViewParameters(ExecutableElement executableElement, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, "android.view.View", valid);
    }

    public void zeroOrOneMenuItemParameters(ExecutableElement executableElement, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, ANDROID_SHERLOCK_MENU_ITEM_QUALIFIED_NAMES, valid);
    }

    public void zeroOrOneSpecificParameter(ExecutableElement executableElement, String parameterTypeQualifiedName, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, Arrays.asList(parameterTypeQualifiedName), valid);
    }

    public void zeroOrOneSpecificParameter(ExecutableElement executableElement, List<String> parameterTypeQualifiedNames, IsValid valid) {
        VariableElement parameter;
        TypeMirror parameterType;
        this.zeroOrOneParameter(executableElement, valid);
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() == 1 && !parameterTypeQualifiedNames.contains(((Object)(parameterType = (parameter = parameters.get(0)).asType())).toString())) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with no parameter or a parameter of type " + parameterTypeQualifiedNames + ", not " + parameterType);
        }
    }

    public void zeroOrOneBundleParameter(ExecutableElement executableElement, IsValid valid) {
        this.zeroOrOneSpecificParameter(executableElement, "android.os.Bundle", valid);
    }

    public void extendsActivity(Element element, IsValid valid) {
        this.extendsType(element, "android.app.Activity", valid);
    }

    public void extendsFragment(Element element, IsValid valid) {
        this.extendsOneOfTypes(element, ANDROID_FRAGMENT_QUALIFIED_NAMES, valid);
    }

    public void extendsService(Element element, IsValid valid) {
        this.extendsType(element, "android.app.Service", valid);
    }

    public void extendsReceiver(Element element, IsValid valid) {
        this.extendsType(element, "android.content.BroadcastReceiver", valid);
    }

    public void extendsProvider(Element element, IsValid valid) {
        this.extendsType(element, "android.content.ContentProvider", valid);
    }

    public void extendsView(Element element, IsValid valid) {
        this.extendsType(element, "android.view.View", valid);
    }

    public void extendsTextView(Element element, IsValid valid) {
        this.extendsType(element, "android.widget.TextView", valid);
    }

    public void extendsViewGroup(Element element, IsValid valid) {
        this.extendsType(element, "android.view.ViewGroup", valid);
    }

    public void extendsApplication(Element element, IsValid valid) {
        this.extendsType(element, "android.app.Application", valid);
    }

    public void extendsContext(Element element, IsValid valid) {
        this.extendsType(element, "android.content.Context", valid);
    }

    public void extendsOrmLiteDaoWithValidModelParameter(Element element, IsValid valid) {
        TypeMirror elementType = element.asType();
        TypeMirror modelTypeMirror = (TypeMirror)this.annotationHelper.extractAnnotationParameter(element, "model");
        TypeElement daoTypeElement = this.annotationHelper.typeElementFromQualifiedName("com.j256.ormlite.dao.Dao");
        if (daoTypeElement != null) {
            WildcardType wildcardType = this.annotationHelper.getTypeUtils().getWildcardType(null, null);
            DeclaredType daoParameterizedType = this.annotationHelper.getTypeUtils().getDeclaredType(daoTypeElement, modelTypeMirror, wildcardType);
            if (!this.annotationHelper.isSubtype(elementType, daoParameterizedType)) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "%s can only be used on an element that extends " + daoParameterizedType.toString());
            }
        }
    }

    public void hasASqlLiteOpenHelperParameterizedType(Element element, IsValid valid) {
        TypeMirror openHelperType;
        TypeMirror helperType = (TypeMirror)this.annotationHelper.extractAnnotationParameter(element, "helper");
        if (!this.annotationHelper.isSubtype(helperType, openHelperType = this.annotationHelper.typeElementFromQualifiedName("android.database.sqlite.SQLiteOpenHelper").asType())) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s helper() parameter must extend android.database.sqlite.SQLiteOpenHelper");
        }
    }

    public void upperclassOfRegisteredApplication(Element element, AndroidManifest manifest, IsValid valid) {
        if (manifest.isLibraryProject()) {
            return;
        }
        String applicationClassName = manifest.getApplicationClassName();
        if (applicationClassName != null) {
            if (applicationClassName.endsWith("_")) {
                applicationClassName = applicationClassName.substring(0, applicationClassName.length() - "_".length());
            }
            TypeMirror elementType = element.asType();
            TypeMirror manifestType = this.annotationHelper.typeElementFromQualifiedName(applicationClassName).asType();
            if (!this.annotationHelper.isSubtype(manifestType, elementType)) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "%s can only be used on an element that is an instance of the following class (or one of it's superclass): " + applicationClassName);
            }
        } else {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "No application class is registered in the AndroidManifest.xml");
        }
    }

    public void applicationRegistered(Element element, AndroidManifest manifest, IsValid valid) {
        if (manifest.isLibraryProject()) {
            return;
        }
        String applicationClassName = manifest.getApplicationClassName();
        if (applicationClassName != null) {
            TypeElement typeElement = (TypeElement)element;
            String componentQualifiedName = typeElement.getQualifiedName().toString();
            String generatedComponentQualifiedName = componentQualifiedName + "_";
            if (!applicationClassName.equals(generatedComponentQualifiedName)) {
                if (applicationClassName.equals(componentQualifiedName)) {
                    valid.invalidate();
                    this.annotationHelper.printAnnotationError(element, "The AndroidManifest.xml file contains the original component, and not the AndroidAnnotations generated component. Please register " + generatedComponentQualifiedName + " instead of " + componentQualifiedName);
                } else {
                    this.annotationHelper.printAnnotationWarning(element, "The component " + generatedComponentQualifiedName + " is not registered in the AndroidManifest.xml file.");
                }
            }
        } else {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "No application class registered in the AndroidManifest.xml");
        }
    }

    public void isSharedPreference(Element element, AnnotationElements validatedElements, IsValid valid) {
        TypeMirror type = element.asType();
        if (type instanceof ErrorType) {
            String elementTypeName = ((Object)type).toString();
            boolean sharedPrefValidatedInRound = false;
            if (elementTypeName.endsWith("_")) {
                String prefTypeName = elementTypeName.substring(0, elementTypeName.length() - "_".length());
                Set<? extends Element> sharedPrefElements = validatedElements.getRootAnnotatedElements(SharedPref.class.getName());
                for (Element element2 : sharedPrefElements) {
                    TypeElement sharedPrefTypeElement = (TypeElement)element2;
                    String sharedPrefQualifiedName = sharedPrefTypeElement.getQualifiedName().toString();
                    if (!sharedPrefQualifiedName.endsWith(prefTypeName)) continue;
                    sharedPrefValidatedInRound = true;
                    break;
                }
            }
            if (!sharedPrefValidatedInRound) {
                valid.invalidate();
            }
        } else {
            this.extendsType(element, SharedPreferencesHelper.class.getName(), valid);
        }
    }

    public void extendsOneOfTypes(Element element, List<String> typeQualifiedNames, IsValid valid) {
        TypeMirror elementType = element.asType();
        for (String typeQualifiedName : typeQualifiedNames) {
            TypeMirror expectedType;
            TypeElement typeElement = this.annotationHelper.typeElementFromQualifiedName(typeQualifiedName);
            if (typeElement == null || !this.annotationHelper.isSubtype(elementType, expectedType = typeElement.asType())) continue;
            return;
        }
        valid.invalidate();
        this.annotationHelper.printAnnotationError(element, "%s can only be used on an element that extends one of the following classes: " + typeQualifiedNames);
    }

    public void extendsType(Element element, String typeQualifiedName, IsValid valid) {
        TypeMirror expectedType;
        TypeMirror elementType = element.asType();
        TypeElement typeElement = this.annotationHelper.typeElementFromQualifiedName(typeQualifiedName);
        if (typeElement != null && !this.annotationHelper.isSubtype(elementType, expectedType = typeElement.asType())) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on an element that extends " + typeQualifiedName);
        }
    }

    public void hasOneOrTwoParametersAndFirstIsBoolean(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() < 1 || parameters.size() > 2) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with 1 or 2 parameter, instead of " + parameters.size());
        } else {
            VariableElement firstParameter = parameters.get(0);
            TypeKind parameterKind = firstParameter.asType().getKind();
            if (parameterKind != TypeKind.BOOLEAN && !firstParameter.toString().equals("java.lang.Boolean")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the first parameter should be a boolean");
            }
        }
    }

    public void allowedType(Element element, IsValid valid, TypeMirror fieldTypeMirror, List<String> allowedTypes) {
        String qualifiedName = ((Object)fieldTypeMirror).toString();
        if (!allowedTypes.contains(qualifiedName)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on a field which is a " + allowedTypes.toString() + ", not " + qualifiedName);
        }
    }

    public void hasRoboGuiceJars(Element element, IsValid valid) {
        Elements elementUtils = this.annotationHelper.getElementUtils();
        if (elementUtils.getTypeElement("roboguice.inject.InjectorProvider") == null) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Could not find the RoboGuice framework in the classpath, the following class is missing: roboguice.inject.InjectorProvider");
        }
        if (elementUtils.getTypeElement("roboguice.application.RoboApplication") == null) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Could not find the RoboApplication class in the classpath, are you using RoboGuice 1.1.1 ?");
        }
        try {
            if (elementUtils.getTypeElement("com.google.inject.Injector") == null) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "Could not find the Guice framework in the classpath, the following class is missing: com.google.inject.Injector");
            }
        }
        catch (RuntimeException e) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Could not find the Guice framework in the classpath, the following class is missing: com.google.inject.Injector");
        }
    }

    public void hasSpringAndroidJars(Element element, IsValid valid) {
        Elements elementUtils = this.annotationHelper.getElementUtils();
        if (elementUtils.getTypeElement("org.springframework.web.client.RestTemplate") == null) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Could not find the SpringAndroid framework in the classpath, the following class is missing: org.springframework.web.client.RestTemplate");
        }
    }

    public void hasOrmLiteJars(Element element, IsValid valid) {
        Elements elementUtils = this.annotationHelper.getElementUtils();
        if (elementUtils.getTypeElement("com.j256.ormlite.dao.Dao") == null) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Could not find the OrmLite framework in the classpath, the following class is missing: com.j256.ormlite.dao.Dao");
        }
    }

    public void androidService(AndroidSystemServices androidSystemServices, Element element, IsValid valid) {
        TypeMirror serviceType = element.asType();
        if (!androidSystemServices.contains(serviceType)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "Unknown service type: " + ((Object)serviceType).toString());
        }
    }

    public void hasOneMotionEventOrTwoMotionEventViewParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() < 1 || parameters.size() > 2) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "%s can only be used on a method with 1 (MotionEvent) or 2 (MotionEvent, View) parameters, instead of " + parameters.size());
        } else {
            VariableElement secondParameter;
            String secondParameterType;
            VariableElement firstParameter = parameters.get(0);
            String firstParameterType = ((Object)firstParameter.asType()).toString();
            if (!firstParameterType.equals("android.view.MotionEvent")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the first parameter must be a android.view.MotionEvent, not a " + firstParameterType);
            }
            if (parameters.size() == 2 && !(secondParameterType = ((Object)(secondParameter = parameters.get(1)).asType()).toString()).equals("android.view.View")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the second parameter must be a android.view.View, not a " + secondParameterType);
            }
        }
    }

    public void hasOneOrTwoParametersAndFirstIsDb(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters.size() < 1) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "There should be at least 1 parameter: a android.database.sqlite.SQLiteDatabase");
        } else {
            VariableElement firstParameter = parameters.get(0);
            String firstParameterType = ((Object)firstParameter.asType()).toString();
            if (!firstParameterType.equals("android.database.sqlite.SQLiteDatabase")) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(executableElement, "the first parameter must be a android.database.sqlite.SQLiteDatabase, not a " + firstParameterType);
            }
        }
    }

    public void isDeclaredType(Element element, IsValid valid, TypeMirror uiFieldTypeMirror) {
        if (!(uiFieldTypeMirror instanceof DeclaredType)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s can only be used on a field which is a declared type");
        }
    }

    public boolean isPrefMethod(Element element) {
        if (!element.getKind().equals((Object)ElementKind.METHOD)) {
            this.annotationHelper.printError(element, "Only methods are allowed in an " + this.annotationHelper.annotationName() + " annotated interface");
        } else {
            ExecutableElement executableElement = (ExecutableElement)element;
            String methodName = executableElement.getSimpleName().toString();
            if (executableElement.getParameters().size() > 0) {
                this.annotationHelper.printError(element, "Method " + methodName + " should have no parameters in an " + this.annotationHelper.annotationName() + " annotated interface");
            } else {
                String returnType = ((Object)executableElement.getReturnType()).toString();
                if (!VALID_PREF_RETURN_TYPES.contains(returnType)) {
                    this.annotationHelper.printError(element, "Method " + methodName + " should only return preference simple types in an " + this.annotationHelper.annotationName() + " annotated interface");
                } else if (INVALID_PREF_METHOD_NAMES.contains(methodName)) {
                    this.annotationHelper.printError(element, "The method name " + methodName + " is forbidden in an " + this.annotationHelper.annotationName() + " annotated interface");
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    public void hasCorrectDefaultAnnotation(ExecutableElement method) {
        this.checkDefaultAnnotation(method, DefaultBoolean.class, "boolean", new TypeKindAnnotationCondition(TypeKind.BOOLEAN));
        this.checkDefaultAnnotation(method, DefaultFloat.class, "float", new TypeKindAnnotationCondition(TypeKind.FLOAT));
        this.checkDefaultAnnotation(method, DefaultInt.class, "int", new TypeKindAnnotationCondition(TypeKind.INT));
        this.checkDefaultAnnotation(method, DefaultLong.class, "long", new TypeKindAnnotationCondition(TypeKind.LONG));
        this.checkDefaultAnnotation(method, DefaultString.class, "String", new DefaultAnnotationCondition(){

            @Override
            public boolean correctReturnType(TypeMirror returnType) {
                return ((Object)returnType).toString().equals(CanonicalNameConstants.STRING);
            }
        });
    }

    private <T extends Annotation> void checkDefaultAnnotation(ExecutableElement method, Class<T> annotationClass, String expectedReturnType, DefaultAnnotationCondition condition) {
        T defaultAnnotation = method.getAnnotation(annotationClass);
        if (defaultAnnotation != null && !condition.correctReturnType(method.getReturnType())) {
            this.annotationHelper.printAnnotationError(method, annotationClass, TargetAnnotationHelper.annotationName(annotationClass) + " can only be used on a method that returns a " + expectedReturnType);
        }
    }

    public void unannotatedMethodReturnsRestTemplate(TypeElement typeElement, IsValid valid) {
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        boolean foundGetRestTemplateMethod = false;
        boolean foundSetRestTemplateMethod = false;
        boolean foundSetRootUrlMethod = false;
        for (Element element : enclosedElements) {
            if (element.getKind() != ElementKind.METHOD) {
                valid.invalidate();
                this.annotationHelper.printError(element, "Only methods are allowed in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                continue;
            }
            boolean hasRestAnnotation = false;
            for (Class<? extends Annotation> annotationClass : REST_ANNOTATION_CLASSES) {
                if (element.getAnnotation(annotationClass) == null) continue;
                hasRestAnnotation = true;
                break;
            }
            if (hasRestAnnotation) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            TypeMirror returnType = executableElement.getReturnType();
            if (((Object)returnType).toString().equals("org.springframework.web.client.RestTemplate")) {
                if (executableElement.getParameters().size() > 0) {
                    valid.invalidate();
                    this.annotationHelper.printError(element, "The method returning a RestTemplate should not declare any parameter in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                if (foundGetRestTemplateMethod) {
                    valid.invalidate();
                    this.annotationHelper.printError(element, "Only one method should declare returning a RestTemplate in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                foundGetRestTemplateMethod = true;
                continue;
            }
            if (returnType.getKind() == TypeKind.VOID) {
                List<? extends VariableElement> parameters = executableElement.getParameters();
                if (parameters.size() == 1) {
                    VariableElement firstParameter = parameters.get(0);
                    if (((Object)firstParameter.asType()).toString().equals("org.springframework.web.client.RestTemplate")) {
                        if (!foundSetRestTemplateMethod) {
                            foundSetRestTemplateMethod = true;
                            continue;
                        }
                        valid.invalidate();
                        this.annotationHelper.printError(element, "You can only have oneRestTemplate setter method on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                        continue;
                    }
                    if (executableElement.getSimpleName().toString().equals(METHOD_NAME_SET_ROOT_URL) && !foundSetRootUrlMethod) {
                        foundSetRootUrlMethod = true;
                        continue;
                    }
                    valid.invalidate();
                    this.annotationHelper.printError(element, "The method to set a RestTemplate should have only one RestTemplate parameter on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                    continue;
                }
                valid.invalidate();
                this.annotationHelper.printError(element, "The method to set a RestTemplate should have only one RestTemplate parameter on a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface");
                continue;
            }
            valid.invalidate();
            this.annotationHelper.printError(element, "All methods should be annotated in a " + TargetAnnotationHelper.annotationName(Rest.class) + " annotated interface, except the ones that returns or set a RestTemplate");
        }
    }

    public void notAlreadyValidated(Element element, AnnotationElements validatedElements, IsValid valid) {
        if (validatedElements.getAllElements().contains(element)) {
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "%s annotated element cannot be used with the other annotations used on this element.");
        }
    }

    public void hasEmptyOrContextConstructor(Element element, IsValid valid) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        if (constructors.size() == 1) {
            ExecutableElement constructor = constructors.get(0);
            if (!this.annotationHelper.isPrivate(constructor)) {
                VariableElement parameter;
                if (constructor.getParameters().size() > 1) {
                    this.annotationHelper.printAnnotationError(element, "%s annotated element should have a constructor with one parameter max, of type android.content.Context");
                    valid.invalidate();
                } else if (constructor.getParameters().size() == 1 && !((Object)(parameter = constructor.getParameters().get(0)).asType()).toString().equals("android.content.Context")) {
                    this.annotationHelper.printAnnotationError(element, "%s annotated element should have a constructor with one parameter max, of type android.content.Context");
                    valid.invalidate();
                }
            } else {
                this.annotationHelper.printAnnotationError(element, "%s annotated element should not have a private constructor");
                valid.invalidate();
            }
        } else {
            this.annotationHelper.printAnnotationError(element, "%s annotated element should have only one constructor");
            valid.invalidate();
        }
    }

    public void hasEmptyConstructor(Element element, IsValid valid) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        if (constructors.size() == 1) {
            ExecutableElement constructor = constructors.get(0);
            if (!this.annotationHelper.isPrivate(constructor)) {
                if (constructor.getParameters().size() != 0) {
                    this.annotationHelper.printAnnotationError(element, "%s annotated element should have an empty constructor");
                    valid.invalidate();
                }
            } else {
                this.annotationHelper.printAnnotationError(element, "%s annotated element should not have a private constructor");
                valid.invalidate();
            }
        } else {
            this.annotationHelper.printAnnotationError(element, "%s annotated element should have only one constructor");
            valid.invalidate();
        }
    }

    public void hasValidLogLevel(Element element, IsValid isValid) {
        Trace annotation = element.getAnnotation(Trace.class);
        Integer level = annotation.level();
        if (!VALID_LOG_LEVELS.contains(level)) {
            this.annotationHelper.printError(element, "Unrecognized log level.");
            isValid.invalidate();
        }
    }

    public void canBeSavedAsInstanceState(Element element, IsValid isValid) {
        String typeString = ((Object)element.asType()).toString();
        if (!this.isKnowInstanceStateType(typeString)) {
            if (element.asType() instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)element.asType();
                typeString = declaredType.asElement().toString();
            } else if (element.asType() instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)element.asType();
                TypeMirror componentType = arrayType.getComponentType();
                if (componentType instanceof DeclaredType) {
                    DeclaredType declaredType = (DeclaredType)componentType;
                    typeString = declaredType.asElement().toString();
                } else {
                    typeString = ((Object)componentType).toString();
                }
            } else {
                typeString = ((Object)element.asType()).toString();
            }
            TypeElement elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
            if (elementType == null && (elementType = this.getArrayEnclosingType(typeString)) == null) {
                this.annotationHelper.printAnnotationError(element, "Unrecognized type. Please let your attribute be primitive or implement Serializable or Parcelable");
                isValid.invalidate();
            }
            if (elementType != null) {
                TypeElement parcelableType = this.annotationHelper.typeElementFromQualifiedName("android.os.Parcelable");
                TypeElement serializableType = this.annotationHelper.typeElementFromQualifiedName("java.io.Serializable");
                if (!this.annotationHelper.isSubtype(elementType, parcelableType) && !this.annotationHelper.isSubtype(elementType, serializableType)) {
                    this.annotationHelper.printAnnotationError(element, "Unrecognized type. Please let your attribute be primitive or implement Serializable or Parcelable");
                    isValid.invalidate();
                }
            }
        }
    }

    private TypeElement getArrayEnclosingType(String typeString) {
        typeString = typeString.replace("[]", "");
        return this.annotationHelper.typeElementFromQualifiedName(typeString);
    }

    private boolean isKnowInstanceStateType(String type) {
        return InstanceStateProcessor.methodSuffixNameByTypeName.containsKey(type);
    }

    public void componentRegistered(Element element, AndroidManifest androidManifest, IsValid valid) {
        this.componentRegistered(element, androidManifest, true, valid);
    }

    public void componentRegistered(Element element, AndroidManifest androidManifest, boolean printWarning, IsValid valid) {
        TypeElement typeElement = (TypeElement)element;
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        if (androidManifest.isLibraryProject()) {
            return;
        }
        String componentQualifiedName = typeElement.getQualifiedName().toString();
        String generatedComponentQualifiedName = componentQualifiedName + "_";
        List<String> componentQualifiedNames = androidManifest.getComponentQualifiedNames();
        if (!componentQualifiedNames.contains(generatedComponentQualifiedName)) {
            String simpleName = typeElement.getSimpleName().toString();
            String generatedSimpleName = simpleName + "_";
            if (componentQualifiedNames.contains(componentQualifiedName)) {
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "The AndroidManifest.xml file contains the original component, and not the AndroidAnnotations generated component. Please register " + generatedSimpleName + " instead of " + simpleName);
            } else if (printWarning) {
                this.annotationHelper.printAnnotationWarning(element, "The component " + generatedSimpleName + " is not registered in the AndroidManifest.xml file.");
            }
        }
    }

    public void validateConverters(Element element, IsValid valid) {
        TypeMirror httpMessageConverterType = this.annotationHelper.typeElementFromQualifiedName("org.springframework.http.converter.HttpMessageConverter").asType();
        TypeMirror httpMessageConverterTypeErased = this.annotationHelper.getTypeUtils().erasure(httpMessageConverterType);
        List<DeclaredType> converters = this.annotationHelper.extractAnnotationClassArrayParameter(element, this.annotationHelper.getTarget(), "converters");
        for (DeclaredType converterType : converters) {
            TypeMirror erasedConverterType = this.annotationHelper.getTypeUtils().erasure(converterType);
            if (this.annotationHelper.isSubtype(erasedConverterType, httpMessageConverterTypeErased)) {
                Element converterElement = converterType.asElement();
                if (converterElement.getKind().isClass()) {
                    if (!this.annotationHelper.isAbstract(converterElement)) {
                        List<ExecutableElement> constructors = ElementFilter.constructorsIn(converterElement.getEnclosedElements());
                        for (ExecutableElement constructor : constructors) {
                            if (!this.annotationHelper.isPublic(constructor) || !constructor.getParameters().isEmpty()) continue;
                            return;
                        }
                        valid.invalidate();
                        this.annotationHelper.printAnnotationError(element, "The converter class must have a public no argument constructor");
                        continue;
                    }
                    valid.invalidate();
                    this.annotationHelper.printAnnotationError(element, "The converter class must not be abstract");
                    continue;
                }
                valid.invalidate();
                this.annotationHelper.printAnnotationError(element, "The converter class must be a class");
                continue;
            }
            valid.invalidate();
            this.annotationHelper.printAnnotationError(element, "The converter class must be a subtype of org.springframework.http.converter.HttpMessageConverter");
        }
    }

    private class TypeKindAnnotationCondition
    implements DefaultAnnotationCondition {
        private final TypeKind typeKind;

        public TypeKindAnnotationCondition(TypeKind typeKind) {
            this.typeKind = typeKind;
        }

        @Override
        public boolean correctReturnType(TypeMirror returnType) {
            return returnType.getKind() == this.typeKind;
        }
    }

    private static interface DefaultAnnotationCondition {
        public boolean correctReturnType(TypeMirror var1);
    }
}

