/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.EFragment;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.processing.GeneratingElementProcessor;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class EFragmentProcessor
implements GeneratingElementProcessor {
    private final IdAnnotationHelper helper;

    public EFragmentProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.helper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return EFragment.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeansHolder eBeansHolder) throws Exception {
        TypeElement typeElement = (TypeElement)element;
        String beanQualifiedName = typeElement.getQualifiedName().toString();
        String generatedBeanQualifiedName = beanQualifiedName + "_";
        JDefinedClass generatedClass = codeModel._class(9, generatedBeanQualifiedName, ClassType.CLASS);
        EBeanHolder holder = eBeansHolder.create(element, this.getTarget(), generatedClass);
        JClass eBeanClass = codeModel.directClass(beanQualifiedName);
        holder.generatedClass._extends(eBeanClass);
        EBeansHolder.Classes classes = holder.classes();
        holder.init = holder.generatedClass.method(4, codeModel.VOID, "init_");
        holder.init.param(holder.classes().BUNDLE, "savedInstanceState");
        JMethod onCreate = holder.generatedClass.method(1, codeModel.VOID, "onCreate");
        onCreate.annotate(Override.class);
        JVar onCreateSavedInstanceState = onCreate.param(classes.BUNDLE, "savedInstanceState");
        JBlock onCreateBody = onCreate.body();
        onCreateBody.invoke(holder.init).arg(onCreateSavedInstanceState);
        onCreateBody.invoke(JExpr._super(), onCreate).arg(onCreateSavedInstanceState);
        holder.contextRef = JExpr.invoke("getActivity");
        JFieldVar contentView = holder.generatedClass.field(4, classes.VIEW, "contentView_");
        holder.afterSetContentView = holder.generatedClass.method(4, codeModel.VOID, "afterSetContentView_");
        JMethod onCreateView = holder.generatedClass.method(1, classes.VIEW, "onCreateView");
        onCreateView.annotate(Override.class);
        JVar inflater = onCreateView.param(classes.LAYOUT_INFLATER, "inflater");
        JVar container = onCreateView.param(classes.VIEW_GROUP, "container");
        JVar savedInstanceState = onCreateView.param(classes.BUNDLE, "savedInstanceState");
        JBlock body = onCreateView.body();
        body.assign(contentView, JExpr._super().invoke(onCreateView).arg(inflater).arg(container).arg(savedInstanceState));
        JFieldRef contentViewId = this.helper.extractOneAnnotationFieldRef(holder, element, IRClass.Res.LAYOUT, false);
        if (contentViewId != null) {
            body._if(contentView.eq(JExpr._null()))._then().assign(contentView, inflater.invoke("inflate").arg(contentViewId).arg(container).arg(JExpr.FALSE));
        }
        body.invoke(holder.afterSetContentView);
        body._return(contentView);
        JMethod findViewById = holder.generatedClass.method(1, classes.VIEW, "findViewById");
        JVar idParam = findViewById.param(codeModel.INT, "id");
        JBlock body2 = findViewById.body();
        body2._if(contentView.eq(JExpr._null()))._then()._return(JExpr._null());
        body2._return(contentView.invoke(findViewById).arg(idParam));
        holder.initIfActivityBody = holder.init.body();
        holder.initActivityRef = holder.contextRef;
        this.addFragmentBuilder(codeModel, holder, eBeanClass);
    }

    private void addFragmentBuilder(JCodeModel codeModel, EBeanHolder holder, JClass eBeanClass) throws JClassAlreadyExistsException {
        JClass bundleClass = holder.classes().BUNDLE;
        holder.fragmentBuilderClass = holder.generatedClass._class(17, "FragmentBuilder_");
        holder.fragmentArgumentsBuilderField = holder.fragmentBuilderClass.field(4, bundleClass, "args_");
        JMethod constructor = holder.fragmentBuilderClass.constructor(4);
        JBlock constructorBody = constructor.body();
        constructorBody.assign(holder.fragmentArgumentsBuilderField, JExpr._new(bundleClass));
        JMethod method = holder.fragmentBuilderClass.method(1, eBeanClass, "build");
        JBlock body = method.body();
        JVar fragment = body.decl(holder.generatedClass, "fragment_", JExpr._new(holder.generatedClass));
        body.invoke((JExpression)fragment, "setArguments").arg(holder.fragmentArgumentsBuilderField);
        body._return(fragment);
        method = holder.generatedClass.method(17, holder.fragmentBuilderClass, "builder");
        method.body()._return(JExpr._new(holder.fragmentBuilderClass));
    }
}

