/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.OnActivityResult;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCase;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JSwitch;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class OnActivityResultProcessor
implements DecoratingElementProcessor {
    private APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public OnActivityResultProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return OnActivityResult.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int intentParameterPosition = -1;
        int resultCodeParameterPosition = -1;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameter.asType();
            if ("android.content.Intent".equals(((Object)parameterType).toString())) {
                intentParameterPosition = i;
                continue;
            }
            if (!parameterType.getKind().equals((Object)TypeKind.INT) && !CanonicalNameConstants.INTEGER.equals(((Object)parameterType).toString())) continue;
            resultCodeParameterPosition = i;
        }
        int requestCode = executableElement.getAnnotation(OnActivityResult.class).value();
        JCase onActivityResultCase = this.getOrCreateOnActivityResultMethodBody(codeModel, holder, requestCode);
        JFieldRef activityRef = holder.generatedClass.staticRef("this");
        JInvocation onResultInvocation = onActivityResultCase.body().invoke((JExpression)activityRef, methodName);
        for (int i = 0; i < parameters.size(); ++i) {
            if (i == intentParameterPosition) {
                JVar intentParameter = this.codeModelHelper.findParameterByName(holder.onActivityResultMethod, "data");
                onResultInvocation.arg(intentParameter);
                continue;
            }
            if (i != resultCodeParameterPosition) continue;
            JVar resultCodeParameter = this.codeModelHelper.findParameterByName(holder.onActivityResultMethod, "resultCode");
            onResultInvocation.arg(resultCodeParameter);
        }
    }

    public JCase getOrCreateOnActivityResultMethodBody(JCodeModel codeModel, EBeanHolder holder, int requestCode) {
        JClass intentClass = holder.classes().INTENT;
        if (holder.onActivityResultSwitch == null) {
            JMethod onActivityResultMethod = holder.generatedClass.method(1, codeModel.VOID, "onActivityResult");
            JVar requestCodeParam = onActivityResultMethod.param(codeModel.INT, "requestCode");
            onActivityResultMethod.param(codeModel.INT, "resultCode");
            onActivityResultMethod.param(intentClass, "data");
            onActivityResultMethod.annotate(Override.class);
            holder.onActivityResultMethod = onActivityResultMethod;
            JBlock onActivityResultMethodBody = onActivityResultMethod.body();
            this.codeModelHelper.callSuperMethod(onActivityResultMethod, holder, onActivityResultMethodBody);
            holder.onActivityResultSwitch = onActivityResultMethodBody._switch(requestCodeParam);
        }
        JSwitch onActivityResultSwitch = holder.onActivityResultSwitch;
        JCase onActivityResultCase = holder.onActivityResultCases.get(requestCode);
        if (onActivityResultCase == null) {
            onActivityResultCase = onActivityResultSwitch._case(JExpr.lit(requestCode));
            holder.onActivityResultCases.put(requestCode, onActivityResultCase);
        }
        return onActivityResultCase;
    }
}

