/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing.rest;

import com.googlecode.androidannotations.annotations.rest.Accept;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.helper.RestAnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.rest.MethodProcessorHolder;
import com.googlecode.androidannotations.processing.rest.RestImplementationHolder;
import com.googlecode.androidannotations.processing.rest.RestImplementationsHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public abstract class MethodProcessor
implements DecoratingElementProcessor {
    protected final RestImplementationsHolder restImplementationsHolder;
    protected final RestAnnotationHelper restAnnotationHelper;

    public MethodProcessor(ProcessingEnvironment processingEnv, RestImplementationsHolder restImplementationHolder) {
        this.restImplementationsHolder = restImplementationHolder;
        this.restAnnotationHelper = new RestAnnotationHelper(processingEnv, this.getTarget());
    }

    protected void generateRestTemplateCallBlock(MethodProcessorHolder methodHolder) {
        boolean hasParametersInUrl;
        RestImplementationHolder holder = this.restImplementationsHolder.getEnclosingHolder(methodHolder.getElement());
        ExecutableElement executableElement = (ExecutableElement)methodHolder.getElement();
        JClass expectedClass = methodHolder.getExpectedClass();
        JClass generatedReturnType = methodHolder.getGeneratedReturnType();
        String methodName = executableElement.getSimpleName().toString();
        boolean methodReturnVoid = generatedReturnType == null && expectedClass == null;
        JMethod method = methodReturnVoid ? holder.restImplementationClass.method(1, Void.TYPE, methodName) : holder.restImplementationClass.method(1, methodHolder.getGeneratedReturnType(), methodName);
        method.annotate(Override.class);
        JBlock body = method.body();
        JInvocation restCall = JExpr.invoke((JExpression)holder.restTemplateField, "exchange");
        JInvocation concatCall = JExpr.invoke((JExpression)holder.rootUrlField, "concat");
        restCall.arg(concatCall.arg(JExpr.lit(methodHolder.getUrlSuffix())));
        EBeanHolder eBeanHolder = methodHolder.getHolder();
        JClass httpMethod = eBeanHolder.refClass("org.springframework.http.HttpMethod");
        String restMethodInCapitalLetters = this.getTarget().getSimpleName().toUpperCase(Locale.ENGLISH);
        restCall.arg(httpMethod.staticRef(restMethodInCapitalLetters));
        TreeMap methodParams = (TreeMap)this.generateMethodParamsVar(eBeanHolder, method, executableElement, holder);
        methodHolder.setBody(body);
        methodHolder.setMethodParams(methodParams);
        JVar hashMapVar = this.generateHashMapVar(methodHolder);
        restCall = this.addHttpEntityVar(restCall, methodHolder);
        restCall = this.addResponseEntityArg(restCall, methodHolder);
        boolean bl = hasParametersInUrl = hashMapVar != null;
        if (hasParametersInUrl) {
            restCall.arg(hashMapVar);
        }
        restCall = this.addResultCallMethod(restCall, methodHolder);
        this.insertRestCallInBody(body, restCall, methodReturnVoid);
    }

    protected abstract JInvocation addHttpEntityVar(JInvocation var1, MethodProcessorHolder var2);

    protected abstract JInvocation addResponseEntityArg(JInvocation var1, MethodProcessorHolder var2);

    protected abstract JInvocation addResultCallMethod(JInvocation var1, MethodProcessorHolder var2);

    private void insertRestCallInBody(JBlock body, JInvocation restCall, boolean methodReturnVoid) {
        if (methodReturnVoid) {
            body.add(restCall);
        } else {
            body._return(restCall);
        }
    }

    private JVar generateHashMapVar(MethodProcessorHolder methodHolder) {
        ExecutableElement element = (ExecutableElement)methodHolder.getElement();
        JCodeModel codeModel = methodHolder.getCodeModel();
        JBlock body = methodHolder.getBody();
        TreeMap<String, JVar> methodParams = methodHolder.getMethodParams();
        JVar hashMapVar = null;
        List<String> urlVariables = this.restAnnotationHelper.extractUrlVariableNames(element);
        JClass hashMapClass = codeModel.ref(HashMap.class).narrow(String.class, Object.class);
        if (!urlVariables.isEmpty()) {
            hashMapVar = body.decl(hashMapClass, "urlVariables", JExpr._new(hashMapClass));
            for (String urlVariable : urlVariables) {
                body.invoke((JExpression)hashMapVar, "put").arg(urlVariable).arg(methodParams.get(urlVariable));
                methodParams.remove(urlVariable);
            }
        }
        return hashMapVar;
    }

    protected JVar generateHttpEntityVar(MethodProcessorHolder methodHolder) {
        boolean hasHeaders;
        ExecutableElement executableElement = (ExecutableElement)methodHolder.getElement();
        EBeanHolder holder = methodHolder.getHolder();
        JClass httpEntity = holder.refClass("org.springframework.http.HttpEntity");
        TreeMap<String, JVar> methodParams = methodHolder.getMethodParams();
        JVar entitySentToServer = null;
        JType entityType = null;
        if (!methodParams.isEmpty()) {
            entitySentToServer = methodParams.firstEntry().getValue();
            entityType = entitySentToServer.type();
        }
        JInvocation newHttpEntityVarCall = entitySentToServer != null ? JExpr._new(httpEntity.narrow(entityType)) : JExpr._new(httpEntity.narrow((Class<?>)Object.class));
        JBlock body = methodHolder.getBody();
        JVar httpHeadersVar = this.generateHttpHeadersVar(holder, body, executableElement);
        boolean bl = hasHeaders = httpHeadersVar != null;
        if (entitySentToServer != null) {
            newHttpEntityVarCall.arg(entitySentToServer);
        }
        if (hasHeaders) {
            newHttpEntityVarCall.arg(httpHeadersVar);
        } else if (methodParams.isEmpty()) {
            newHttpEntityVarCall.arg(JExpr._null());
        }
        String httpEntityVarName = "requestEntity";
        JVar httpEntityVar = entitySentToServer != null ? body.decl(httpEntity.narrow(entityType), httpEntityVarName, newHttpEntityVarCall) : body.decl(httpEntity.narrow((Class<?>)Object.class), httpEntityVarName, newHttpEntityVarCall);
        return httpEntityVar;
    }

    protected JVar generateHttpHeadersVar(EBeanHolder holder, JBlock body, ExecutableElement executableElement) {
        boolean hasMediaTypeDefined;
        JVar httpHeadersVar = null;
        JClass httpHeadersClass = holder.refClass("org.springframework.http.HttpHeaders");
        httpHeadersVar = body.decl(httpHeadersClass, "httpHeaders", JExpr._new(httpHeadersClass));
        String mediaType = this.retrieveAcceptAnnotationValue(executableElement);
        boolean bl = hasMediaTypeDefined = mediaType != null;
        if (hasMediaTypeDefined) {
            JClass collectionsClass = holder.refClass(CanonicalNameConstants.COLLECTIONS);
            JClass mediaTypeClass = holder.refClass("org.springframework.http.MediaType");
            JInvocation mediaTypeListParam = collectionsClass.staticInvoke("singletonList").arg(mediaTypeClass.staticInvoke("parseMediaType").arg(mediaType));
            body.add(JExpr.invoke((JExpression)httpHeadersVar, "setAccept").arg(mediaTypeListParam));
        }
        return httpHeadersVar;
    }

    private String retrieveAcceptAnnotationValue(ExecutableElement executableElement) {
        Accept acceptAnnotation = executableElement.getAnnotation(Accept.class);
        if (acceptAnnotation == null) {
            acceptAnnotation = executableElement.getEnclosingElement().getAnnotation(Accept.class);
        }
        if (acceptAnnotation != null) {
            return acceptAnnotation.value();
        }
        return null;
    }

    private Map<String, JVar> generateMethodParamsVar(EBeanHolder eBeanHolder, JMethod method, ExecutableElement executableElement, RestImplementationHolder holder) {
        List<? extends VariableElement> params = executableElement.getParameters();
        TreeMap<String, JVar> methodParams = new TreeMap<String, JVar>();
        for (VariableElement variableElement : params) {
            String paramName = variableElement.getSimpleName().toString();
            String paramType = ((Object)variableElement.asType()).toString();
            JVar param = method.param(eBeanHolder.refClass(paramType), paramName);
            methodParams.put(paramName, param);
        }
        return methodParams;
    }

    protected abstract JVar addHttpHeadersVar(JBlock var1, ExecutableElement var2);

    @Override
    public abstract Class<? extends Annotation> getTarget();

    @Override
    public abstract void process(Element var1, JCodeModel var2, EBeanHolder var3) throws Exception;
}

