/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.rclass;

import com.googlecode.androidannotations.helper.AndroidManifest;
import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.rclass.RClass;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public class ProjectRClassFinder {
    private ProcessingEnvironment processingEnv;

    public ProjectRClassFinder(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public IRClass find(AndroidManifest manifest) {
        String rClass;
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement rType = elementUtils.getTypeElement(rClass = manifest.getApplicationPackage() + ".R");
        if (rType == null) {
            Messager messager = this.processingEnv.getMessager();
            messager.printMessage(Diagnostic.Kind.WARNING, "The AndroidManifest.xml file was found, but not the compiled R class: " + rClass);
            return IRClass.EMPTY_R_CLASS;
        }
        return new RClass(rType);
    }
}

