/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class UniformDataGenerator {
    Random rand = new Random();

    public UniformDataGenerator() {
        this.rand = new Random();
    }

    public UniformDataGenerator(int seed) {
        this.rand = new Random(seed);
    }

    int[] generateUniformHash(int N, int Max) {
        if (N > Max) {
            throw new RuntimeException("not possible");
        }
        int[] ans = new int[N];
        HashSet<Integer> s = new HashSet<Integer>();
        while (s.size() < N) {
            s.add(new Integer(this.rand.nextInt(Max)));
        }
        Iterator i = s.iterator();
        for (int k = 0; k < N; ++k) {
            ans[k] = (Integer)i.next();
        }
        Arrays.sort(ans);
        return ans;
    }

    static int[] negate(int[] x, int Max) {
        int[] ans = new int[Max - x.length];
        int i = 0;
        int c = 0;
        for (int j = 0; j < x.length; ++j) {
            int v = x[j];
            while (i < v) {
                ans[c++] = i++;
            }
            ++i;
        }
        while (c < ans.length) {
            ans[c++] = i++;
        }
        return ans;
    }

    public int[] generateUniform(int N, int Max) {
        if (N * 2 > Max) {
            return UniformDataGenerator.negate(this.generateUniform(Max - N, Max), Max);
        }
        if (2048 * N > Max) {
            return this.generateUniformBitmap(N, Max);
        }
        return this.generateUniformHash(N, Max);
    }

    int[] generateUniformBitmap(int N, int Max) {
        if (N > Max) {
            throw new RuntimeException("not possible");
        }
        int[] ans = new int[N];
        BitSet bs = new BitSet(Max);
        int cardinality = 0;
        while (cardinality < N) {
            int v = this.rand.nextInt(Max);
            if (bs.get(v)) continue;
            bs.set(v);
            ++cardinality;
        }
        int pos = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            ans[pos++] = i;
            i = bs.nextSetBit(i + 1);
        }
        return ans;
    }
}

