/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.redmine.ta.beans.CustomField;
import org.redmine.ta.beans.Issue;
import org.redmine.ta.beans.IssueCategory;
import org.redmine.ta.beans.IssueRelation;
import org.redmine.ta.beans.IssueStatus;
import org.redmine.ta.beans.Project;
import org.redmine.ta.beans.TimeEntry;
import org.redmine.ta.beans.User;
import org.redmine.ta.beans.Version;

public class RedmineXMLGenerator {
    private static final String REDMINE_START_DATE_FORMAT = "yyyy-MM-dd";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    public static String toXML(String projectKey, Issue issue) {
        StringBuilder b = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<issue>");
        RedmineXMLGenerator.appendIfNotNull(b, "project_id", projectKey);
        RedmineXMLGenerator.appendIfNotNull(b, "parent_issue_id", issue.getParentId());
        RedmineXMLGenerator.appendIfNotNull(b, "subject", issue.getSubject());
        if (issue.getTracker() != null) {
            RedmineXMLGenerator.appendIfNotNull(b, "tracker_id", issue.getTracker().getId());
        }
        RedmineXMLGenerator.appendIfNotNull(b, "notes", issue.getNotes());
        RedmineXMLGenerator.appendIfNotNull(b, "status_id", issue.getStatusId());
        if (issue.getStartDate() == null) {
            RedmineXMLGenerator.appendNull(b, "start_date");
        } else {
            RedmineXMLGenerator.appendIfNotNull(b, "start_date", issue.getStartDate());
        }
        RedmineXMLGenerator.appendIfNotNull(b, "due_date", issue.getDueDate());
        if (issue.getEstimatedHours() != null) {
            RedmineXMLGenerator.appendIfNotNull(b, "estimated_hours", issue.getEstimatedHours());
        }
        RedmineXMLGenerator.appendIfNotNull(b, "description", issue.getDescription());
        User ass = issue.getAssignee();
        if (ass != null) {
            RedmineXMLGenerator.appendIfNotNull(b, "assigned_to_id", ass.getId());
        }
        RedmineXMLGenerator.appendIfNotNull(b, "done_ratio", issue.getDoneRatio());
        if (!issue.getCustomFields().isEmpty()) {
            b.append("<custom_fields type=\"array\">");
            for (CustomField field : issue.getCustomFields()) {
                b.append("<custom_field id=\"" + field.getId() + "\" name=\"" + field.getName() + "\">");
                b.append("<value>" + field.getValue() + "</value>");
                b.append("</custom_field>");
            }
            b.append("</custom_fields>");
        }
        if (issue.getTargetVersion() != null) {
            RedmineXMLGenerator.appendIfNotNull(b, "fixed_version_id", issue.getTargetVersion().getId());
            RedmineXMLGenerator.appendIfNotNull(b, "fixed_version_name", issue.getTargetVersion().getName());
        }
        RedmineXMLGenerator.appendIfNotNull(b, "priority_id", issue.getPriorityId());
        b.append("</issue>");
        return b.toString();
    }

    public static String toXML(Object o) {
        if (o instanceof TimeEntry) {
            return RedmineXMLGenerator.toXML((TimeEntry)o);
        }
        if (o instanceof Project) {
            return RedmineXMLGenerator.toXML((Project)o);
        }
        if (o instanceof User) {
            return RedmineXMLGenerator.toXML((User)o);
        }
        if (o instanceof IssueRelation) {
            return RedmineXMLGenerator.toXML((IssueRelation)o);
        }
        if (o instanceof IssueStatus) {
            return RedmineXMLGenerator.toXML((IssueStatus)o);
        }
        if (o instanceof Version) {
            return RedmineXMLGenerator.toXML((Version)o);
        }
        if (o instanceof IssueCategory) {
            return RedmineXMLGenerator.toXML((IssueCategory)o);
        }
        throw new RuntimeException("Object type is not supported.");
    }

    public static String toXML(TimeEntry timeEntry) {
        StringBuilder b = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<time_entry>");
        RedmineXMLGenerator.appendIfNotNull(b, "id", timeEntry.getId());
        RedmineXMLGenerator.appendIfNotNull(b, "issue_id", timeEntry.getIssueId());
        RedmineXMLGenerator.appendIfNotNull(b, "project_id", timeEntry.getProjectId());
        RedmineXMLGenerator.appendIfNotNull(b, "user_id", timeEntry.getUserId());
        RedmineXMLGenerator.appendIfNotNull(b, "activity_id", timeEntry.getActivityId());
        RedmineXMLGenerator.appendIfNotNull(b, "hours", timeEntry.getHours());
        RedmineXMLGenerator.appendIfNotNull(b, "comments", timeEntry.getComment());
        RedmineXMLGenerator.appendIfNotNull(b, "spent_on", timeEntry.getSpentOn());
        b.append("</time_entry>");
        return b.toString();
    }

    public static String toXML(Project o) {
        StringBuilder b = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project>");
        RedmineXMLGenerator.appendIfNotNull(b, "id", o.getId());
        RedmineXMLGenerator.appendIfNotNull(b, "name", o.getName());
        RedmineXMLGenerator.appendIfNotNull(b, "identifier", o.getIdentifier());
        RedmineXMLGenerator.appendIfNotNull(b, "description", o.getDescription());
        RedmineXMLGenerator.appendIfNotNull(b, "homepage", o.getHomepage());
        RedmineXMLGenerator.appendIfNotNull(b, "parent_id", o.getParentId());
        b.append("</project>");
        return b.toString();
    }

    public static String toXML(User o) {
        StringBuilder b = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<user>");
        RedmineXMLGenerator.appendIfNotNull(b, "id", o.getId());
        RedmineXMLGenerator.appendIfNotNull(b, "login", o.getLogin());
        RedmineXMLGenerator.appendIfNotNull(b, "password", o.getPassword());
        RedmineXMLGenerator.appendIfNotNull(b, "firstname", o.getFirstName());
        RedmineXMLGenerator.appendIfNotNull(b, "lastname", o.getLastName());
        RedmineXMLGenerator.appendIfNotNull(b, "mail", o.getMail());
        b.append("</user>");
        return b.toString();
    }

    public static String toXML(IssueRelation o) {
        StringBuilder b = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<relation>");
        RedmineXMLGenerator.appendIfNotNull(b, "issue_to_id", o.getIssueToId());
        RedmineXMLGenerator.appendIfNotNull(b, "relation_type", o.getType());
        b.append("</relation>");
        return b.toString();
    }

    public static String toXML(IssueStatus issueStatus) {
        StringBuilder xmlBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<issue_status>");
        RedmineXMLGenerator.appendIfNotNull(xmlBuilder, "id", issueStatus.getId());
        RedmineXMLGenerator.appendIfNotNull(xmlBuilder, "name", issueStatus.getName());
        xmlBuilder.append("</issue_status>");
        return xmlBuilder.toString();
    }

    public static String toXML(Version version) {
        StringBuilder xmlBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<version>");
        RedmineXMLGenerator.appendIfNotNull(xmlBuilder, "id", version.getId());
        RedmineXMLGenerator.appendIfNotNull(xmlBuilder, "name", version.getName());
        RedmineXMLGenerator.appendIfNotNull(xmlBuilder, "status", version.getStatus());
        RedmineXMLGenerator.appendIfNotNull(xmlBuilder, "description", version.getDescription());
        xmlBuilder.append("</version>");
        return xmlBuilder.toString();
    }

    public static String toXML(IssueCategory issueCategory) {
        StringBuilder xmlBuilder = new StringBuilder(XML_PREFIX).append("<issue_category>");
        RedmineXMLGenerator.appendIfNotNull(xmlBuilder, "id", issueCategory.getId());
        RedmineXMLGenerator.appendIfNotNull(xmlBuilder, "name", issueCategory.getName());
        if (issueCategory.getAssignee() != null) {
            RedmineXMLGenerator.appendIfNotNull(xmlBuilder, "assigned_to_id", issueCategory.getAssignee().getId());
        }
        xmlBuilder.append("</issue_category>");
        return xmlBuilder.toString();
    }

    private static final void appendIfNotNull(StringBuilder b, String tag, Object value) {
        if (value != null) {
            b.append("<" + tag + ">");
            if (value instanceof Date) {
                b.append(sdf.format(value));
            } else if (value instanceof String) {
                b.append(RedmineXMLGenerator.encodeXML((String)value));
            } else {
                b.append(value);
            }
            b.append("</" + tag + ">");
        }
    }

    private static final void appendNull(StringBuilder b, String tag) {
        b.append("<" + tag + ">null</" + tag + ">");
    }

    private static String encodeXML(String value) {
        return value.replace("&", "&amp;").replace("'", "&apos;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

