/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.annotation.RequestType;
import com.graphql_java_generator.client.request.AbstractGraphQLRequest;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.ObjectResponse;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.springframework.graphql.client.GraphQlClient;

public class Builder {
    GraphqlUtils graphqlUtils = GraphqlUtils.graphqlUtils;
    final GraphQlClient graphQlClient;
    final Class<? extends AbstractGraphQLRequest> graphQLRequestClass;
    final String fieldName;
    final RequestType requestType;
    final boolean fullRequest;
    final InputParameter[] inputParams;
    ObjectResponse objectResponse = null;

    public Builder(GraphQlClient graphQlClient, Class<? extends AbstractGraphQLRequest> graphQLRequestClass) {
        this.graphQlClient = graphQlClient;
        this.graphQLRequestClass = graphQLRequestClass;
        this.fieldName = null;
        this.requestType = null;
        this.fullRequest = true;
        this.inputParams = null;
    }

    public Builder(GraphQlClient graphQlClient, Class<? extends AbstractGraphQLRequest> graphQLRequestClass, String fieldName, RequestType requestType, InputParameter ... inputParams) {
        this.graphQlClient = graphQlClient;
        this.graphQLRequestClass = graphQLRequestClass;
        this.fieldName = fieldName;
        this.requestType = requestType;
        this.fullRequest = false;
        InputParameter[] inputParameterArray = this.inputParams = inputParams == null ? new InputParameter[]{} : inputParams;
        if (requestType == null) {
            throw new NullPointerException("The requestType is mandatory");
        }
    }

    public Builder withQueryResponseDef(String queryResponseDef) throws GraphQLRequestPreparationException {
        if (queryResponseDef == null) {
            queryResponseDef = "";
        }
        String genericErrorMessage = null;
        try {
            if (this.fullRequest) {
                genericErrorMessage = "Could not create an instance of GraphQLRequest (for a Full request)";
                this.objectResponse = (ObjectResponse)this.graphQLRequestClass.getConstructor(String.class).newInstance(queryResponseDef);
            } else {
                genericErrorMessage = "Could not create an instance of GraphQLRequest (for a Partial request)";
                Constructor<? extends AbstractGraphQLRequest> constructor = this.graphQLRequestClass.getConstructor(GraphQlClient.class, String.class, RequestType.class, String.class, InputParameter[].class);
                this.objectResponse = (ObjectResponse)constructor.newInstance(this.graphQlClient, queryResponseDef, this.requestType, this.fieldName, this.inputParams);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
            throw new GraphQLRequestPreparationException(genericErrorMessage + ": " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() == null) {
                throw new GraphQLRequestPreparationException(genericErrorMessage, e);
            }
            if (e.getTargetException() instanceof GraphQLRequestPreparationException) {
                throw (GraphQLRequestPreparationException)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new GraphQLRequestPreparationException(genericErrorMessage, e);
        }
        return this;
    }

    public ObjectResponse build() throws GraphQLRequestPreparationException {
        if (this.objectResponse == null) {
            if (this.fullRequest) {
                throw new GraphQLRequestPreparationException("Empty request are not allowed for Full Request. Please call the Builder.withQueryResponseDef(String) method to defined the GraphQL request");
            }
            this.withQueryResponseDef("");
        }
        return this.objectResponse;
    }
}

