/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import graphql.GraphQLContext;
import graphql.schema.GraphQLScalarType;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public abstract class AbstractCustomJacksonSerializer<T>
extends StdSerializer<T> {
    private static final long serialVersionUID = 1L;
    final int listLevel;
    final GraphQLScalarType graphQLScalarType;

    public AbstractCustomJacksonSerializer(Class<?> clazz, int listLevel, GraphQLScalarType graphQLScalarType) {
        super(clazz, false);
        this.listLevel = listLevel;
        this.graphQLScalarType = graphQLScalarType;
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.execSerialization(value, this.listLevel, gen);
    }

    private void execSerialization(Object value, int listLevelParam, JsonGenerator gen) throws IOException {
        if (listLevelParam == 0) {
            if (this.graphQLScalarType != null) {
                gen.writeObject(this.graphQLScalarType.getCoercing().serialize(value, GraphQLContext.getDefault(), Locale.getDefault()));
            } else {
                gen.writeObject(value);
            }
        } else {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Expecting a list with depth (number of level of list inclusion) of " + this.listLevel + ", but the provided value's depth is " + (this.listLevel - listLevelParam) + " (a level of 0 means: it's not a list)");
            }
            gen.writeStartArray();
            for (Object v : (List)value) {
                this.execSerialization(v, listLevelParam - 1, gen);
            }
            gen.writeEndArray();
        }
    }
}

