/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.annotation.GraphQLDeprecatedResponseForRequestObject;
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TreeNode;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.deser.DeserializationProblemHandler;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BigIntegerNode;
import tools.jackson.databind.node.BooleanNode;
import tools.jackson.databind.node.DecimalNode;
import tools.jackson.databind.node.DoubleNode;
import tools.jackson.databind.node.FloatNode;
import tools.jackson.databind.node.IntNode;
import tools.jackson.databind.node.LongNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.ShortNode;
import tools.jackson.databind.node.StringNode;

public class GraphQLDeserializationProblemHandler
extends DeserializationProblemHandler {
    private Logger logger = LoggerFactory.getLogger(GraphQLDeserializationProblemHandler.class);
    private JsonMapper objectMapper;
    final Map<Class<?>, Map<String, Field>> aliasFields;
    final String graphQLObjectsPackage;
    private String schema;

    public GraphQLDeserializationProblemHandler(String graphQLObjectsPackage, Map<Class<?>, Map<String, Field>> aliasFields, String schema) {
        this.graphQLObjectsPackage = graphQLObjectsPackage;
        this.aliasFields = aliasFields;
        this.schema = schema;
    }

    public void setObjectMapper(JsonMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, ValueDeserializer<?> deserializer, Object beanOrClass, String propertyName) {
        Map<String, Field> aliases = null;
        Field targetField = null;
        JsonDeserialize jsonDeserialize = null;
        Object value = null;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Reading alias '" + propertyName + "' for " + beanOrClass.getClass().getName());
        }
        if (this.aliasFields != null) {
            Class<?> clazz = beanOrClass.getClass();
            GraphQLDeprecatedResponseForRequestObject annotation = clazz.getAnnotation(GraphQLDeprecatedResponseForRequestObject.class);
            if (annotation != null) {
                try {
                    clazz = clazz.getClassLoader().loadClass(annotation.value());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            aliases = this.aliasFields.get(clazz);
        }
        if (aliases != null) {
            targetField = (Field)aliases.get(propertyName);
        }
        if (targetField != null) {
            jsonDeserialize = targetField.getAnnotation(JsonDeserialize.class);
        }
        try {
            if (jsonDeserialize != null) {
                ValueDeserializer graphQLDeserializer = (ValueDeserializer)jsonDeserialize.using().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                value = graphQLDeserializer.deserialize(p, ctxt);
            } else {
                value = this.getAliasValue(p, targetField, p.readValueAsTree());
            }
        }
        catch (GraphQLRequestExecutionException | IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | JacksonException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String methodName = "setAliasValue";
        try {
            Method setAliasValue = beanOrClass.getClass().getMethod(methodName, String.class, Object.class);
            setAliasValue.invoke(beanOrClass, propertyName, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not find or invoke the method '" + methodName + "' in the " + beanOrClass.getClass().getName() + " class", e);
        }
        return true;
    }

    public Object getAliasValue(JsonParser parser, Field targetField, TreeNode value) throws IOException, GraphQLRequestExecutionException {
        if (value instanceof ArrayNode) {
            ArrayList<Object> list = new ArrayList<Object>(((ArrayNode)value).size());
            for (TreeNode o : (ArrayNode)value) {
                list.add(this.getAliasValue(parser, targetField, o));
            }
            return list;
        }
        if (value instanceof ObjectNode) {
            String typename = ((StringNode)value.get("__typename")).asString();
            Class<?> clazz = GraphqlClientUtils.graphqlClientUtils.getClass(this.graphQLObjectsPackage, typename, this.schema);
            return this.objectMapper.treeToValue(value, clazz);
        }
        if (value instanceof NullNode) {
            return null;
        }
        if (targetField != null && targetField.getType().isEnum()) {
            if (!(value instanceof StringNode)) {
                return new GraphQLRequestExecutionException("The '" + targetField + "' is an enum, so the encoded json should be a StringNode. But it's a '" + value.getClass().getName() + "'");
            }
            return Enum.valueOf(targetField.getType(), ((StringNode)value).stringValue());
        }
        if (value instanceof BooleanNode) {
            return ((BooleanNode)value).booleanValue();
        }
        if (value instanceof DecimalNode) {
            return ((DecimalNode)value).decimalValue();
        }
        if (value instanceof DoubleNode) {
            return ((DoubleNode)value).doubleValue();
        }
        if (value instanceof FloatNode) {
            return ((FloatNode)value).asDouble();
        }
        if (value instanceof BigIntegerNode) {
            return ((BigIntegerNode)value).bigIntegerValue();
        }
        if (value instanceof IntNode) {
            return ((IntNode)value).intValue();
        }
        if (value instanceof LongNode) {
            return ((LongNode)value).longValue();
        }
        if (value instanceof ShortNode) {
            return ((ShortNode)value).shortValue();
        }
        if (value instanceof StringNode) {
            return ((StringNode)value).stringValue();
        }
        throw new GraphQLRequestExecutionException("Non managed json type. This can happen in two cases: the value for this alias is a GraphQL custom scalar (in which case you should use the getAliasCustomScalarValue method) or a bug");
    }
}

