/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.client.GraphQLDeserializationProblemHandler;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import tools.jackson.core.JacksonException;
import tools.jackson.core.TreeNode;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.deser.DeserializationProblemHandler;
import tools.jackson.databind.json.JsonMapper;

public class GraphQLJsonMapper {
    @Autowired
    ApplicationContext ctx;
    private final JsonMapper objectMapper;

    public GraphQLJsonMapper(String graphQLObjectsPackage, Map<Class<?>, Map<String, Field>> aliasFields, String schema) {
        if (schema == null) {
            throw new NullPointerException("The schema parameter may bot be null");
        }
        GraphQLDeserializationProblemHandler pbHandler = new GraphQLDeserializationProblemHandler(graphQLObjectsPackage, aliasFields, schema);
        this.objectMapper = ((JsonMapper.Builder)JsonMapper.builder().addHandler((DeserializationProblemHandler)pbHandler)).build();
        pbHandler.setObjectMapper(this.objectMapper);
    }

    public Map<String, JsonNode> convertValue(JsonNode extensions, TypeReference<Map<String, JsonNode>> typeReference) {
        return (Map)this.objectMapper.convertValue((Object)extensions, typeReference);
    }

    public <T> T convertValue(Object o, Class<T> clazz) {
        return (T)this.objectMapper.convertValue(o, clazz);
    }

    public <T> T readValue(String msg, Class<T> subscriptionType) throws DatabindException, JacksonException {
        return (T)this.objectMapper.readValue(msg, subscriptionType);
    }

    public JsonNode readTree(String content) throws DatabindException, JacksonException {
        return this.objectMapper.readTree(content);
    }

    public <T> T treeToValue(TreeNode value, Class<T> clazz) throws JacksonException {
        return (T)this.objectMapper.treeToValue(value, clazz);
    }

    public <T> T treeToValue(Map<?, ?> map, Class<T> clazz) throws JacksonException {
        JsonNode node = this.objectMapper.valueToTree(map);
        return (T)this.objectMapper.treeToValue((TreeNode)node, clazz);
    }

    public <T> T treeToValue(List<?> list, Class<T> clazz) throws JacksonException {
        JsonNode node = this.objectMapper.valueToTree(list);
        return (T)this.objectMapper.treeToValue((TreeNode)node, clazz);
    }

    public String writeValueAsString(Object o) throws JacksonException {
        return this.objectMapper.writeValueAsString(o);
    }

    public JsonNode valueToTree(Object o) {
        return this.objectMapper.valueToTree(o);
    }
}

