/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.kickstart.tools.DataClassResolverInfo;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.ResolverInfo;
import graphql.kickstart.tools.RootResolverInfo;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.kickstart.tools.Vehicle;
import graphql.kickstart.tools.VehicleInformation;
import graphql.kickstart.tools.resolver.FieldResolver;
import graphql.kickstart.tools.resolver.FieldResolverError;
import graphql.kickstart.tools.resolver.FieldResolverScanner;
import graphql.kickstart.tools.resolver.MethodFieldResolver;
import graphql.kickstart.tools.resolver.PropertyFieldResolver;
import graphql.language.FieldDefinition;
import graphql.language.TypeName;
import graphql.relay.Connection;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultPageInfo;
import graphql.relay.PageInfo;
import java.lang.reflect.Type;
import java.util.Locale;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001:\r\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\b\u0010\n\u001a\u00020\bH\u0007J\b\u0010\u000b\u001a\u00020\bH\u0007J\b\u0010\f\u001a\u00020\bH\u0007J\b\u0010\r\u001a\u00020\bH\u0007J\b\u0010\u000e\u001a\u00020\bH\u0007J\b\u0010\u000f\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest;", "", "()V", "options", "Lgraphql/kickstart/tools/SchemaParserOptions;", "scanner", "Lgraphql/kickstart/tools/resolver/FieldResolverScanner;", "scanner finds field resolver method using camelCase for snake_cased field_name", "", "scanner finds field resolver method using capitalize field_name in different locale", "scanner finds fields on multiple root types", "scanner finds generic return type", "scanner finds properties when no method is found", "scanner prefers concrete resolver", "scanner throws exception when more than one resolver method is found", "scanner throws exception when no resolver methods are found", "Boat", "BoatInformation", "CamelCaseQuery1", "CapitalizeQuery", "DuplicateQuery", "GenericQuery", "HullType", "Kayak", "ParentPropertyQuery", "PropertyQuery", "RootQuery1", "RootQuery2", "User", "graphql-java-tools"})
public final class FieldResolverScannerTest {
    @NotNull
    private final SchemaParserOptions options = SchemaParserOptions.Companion.defaultOptions();
    @NotNull
    private final FieldResolverScanner scanner = new FieldResolverScanner(this.options);

    @Test
    public final void scanner finds fields on multiple root types() {
        Object[] objectArray = new GraphQLQueryResolver[]{new RootQuery1(), new RootQuery2()};
        RootResolverInfo resolver2 = new RootResolverInfo(CollectionsKt.listOf((Object[])objectArray), this.options);
        FieldResolver result1 = this.scanner.findFieldResolver(new FieldDefinition("field1", (graphql.language.Type)new TypeName("String")), (ResolverInfo)resolver2);
        FieldResolver result2 = this.scanner.findFieldResolver(new FieldDefinition("field2", (graphql.language.Type)new TypeName("String")), (ResolverInfo)resolver2);
        TestUtilsKt.assertNotEquals(result1.getSearch().getSource(), result2.getSearch().getSource());
    }

    @Test(expected=FieldResolverError.class)
    public final void scanner throws exception when more than one resolver method is found() {
        Object[] objectArray = new GraphQLQueryResolver[]{new RootQuery1(), new DuplicateQuery()};
        RootResolverInfo resolver2 = new RootResolverInfo(CollectionsKt.listOf((Object[])objectArray), this.options);
        this.scanner.findFieldResolver(new FieldDefinition("field1", (graphql.language.Type)new TypeName("String")), (ResolverInfo)resolver2);
    }

    @Test(expected=FieldResolverError.class)
    public final void scanner throws exception when no resolver methods are found() {
        RootResolverInfo resolver2 = new RootResolverInfo(CollectionsKt.emptyList(), this.options);
        this.scanner.findFieldResolver(new FieldDefinition("field1", (graphql.language.Type)new TypeName("String")), (ResolverInfo)resolver2);
    }

    @Test
    public final void scanner finds properties when no method is found() {
        RootResolverInfo resolver2 = new RootResolverInfo(CollectionsKt.listOf((Object)new PropertyQuery()), this.options);
        FieldResolver name = this.scanner.findFieldResolver(new FieldDefinition("name", (graphql.language.Type)new TypeName("String")), (ResolverInfo)resolver2);
        FieldResolver version = this.scanner.findFieldResolver(new FieldDefinition("version", (graphql.language.Type)new TypeName("Integer")), (ResolverInfo)resolver2);
        boolean bl = name instanceof PropertyFieldResolver;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = version instanceof PropertyFieldResolver;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void scanner finds generic return type() {
        RootResolverInfo resolver2 = new RootResolverInfo(CollectionsKt.listOf((Object)new GenericQuery()), this.options);
        FieldResolver users = this.scanner.findFieldResolver(new FieldDefinition("users", (graphql.language.Type)new TypeName("UserConnection")), (ResolverInfo)resolver2);
        boolean bl = users instanceof MethodFieldResolver;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void scanner prefers concrete resolver() {
        DataClassResolverInfo resolver2 = new DataClassResolverInfo((Type)((Object)Kayak.class));
        FieldResolver meta = this.scanner.findFieldResolver(new FieldDefinition("information", (graphql.language.Type)new TypeName("VehicleInformation")), (ResolverInfo)resolver2);
        boolean bl = meta instanceof MethodFieldResolver;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)meta, (String)"null cannot be cast to non-null type graphql.kickstart.tools.resolver.MethodFieldResolver");
        TestUtilsKt.assertEquals(((MethodFieldResolver)meta).getMethod().getReturnType(), BoatInformation.class);
    }

    @Test
    public final void scanner finds field resolver method using camelCase for snake_cased field_name() {
        RootResolverInfo resolver2 = new RootResolverInfo(CollectionsKt.listOf((Object)new CamelCaseQuery1()), this.options);
        FieldResolver meta = this.scanner.findFieldResolver(new FieldDefinition("hull_type", (graphql.language.Type)new TypeName("HullType")), (ResolverInfo)resolver2);
        boolean bl = meta instanceof MethodFieldResolver;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)meta, (String)"null cannot be cast to non-null type graphql.kickstart.tools.resolver.MethodFieldResolver");
        TestUtilsKt.assertEquals(((MethodFieldResolver)meta).getMethod().getReturnType(), HullType.class);
    }

    @Test
    public final void scanner finds field resolver method using capitalize field_name in different locale() {
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.forLanguageTag("tr-TR"));
        RootResolverInfo resolverInfo = new RootResolverInfo(CollectionsKt.listOf((Object)new CapitalizeQuery()), this.options);
        FieldResolver fieldResolver = this.scanner.findFieldResolver(new FieldDefinition("id", (graphql.language.Type)new TypeName("HullType")), (ResolverInfo)resolverInfo);
        boolean bl = fieldResolver instanceof MethodFieldResolver;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)fieldResolver, (String)"null cannot be cast to non-null type graphql.kickstart.tools.resolver.MethodFieldResolver");
        TestUtilsKt.assertEquals(((MethodFieldResolver)fieldResolver).getMethod().getReturnType(), HullType.class);
        Locale.setDefault(locale);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$RootQuery1;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "field1", "", "graphql-java-tools"})
    public static final class RootQuery1
    implements GraphQLQueryResolver {
        public final void field1() {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$RootQuery2;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "field2", "", "graphql-java-tools"})
    public static final class RootQuery2
    implements GraphQLQueryResolver {
        public final void field2() {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$DuplicateQuery;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "field1", "", "graphql-java-tools"})
    public static final class DuplicateQuery
    implements GraphQLQueryResolver {
        public final void field1() {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$CamelCaseQuery1;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "getHullType", "Lgraphql/kickstart/tools/FieldResolverScannerTest$HullType;", "graphql-java-tools"})
    public static final class CamelCaseQuery1
    implements GraphQLQueryResolver {
        @NotNull
        public final HullType getHullType() {
            return new HullType();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$CapitalizeQuery;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "getId", "Lgraphql/kickstart/tools/FieldResolverScannerTest$HullType;", "graphql-java-tools"})
    public static final class CapitalizeQuery
    implements GraphQLQueryResolver {
        @NotNull
        public final HullType getId() {
            return new HullType();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$HullType;", "", "()V", "graphql-java-tools"})
    public static final class HullType {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$ParentPropertyQuery;", "", "()V", "version", "", "graphql-java-tools"})
    public static class ParentPropertyQuery {
        private int version = 1;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$PropertyQuery;", "Lgraphql/kickstart/tools/FieldResolverScannerTest$ParentPropertyQuery;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "name", "", "graphql-java-tools"})
    public static final class PropertyQuery
    extends ParentPropertyQuery
    implements GraphQLQueryResolver {
        @NotNull
        private String name = "name";
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$User;", "", "()V", "graphql-java-tools"})
    public static final class User {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$GenericQuery;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "getUsers", "Lgraphql/relay/Connection;", "Lgraphql/kickstart/tools/FieldResolverScannerTest$User;", "graphql-java-tools"})
    public static final class GenericQuery
    implements GraphQLQueryResolver {
        @NotNull
        public final Connection<User> getUsers() {
            return (Connection)new DefaultConnection(CollectionsKt.emptyList(), (PageInfo)new DefaultPageInfo(null, null, false, false));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$Boat;", "Lgraphql/kickstart/tools/Vehicle;", "()V", "getInformation", "Lgraphql/kickstart/tools/FieldResolverScannerTest$BoatInformation;", "graphql-java-tools"})
    public static abstract class Boat
    implements Vehicle {
        @Override
        @NotNull
        public BoatInformation getInformation() {
            return this.getInformation();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$BoatInformation;", "Lgraphql/kickstart/tools/VehicleInformation;", "()V", "graphql-java-tools"})
    public static final class BoatInformation
    implements VehicleInformation {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgraphql/kickstart/tools/FieldResolverScannerTest$Kayak;", "Lgraphql/kickstart/tools/FieldResolverScannerTest$Boat;", "()V", "graphql-java-tools"})
    public static final class Kayak
    extends Boat {
    }
}

