/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.ReactiveTest;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.schema.GraphQLSchema;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0005\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/ReactiveTest;", "", "()V", "futureSucceeds", "", "Organization", "Query", "User", "graphql-java-tools"})
public final class ReactiveTest {
    @Test
    public final void futureSucceeds() {
        SchemaParserOptions options2 = SchemaParserOptions.Companion.newOptions().build();
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{(GraphQLResolver)new Query()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().file("Reactive.graphqls").resolvers(graphQLResolverArray).options(options2).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Intrinsics.checkNotNullExpressionValue((Object)gql, (String)"gql");
        TestUtilsKt.assertNoGraphQlErrors$default(gql, null, null, futureSucceeds.1.INSTANCE, 6, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/ReactiveTest$Query;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "organization", "Ljava/util/concurrent/Future;", "Ljava/util/Optional;", "Lgraphql/kickstart/tools/ReactiveTest$Organization;", "organizationid", "", "graphql-java-tools"})
    private static final class Query
    implements GraphQLQueryResolver {
        @NotNull
        public final Future<Optional<Organization>> organization(int organizationid) {
            CompletableFuture<Optional<Organization>> completableFuture = CompletableFuture.completedFuture(Optional.of(new Organization()));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Optional.of(Organization()))");
            return completableFuture;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/ReactiveTest$Organization;", "", "()V", "user", "Lgraphql/kickstart/tools/ReactiveTest$User;", "graphql-java-tools"})
    private static final class Organization {
        @Nullable
        private final User user;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/ReactiveTest$User;", "", "()V", "id", "", "Ljava/lang/Long;", "name", "", "graphql-java-tools"})
    private static final class User {
        @Nullable
        private final Long id;
        @Nullable
        private final String name;
    }
}

