/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodev.graphql.tools;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import com.coxautodev.graphql.tools.GraphQLResolver;
import com.coxautodev.graphql.tools.SchemaParser;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/coxautodev/graphql/tools/MethodFieldResolverTest;", "", "()V", "customScalarType", "Lgraphql/schema/GraphQLScalarType;", "should handle lists of scalar types", "", "should handle scalar types as method input argument", "CustomScalar", "graphql-java-tools"})
public final class MethodFieldResolverTest {
    private final GraphQLScalarType customScalarType;

    @Test
    public final void should handle scalar types as method input argument() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString(StringsKt.trimIndent((String)"\n                    scalar CustomScalar\n                    type Query {\n                        test(input: CustomScalar): Int\n                    }\n                    ")).scalars(new GraphQLScalarType[]{this.customScalarType}).resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            public final int test(@NotNull CustomScalar scalar) {
                Intrinsics.checkParameterIsNotNull((Object)scalar, (String)"scalar");
                return scalar.getValue().length();
            }
        }}).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query(StringsKt.trimIndent((String)"\n                            query Test($input: CustomScalar) {\n                                test(input: $input)\n                            }\n                            ")).variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)"FooBar"))).context(new Object()).root(new Object()));
        Assert.assertEquals((Object)6, ((Map)result.getData()).get("test"));
    }

    @Test
    public final void should handle lists of scalar types() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString(StringsKt.trimIndent((String)"\n                    scalar CustomScalar\n                    type Query {\n                        test(input: [CustomScalar]): Int\n                    }\n                    ")).scalars(new GraphQLScalarType[]{this.customScalarType}).resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            /*
             * WARNING - void declaration
             */
            public final int test(@NotNull List<CustomScalar> scalars) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull(scalars, (String)"scalars");
                Iterable $this$map$iv = scalars;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CustomScalar customScalar = (CustomScalar)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Integer n = it.getValue().length();
                    collection.add(n);
                }
                return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            }
        }}).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query(StringsKt.trimIndent((String)"\n                            query Test($input: [CustomScalar]) {\n                                test(input: $input)\n                            }\n                            ")).variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)CollectionsKt.listOf((Object[])new String[]{"Foo", "Bar"})))).context(new Object()).root(new Object()));
        Assert.assertEquals((Object)6, ((Map)result.getData()).get("test"));
    }

    public MethodFieldResolverTest() {
        GraphQLScalarType graphQLScalarType = GraphQLScalarType.newScalar().name("CustomScalar").description("customScalar").coercing((Coercing)new Coercing<CustomScalar, String>(){

            @Nullable
            public CustomScalar parseValue(@Nullable Object input) {
                return CustomScalar.Companion.of(input);
            }

            @Nullable
            public CustomScalar parseLiteral(@Nullable Object input) {
                Object object = input;
                return object instanceof StringValue ? CustomScalar.Companion.of(((StringValue)input).getValue()) : null;
            }

            @Nullable
            public String serialize(@Nullable Object dataFetcherResult) {
                Object object = dataFetcherResult;
                return object instanceof CustomScalar ? ((CustomScalar)dataFetcherResult).getValue() : null;
            }
        }).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphQLScalarType, (String)"GraphQLScalarType.newSca\u2026  })\n            .build()");
        this.customScalarType = graphQLScalarType;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/coxautodev/graphql/tools/MethodFieldResolverTest$CustomScalar;", "", "internalValue", "", "(Ljava/lang/String;)V", "value", "getValue", "()Ljava/lang/String;", "Companion", "graphql-java-tools"})
    public static final class CustomScalar {
        private final String internalValue;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getValue() {
            return this.internalValue;
        }

        private CustomScalar(String internalValue) {
            this.internalValue = internalValue;
        }

        public /* synthetic */ CustomScalar(String internalValue, DefaultConstructorMarker $constructor_marker) {
            this(internalValue);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0006"}, d2={"Lcom/coxautodev/graphql/tools/MethodFieldResolverTest$CustomScalar$Companion;", "", "()V", "of", "Lcom/coxautodev/graphql/tools/MethodFieldResolverTest$CustomScalar;", "input", "graphql-java-tools"})
        public static final class Companion {
            @Nullable
            public final CustomScalar of(@Nullable Object input) {
                Object object = input;
                return object instanceof String ? new CustomScalar((String)input, null) : null;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

