/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools.util;

import graphql.kickstart.tools.util.BiMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BiMapTest {
    private BiMap<String, Integer> bimap;

    @Before
    public void setUp() {
        this.bimap = BiMap.create();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoesNotPermitDuplicateValues() {
        this.bimap.put((Object)"foo", (Object)1);
        this.bimap.put((Object)"bar", (Object)1);
    }

    @Test
    public void testPutSameKeySameValue() {
        this.bimap.put((Object)"foo", (Object)1);
        this.bimap.put((Object)"foo", (Object)1);
    }

    @Test
    public void testPutSameKeyNewValue() {
        this.bimap.put((Object)"foo", (Object)1);
        this.bimap.put((Object)"bar", (Object)2);
        int old = (Integer)this.bimap.put((Object)"bar", (Object)3);
        Assert.assertEquals((long)2L, (long)old);
        HashSet<Integer> expected = new HashSet<Integer>(Arrays.asList(1, 3));
        Assert.assertEquals(expected, (Object)this.bimap.values());
        Assert.assertEquals(expected, (Object)this.bimap.inverse().keySet());
    }

    @Test
    public void testInverse() {
        this.bimap.put((Object)"foo", (Object)1);
        this.bimap.put((Object)"bar", (Object)2);
        this.bimap.put((Object)"baz", (Object)3);
        BiMap inverse = this.bimap.inverse();
        Assert.assertTrue((boolean)inverse.containsKey((Object)1));
        Assert.assertTrue((boolean)inverse.containsKey((Object)2));
        Assert.assertTrue((boolean)inverse.containsKey((Object)3));
        Assert.assertThat((Object)inverse.get((Object)1), (Matcher)CoreMatchers.is((Object)"foo"));
        Assert.assertThat((Object)inverse.get((Object)2), (Matcher)CoreMatchers.is((Object)"bar"));
        Assert.assertThat((Object)inverse.get((Object)3), (Matcher)CoreMatchers.is((Object)"baz"));
    }

    @Test
    public void testValues() {
        this.bimap.put((Object)"foo", (Object)1);
        this.bimap.put((Object)"bar", (Object)2);
        this.bimap.put((Object)"baz", (Object)3);
        Set values = this.bimap.values();
        HashSet<Integer> expected = new HashSet<Integer>(Arrays.asList(1, 2, 3));
        Assert.assertThat((Object)values, (Matcher)CoreMatchers.is(expected));
    }
}

