/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodev.graphql.tools;

import com.coxautodev.graphql.tools.Resolver;
import com.coxautodev.graphql.tools.SchemaClassScannerError;
import com.google.common.primitives.Primitives;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ScalarTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.ScalarInfo;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0018B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\b\b\u0002\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00060\u0005j\u0002`\u00062\n\u0010\u0017\u001a\u00060\u0005j\u0002`\u0006H\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/coxautodev/graphql/tools/TypeClassMatcher;", "", "graphQLType", "Lgraphql/language/Type;", "javaType", "Ljava/lang/reflect/Type;", "Lcom/coxautodev/graphql/tools/JavaType;", "method", "Lcom/coxautodev/graphql/tools/Resolver$Method;", "returnValue", "", "definitionsByName", "", "", "Lgraphql/language/TypeDefinition;", "(Lgraphql/language/Type;Ljava/lang/reflect/Type;Lcom/coxautodev/graphql/tools/Resolver$Method;ZLjava/util/Map;)V", "error", "Lcom/coxautodev/graphql/tools/SchemaClassScannerError;", "msg", "match", "Lcom/coxautodev/graphql/tools/TypeClassMatcher$Match;", "root", "unwrapGenericWrapper", "type", "Match", "graphql-java-tools"})
public final class TypeClassMatcher {
    private final graphql.language.Type graphQLType;
    private final Type javaType;
    private final Resolver.Method method;
    private final boolean returnValue;
    private final Map<String, TypeDefinition> definitionsByName;

    private final SchemaClassScannerError error(String msg) {
        return new SchemaClassScannerError("Unable to match type definition (" + this.graphQLType + ") with java type (" + this.javaType + "): " + msg, null, 2, null);
    }

    @NotNull
    public final Match match() {
        return this.match(this.graphQLType, this.javaType, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Match match(graphql.language.Type graphQLType, Type javaType, boolean root) {
        Match match;
        graphql.language.Type type;
        Type realType = this.unwrapGenericWrapper(javaType);
        boolean optional = false;
        if (realType instanceof ParameterizedType && this.method.isTypeAssignableFromRawClass((ParameterizedType)realType, Optional.class)) {
            optional = true;
            if (this.returnValue && !root) {
                throw (Throwable)this.error(Optional.class.getName() + " can only be used at the top level of a return type");
            }
            Object object = ArraysKt.first((Object[])((ParameterizedType)realType).getActualTypeArguments());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"realType.actualTypeArguments.first()");
            realType = this.unwrapGenericWrapper((Type)object);
            if (realType instanceof ParameterizedType && this.method.isTypeAssignableFromRawClass((ParameterizedType)realType, Optional.class)) {
                throw (Throwable)this.error(Optional.class.getName() + " cannot be nested within itself");
            }
        }
        if ((type = graphQLType) instanceof NonNullType) {
            if (optional) {
                throw (Throwable)this.error("graphql type is marked as nonnull but " + Optional.class.getName() + " was used");
            }
            graphql.language.Type type2 = ((NonNullType)graphQLType).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"graphQLType.type");
            match = TypeClassMatcher.match$default(this, type2, realType, false, 4, null);
            return match;
        } else if (type instanceof ListType) {
            if (!(realType instanceof ParameterizedType) || !this.method.isTypeAssignableFromRawClass((ParameterizedType)realType, List.class)) throw (Throwable)this.error("Java class is not a List: " + realType);
            graphql.language.Type type3 = ((ListType)graphQLType).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"graphQLType.type");
            Object object = ArraysKt.first((Object[])((ParameterizedType)realType).getActualTypeArguments());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"realType.actualTypeArguments.first()");
            match = TypeClassMatcher.match$default(this, type3, (Type)object, false, 4, null);
            return match;
        } else if (type instanceof TypeName) {
            ScalarTypeDefinition scalarTypeDefinition = (ScalarTypeDefinition)ScalarInfo.STANDARD_SCALAR_DEFINITIONS.get(((TypeName)graphQLType).getName());
            TypeDefinition typeDefinition = scalarTypeDefinition != null ? (TypeDefinition)scalarTypeDefinition : this.definitionsByName.get(((TypeName)graphQLType).getName());
            if (typeDefinition == null) {
                throw (Throwable)new SchemaClassScannerError("No " + TypeDefinition.class.getSimpleName() + " for type name " + ((TypeName)graphQLType).getName(), null, 2, null);
            }
            TypeDefinition typeDefinition2 = typeDefinition;
            match = new Match(typeDefinition2, this.method.getRawClass(realType));
            return match;
        } else {
            if (!(type instanceof TypeDefinition)) throw (Throwable)this.error("Unknown type: " + realType.getClass().getName());
            match = new Match((TypeDefinition)graphQLType, this.method.getRawClass(realType));
        }
        return match;
    }

    static /* bridge */ /* synthetic */ Match match$default(TypeClassMatcher typeClassMatcher, graphql.language.Type type, Type type2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return typeClassMatcher.match(type, type2, bl);
    }

    private final Type unwrapGenericWrapper(Type type) {
        Type type2;
        Type type3 = type;
        if (type3 instanceof ParameterizedType) {
            Type type4;
            Type type5 = ((ParameterizedType)type).getRawType();
            if (Intrinsics.areEqual((Object)type5, Future.class)) {
                Object object = ArraysKt.first((Object[])((ParameterizedType)type).getActualTypeArguments());
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"type.actualTypeArguments.first()");
                type4 = this.unwrapGenericWrapper((Type)object);
            } else if (Intrinsics.areEqual((Object)type5, CompletionStage.class)) {
                Object object = ArraysKt.first((Object[])((ParameterizedType)type).getActualTypeArguments());
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"type.actualTypeArguments.first()");
                type4 = this.unwrapGenericWrapper((Type)object);
            } else if (Intrinsics.areEqual((Object)type5, CompletableFuture.class)) {
                Object object = ArraysKt.first((Object[])((ParameterizedType)type).getActualTypeArguments());
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"type.actualTypeArguments.first()");
                type4 = this.unwrapGenericWrapper((Type)object);
            } else {
                type4 = type;
            }
            return type4;
        }
        if (type3 instanceof Class) {
            Class clazz = ((Class)type).isPrimitive() ? Primitives.wrap((Class)((Class)type)) : (Class)type;
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"if(type.isPrimitive) Pri\u2026ives.wrap(type) else type");
            type2 = clazz;
        } else if (type3 instanceof TypeVariable) {
            type2 = this.method.resolveTypeVariable((TypeVariable)type);
        } else {
            throw (Throwable)this.error("Unable to unwrap type: " + type);
        }
        return type2;
    }

    public TypeClassMatcher(@NotNull graphql.language.Type graphQLType, @NotNull Type javaType, @NotNull Resolver.Method method, boolean returnValue, @NotNull Map<String, ? extends TypeDefinition> definitionsByName) {
        Intrinsics.checkParameterIsNotNull((Object)graphQLType, (String)"graphQLType");
        Intrinsics.checkParameterIsNotNull((Object)javaType, (String)"javaType");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull(definitionsByName, (String)"definitionsByName");
        this.graphQLType = graphQLType;
        this.javaType = javaType;
        this.method = method;
        this.returnValue = returnValue;
        this.definitionsByName = definitionsByName;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/coxautodev/graphql/tools/TypeClassMatcher$Match;", "", "type", "Lgraphql/language/TypeDefinition;", "clazz", "Ljava/lang/Class;", "(Lgraphql/language/TypeDefinition;Ljava/lang/Class;)V", "getClazz", "()Ljava/lang/Class;", "getType", "()Lgraphql/language/TypeDefinition;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "graphql-java-tools"})
    public static final class Match {
        @NotNull
        private final TypeDefinition type;
        @NotNull
        private final Class<?> clazz;

        @NotNull
        public final TypeDefinition getType() {
            return this.type;
        }

        @NotNull
        public final Class<?> getClazz() {
            return this.clazz;
        }

        public Match(@NotNull TypeDefinition type, @NotNull Class<?> clazz) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            this.type = type;
            this.clazz = clazz;
        }

        @NotNull
        public final TypeDefinition component1() {
            return this.type;
        }

        @NotNull
        public final Class<?> component2() {
            return this.clazz;
        }

        @NotNull
        public final Match copy(@NotNull TypeDefinition type, @NotNull Class<?> clazz) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            return new Match(type, clazz);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Match copy$default(Match match, TypeDefinition typeDefinition, Class clazz, int n, Object object) {
            if ((n & 1) != 0) {
                typeDefinition = match.type;
            }
            if ((n & 2) != 0) {
                clazz = match.clazz;
            }
            return match.copy(typeDefinition, clazz);
        }

        public String toString() {
            return "Match(type=" + this.type + ", clazz=" + this.clazz + ")";
        }

        public int hashCode() {
            TypeDefinition typeDefinition = this.type;
            Class<?> clazz = this.clazz;
            return (typeDefinition != null ? typeDefinition.hashCode() : 0) * 31 + (clazz != null ? clazz.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Match)) break block3;
                    Match match = (Match)object;
                    if (!Intrinsics.areEqual((Object)this.type, (Object)match.type) || !Intrinsics.areEqual(this.clazz, match.clazz)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

