/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.Expression;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.ParseException;
import com.api.jsonata4java.expressions.functions.Function;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

public class EvalFunction
extends FunctionBase
implements Function {
    private static final long serialVersionUID = -7591450668292230141L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$string");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$string");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s must be a json string or a jsonata expression", "$string");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        JsonNode result = null;
        JsonNode context = null;
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = EvalFunction.getArgumentCount(ctx);
        if (useContext) {
            context = FunctionUtils.getContextVariable(expressionVisitor);
            if (context != null && argCount == 0) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        String expression = "{}";
        if (argCount >= 1 && argCount <= 2) {
            JsonNode arg;
            if (!useContext && (arg = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0)) != null && arg.isTextual()) {
                expression = arg.asText();
            }
            if (argCount == 2) {
                context = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
            }
            try {
                Expression expr = Expression.jsonata(expression);
                result = expr.evaluate(context);
            }
            catch (ParseException | IOException e) {
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
        } else {
            if (argCount == 0) {
                return null;
            }
            throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<x-b?:s>";
    }
}

