/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.antlr.v4.runtime.tree.TerminalNode;

public class EachFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$each");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$each");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$each");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$each");
    public static String ERR_ARG1_MUST_BE_ARRAY_OF_OBJECTS = String.format("Argument 1 of function \"%s\" must be an object or an array of objects.", "$each");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        ExpressionsVisitor.SelectorArrayNode resultArray = new ExpressionsVisitor.SelectorArrayNode(JsonNodeFactory.instance);
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        JsonNode objNode = null;
        MappingExpressionParser.ExprValuesContext valuesCtx = ctx.exprValues();
        MappingExpressionParser.ExprListContext exprList = valuesCtx.exprList();
        int argCount = EachFunction.getArgumentCount(ctx);
        if (useContext) {
            objNode = FunctionUtils.getContextVariable(expressionVisitor);
            if (objNode != null && !objNode.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 2) throw new EvaluateRuntimeException(argCount <= 1 ? ERR_BAD_CONTEXT : ERR_ARG3BADTYPE);
        if (!useContext) {
            objNode = expressionVisitor.visit(exprList.expr(0));
        }
        if (objNode == null || !objNode.isObject()) {
            throw new EvaluateRuntimeException(String.format("Argument 1 of function %s does not match function signature", "$each"));
        }
        ObjectNode object = (ObjectNode)objNode;
        MappingExpressionParser.ExprContext varid = exprList.expr(useContext ? 0 : 1);
        if (varid instanceof MappingExpressionParser.Var_recallContext) {
            TerminalNode VAR_ID = ((MappingExpressionParser.Var_recallContext)varid).VAR_ID();
            String varID = varid.getText();
            DeclaredFunction fct = expressionVisitor.getDeclaredFunction(varID);
            if (fct != null) {
                int fctVarCount;
                int varCount = fct.getVariableCount();
                if (varCount > (fctVarCount = fct.getMaxArgs())) {
                    varCount = fctVarCount;
                }
                Iterator<String> it = object.fieldNames();
                while (it.hasNext()) {
                    JsonNode fctResult;
                    String key = it.next();
                    JsonNode field = object.get(key);
                    MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                    switch (varCount) {
                        case 1: {
                            evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                            break;
                        }
                        case 2: {
                            evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                            evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                            break;
                        }
                        case 3: {
                            evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                            evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                            evc = FunctionUtils.addObjectExprVarContext(ctx, evc, object);
                        }
                    }
                    if ((fctResult = fct.invoke(expressionVisitor, evc)) == null) continue;
                    resultArray.add(fctResult);
                }
                return resultArray;
            } else {
                FunctionBase function = expressionVisitor.getJsonataFunction(varid.getText());
                if (function == null) throw new EvaluateRuntimeException("Expected function variable reference " + varID + " to resolve to a declared nor Jsonata function.");
                Iterator<String> it = object.fieldNames();
                while (it.hasNext()) {
                    String key = it.next();
                    JsonNode field = object.get(key);
                    MappingExpressionParser.Function_callContext callCtx = new MappingExpressionParser.Function_callContext(ctx);
                    resultArray.add(FunctionUtils.processVariablesCallFunction(expressionVisitor, function, VAR_ID, callCtx, field));
                }
            }
            return resultArray;
        } else {
            int fctVarCount;
            MappingExpressionParser.ExprListContext fctBody;
            if (!(varid instanceof MappingExpressionParser.Function_declContext)) return resultArray;
            MappingExpressionParser.Function_declContext fctDeclCtx = (MappingExpressionParser.Function_declContext)exprList.expr(useContext ? 0 : 1);
            MappingExpressionParser.VarListContext varList = fctDeclCtx.varList();
            DeclaredFunction fct = new DeclaredFunction(varList, fctBody = fctDeclCtx.exprList());
            int varCount = fct.getVariableCount();
            if (varCount > (fctVarCount = fct.getMaxArgs())) {
                varCount = fctVarCount;
            }
            Iterator<String> it = object.fieldNames();
            while (it.hasNext()) {
                JsonNode fctResult;
                String key = it.next();
                JsonNode field = object.get(key);
                MappingExpressionParser.ExprValuesContext evc = new MappingExpressionParser.ExprValuesContext(ctx, ctx.invokingState);
                switch (varCount) {
                    case 1: {
                        evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                        break;
                    }
                    case 2: {
                        evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                        evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                        break;
                    }
                    case 3: {
                        evc = FunctionUtils.fillExprVarContext(varCount, ctx, field);
                        evc = FunctionUtils.addStringExprVarContext(ctx, evc, key);
                        evc = FunctionUtils.addObjectExprVarContext(ctx, evc, object);
                    }
                }
                if ((fctResult = fct.invoke(expressionVisitor, evc)) == null) continue;
                resultArray.add(fctResult);
            }
        }
        return resultArray;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<o-f:a<o>";
    }

    public void addObject(ExpressionsVisitor.SelectorArrayNode result, ObjectNode obj) {
        Iterator<String> it = obj.fieldNames();
        while (it.hasNext()) {
            String key = it.next();
            ObjectNode cell = JsonNodeFactory.instance.objectNode();
            cell.set(key, obj.get(key));
            result.add(cell);
        }
    }
}

