/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.JSONataUtils;
import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;

public class UnpackFunction
extends FunctionBase {
    private static final long serialVersionUID = 1415132777843221239L;
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$unpack");
    public static String ERR_ARG1BADTYPE = "Argument 1 of function $unpack does not match function signature";
    public static String ERR_ARG2BADTYPE = "Argument 2 of function $unpack does not match function signature";
    public static String ERR_ARG1INVALIDHEX = "Argument 1 of function $unpack is not valid hexadecimal";
    public static String ERR_ARG2INVALIDPATTERN = "Argument 2 of function $unpack is not valid decode pattern";
    public static String ERR_ARG3BADTYPE = "Argument 3 of function $unpack does not match function signature";
    private static final Map<String, SupportedDatatype> REGISTRY = new HashMap<String, SupportedDatatype>();

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        byte[] decoded;
        JsonNode argDecodePattern;
        JsonNode result = null;
        JsonNode argInput = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = UnpackFunction.getArgumentCount(ctx);
        if (useContext) {
            argInput = FunctionUtils.getContextVariable(expressionVisitor);
            if (argInput != null && !argInput.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount == 2) {
            if (!useContext) {
                argInput = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
            }
            argDecodePattern = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
            if (argInput == null) {
                return null;
            }
            if (argDecodePattern == null) {
                return null;
            }
            if (!argInput.isTextual()) {
                throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
            }
            if (!argDecodePattern.isTextual()) {
                throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
            }
            decoded = null;
            try {
                decoded = JSONataUtils.hexDecode(argInput.asText());
            }
            catch (Exception e) {
                throw new EvaluateRuntimeException(ERR_ARG1INVALIDHEX);
            }
        } else {
            throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG3BADTYPE);
        }
        String argDecodePatternStr = argDecodePattern.textValue();
        DecodePattern decodePattern = DecodePattern.fromString(argDecodePatternStr);
        result = decodePattern.decode(decoded);
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<o-:a<s>>";
    }

    public static class DecodePattern {
        private final boolean isBigEndian;
        private final SupportedDatatype datatype;

        public DecodePattern(boolean isBigEndian, SupportedDatatype datatype) {
            this.isBigEndian = isBigEndian;
            this.datatype = datatype;
        }

        public JsonNode decode(byte[] input) {
            ByteBuffer bb = ByteBuffer.wrap(input);
            bb.order(this.isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            return this.datatype.decode(bb);
        }

        public static DecodePattern fromString(String str) throws EvaluateRuntimeException {
            boolean bigEndian;
            str = str.trim().toLowerCase();
            char endianness = str.charAt(0);
            String datatypeToken = str.substring(1);
            switch (endianness) {
                case 'l': {
                    bigEndian = false;
                    break;
                }
                case 'b': {
                    bigEndian = true;
                    break;
                }
                default: {
                    throw new EvaluateRuntimeException(ERR_ARG2INVALIDPATTERN);
                }
            }
            SupportedDatatype datatype = SupportedDatatype.fromToken(datatypeToken);
            if (datatype == null) {
                throw new EvaluateRuntimeException(ERR_ARG2INVALIDPATTERN);
            }
            return new DecodePattern(bigEndian, datatype);
        }
    }

    static enum SupportedDatatype {
        _double("64f"){

            @Override
            public JsonNode decode(ByteBuffer bb) {
                return JsonNodeFactory.instance.numberNode(bb.getDouble());
            }
        }
        ,
        _long("64"){

            @Override
            public JsonNode decode(ByteBuffer bb) {
                return JsonNodeFactory.instance.numberNode(bb.getLong());
            }
        }
        ,
        _float("32f"){

            @Override
            public JsonNode decode(ByteBuffer bb) {
                return JsonNodeFactory.instance.numberNode(bb.getFloat());
            }
        }
        ,
        _int("32"){

            @Override
            public JsonNode decode(ByteBuffer bb) {
                return JsonNodeFactory.instance.numberNode(bb.getInt());
            }
        }
        ,
        _short("16"){

            @Override
            public JsonNode decode(ByteBuffer bb) {
                return JsonNodeFactory.instance.numberNode(bb.getShort());
            }
        }
        ,
        _byte("8"){

            @Override
            public JsonNode decode(ByteBuffer bb) {
                return JsonNodeFactory.instance.numberNode(bb.get());
            }
        };

        private final String token;

        private SupportedDatatype(String token) {
            this.token = token;
            REGISTRY.put(token, this);
        }

        public abstract JsonNode decode(ByteBuffer var1);

        public static SupportedDatatype fromToken(String token) {
            return (SupportedDatatype)((Object)REGISTRY.get(token));
        }
    }
}

