/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;

public class FormatBaseFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$formatBase");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$formatBase");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$formatBase");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$formatBase");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        NullNode argNumber = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = FormatBaseFunction.getArgumentCount(ctx);
        if (useContext) {
            argNumber = FunctionUtils.getContextVariable(expressionVisitor);
            if (argNumber != null && !argNumber.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 1 && argCount != 2) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG3BADTYPE);
        if (!useContext) {
            argNumber = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argNumber == null) {
            return null;
        }
        if (!argNumber.isNumber()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        Double d = argNumber.asDouble();
        Long l = Math.round(d);
        if (Math.abs((double)l.longValue() - d) == 0.5 && l % 2L == 1L) {
            Long l2 = l;
            Long l3 = l = Long.valueOf(l - 1L);
        }
        int number = (int)l.longValue();
        int radix = 10;
        if (argCount != 2) return new TextNode(Integer.toString(number, radix));
        JsonNode argRadix = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        if (argRadix == null) return new TextNode(Integer.toString(number, radix));
        if (!argRadix.isNumber()) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        d = argRadix.asDouble();
        l = Math.round(d);
        if (Math.abs((double)l.longValue() - d) == 0.5 && l % 2L == 1L) {
            Long l4 = l;
            Long l5 = l = Long.valueOf(l - 1L);
        }
        if ((radix = (int)l.longValue()) < 2) throw new EvaluateRuntimeException("The radix of the $formatBase function must be between 2 and 36");
        if (radix <= 36) return new TextNode(Integer.toString(number, radix));
        throw new EvaluateRuntimeException("The radix of the $formatBase function must be between 2 and 36");
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<n-n?:s>";
    }
}

