/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.utils;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.temporal.IsoFields;
import java.time.temporal.WeekFields;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DateTimeUtils
implements Serializable {
    private static final long serialVersionUID = 365963860104380193L;
    private static String[] few;
    private static String[] ordinals;
    private static String[] decades;
    private static String[] magnitudes;
    private static Map<String, Integer> wordValues;
    private static RomanNumeral[] romanNumerals;
    private static Map<String, Integer> romanValues;
    private static Map<String, String> suffix123;
    private static int[] decimalGroups;
    private static Map<Character, String> defaultPresentationModifiers;
    private static String[] days;
    private static String[] months;
    private static PictureFormat iso8601Spec;

    public static String numberToWords(int value, boolean ordinal) {
        return DateTimeUtils.lookup(value, false, ordinal);
    }

    private static String lookup(int num, boolean prev, boolean ord) {
        String words = "";
        if (num <= 19) {
            words = (prev ? " and " : "") + (ord ? ordinals[num] : few[num]);
        } else if (num < 100) {
            int tens = num / 10;
            int remainder = num % 10;
            words = (prev ? " and " : "") + decades[tens - 2];
            if (remainder > 0) {
                words = words + "-" + DateTimeUtils.lookup(remainder, false, ord);
            } else if (ord) {
                words = words.substring(0, words.length() - 1) + "ieth";
            }
        } else if (num < 1000) {
            int hundreds = num / 100;
            int remainder = num % 100;
            words = (prev ? ", " : "") + few[hundreds] + " Hundred";
            if (remainder > 0) {
                words = words + DateTimeUtils.lookup(remainder, true, ord);
            } else if (ord) {
                words = words + "th";
            }
        } else {
            int mag = (int)Math.floor(Math.log10(num) / 3.0);
            if (mag > magnitudes.length) {
                mag = magnitudes.length;
            }
            int factor = (int)Math.pow(10.0, mag * 3);
            int mant = (int)Math.floor(num / factor);
            int remainder = num - mant * factor;
            words = (prev ? ", " : "") + DateTimeUtils.lookup(mant, false, false) + " " + magnitudes[mag - 1];
            if (remainder > 0) {
                words = words + DateTimeUtils.lookup(remainder, true, ord);
            } else if (ord) {
                words = words + "th";
            }
        }
        return words;
    }

    private static int wordsToNumber(String text) {
        String[] parts = text.split(",\\s|\\sand\\s|[\\s\\-]");
        Integer[] values = new Integer[parts.length];
        for (int i2 = 0; i2 < parts.length; ++i2) {
            values[i2] = wordValues.get(parts[i2]);
        }
        Stack<Integer> segs = new Stack<Integer>();
        segs.push(0);
        for (Integer value : values) {
            if (value < 100) {
                Integer top = (Integer)segs.pop();
                if (top >= 1000) {
                    segs.push(top);
                    top = 0;
                }
                segs.push(top + value);
                continue;
            }
            segs.push((Integer)segs.pop() * value);
        }
        return segs.stream().mapToInt(i -> i).sum();
    }

    private static Map<String, Integer> createRomanValues() {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("M", 1000);
        values.put("D", 500);
        values.put("C", 100);
        values.put("L", 50);
        values.put("X", 10);
        values.put("V", 5);
        values.put("I", 1);
        return values;
    }

    private static String decimalToRoman(int value) {
        for (int i = 0; i < romanNumerals.length; ++i) {
            RomanNumeral numeral = romanNumerals[i];
            if (value < numeral.getValue()) continue;
            return numeral.getLetters() + DateTimeUtils.decimalToRoman(value - numeral.getValue());
        }
        return "";
    }

    private static int romanToDecimal(String roman) {
        int decimal = 0;
        int max = 1;
        for (int i = roman.length() - 1; i >= 0; --i) {
            String digit = Character.toString(roman.charAt(i));
            int value = romanValues.get(digit);
            if (value < max) {
                decimal -= value;
                continue;
            }
            max = value;
            decimal += value;
        }
        return decimal;
    }

    private static String decimalToLetters(int value, String aChar) {
        Vector<String> letters = new Vector<String>();
        char aCode = aChar.charAt(0);
        while (value > 0) {
            letters.insertElementAt(Character.toString((char)((value - 1) % 26 + aCode)), 0);
            value = (value - 1) / 26;
        }
        return letters.stream().reduce("", (a, b) -> a + b);
    }

    private static String formatInteger(int value, String picture) {
        Format format = DateTimeUtils.analyseIntegerPicture(picture);
        return DateTimeUtils.formatInteger(value, format);
    }

    private static Map<String, String> createSuffixMap() {
        HashMap<String, String> suffix = new HashMap<String, String>();
        suffix.put("1", "st");
        suffix.put("2", "nd");
        suffix.put("3", "rd");
        return suffix;
    }

    private static String formatInteger(int value, Format format) {
        String formattedInteger = "";
        boolean negative = value < 0;
        value = Math.abs(value);
        switch (format.primary) {
            case LETTERS: {
                formattedInteger = DateTimeUtils.decimalToLetters(value, format.case_type == tcase.UPPER ? "A" : "a");
                break;
            }
            case ROMAN: {
                formattedInteger = DateTimeUtils.decimalToRoman(value);
                if (format.case_type != tcase.UPPER) break;
                formattedInteger = formattedInteger.toUpperCase();
                break;
            }
            case WORDS: {
                formattedInteger = DateTimeUtils.numberToWords(value, format.ordinal);
                if (format.case_type == tcase.UPPER) {
                    formattedInteger = formattedInteger.toUpperCase();
                    break;
                }
                if (format.case_type != tcase.LOWER) break;
                formattedInteger = formattedInteger.toLowerCase();
                break;
            }
            case DECIMAL: {
                int i;
                formattedInteger = "" + value;
                int padLength = format.mandatoryDigits - formattedInteger.length();
                if (padLength > 0) {
                    formattedInteger = StringUtils.leftPad(formattedInteger, format.mandatoryDigits, '0');
                }
                if (format.zeroCode != 48) {
                    char[] chars = formattedInteger.toCharArray();
                    for (i = 0; i < chars.length; ++i) {
                        chars[i] = (char)(chars[i] + format.zeroCode - 48);
                    }
                    formattedInteger = new String(chars);
                }
                if (format.regular) {
                    int n;
                    for (i = n = (formattedInteger.length() - 1) / format.groupingSeparators.elementAt((int)0).position; i > 0; --i) {
                        int pos = formattedInteger.length() - i * format.groupingSeparators.elementAt((int)0).position;
                        formattedInteger = formattedInteger.substring(0, pos) + format.groupingSeparators.elementAt((int)0).character + formattedInteger.substring(pos);
                    }
                } else {
                    Collections.reverse(format.groupingSeparators);
                    for (GroupingSeparator separator : format.groupingSeparators) {
                        int pos = formattedInteger.length() - separator.position;
                        formattedInteger = formattedInteger.substring(0, pos) + separator.character + formattedInteger.substring(pos);
                    }
                }
                if (!format.ordinal) break;
                String lastDigit = formattedInteger.substring(formattedInteger.length() - 1);
                String suffix = suffix123.get(lastDigit);
                if (suffix == null || formattedInteger.length() > 1 && formattedInteger.charAt(formattedInteger.length() - 2) == '1') {
                    suffix = "th";
                }
                formattedInteger = formattedInteger + suffix;
                break;
            }
            case SEQUENCE: {
                throw new EvaluateRuntimeException(String.format("Formatting or parsing an integer as a sequence starting with %s is not supported by this implementation", format.token));
            }
        }
        if (negative) {
            formattedInteger = "-" + formattedInteger;
        }
        return formattedInteger;
    }

    private static Format analyseIntegerPicture(String picture) {
        String primaryFormat;
        Format format = new Format();
        int semicolon = picture.lastIndexOf(";");
        if (semicolon == -1) {
            primaryFormat = picture;
        } else {
            primaryFormat = picture.substring(0, semicolon);
            String formatModifier = picture.substring(semicolon + 1);
            if (formatModifier.charAt(0) == 'o') {
                format.ordinal = true;
            }
        }
        switch (primaryFormat) {
            case "A": {
                format.case_type = tcase.UPPER;
            }
            case "a": {
                format.primary = formats.LETTERS;
                break;
            }
            case "I": {
                format.case_type = tcase.UPPER;
            }
            case "i": {
                format.primary = formats.ROMAN;
                break;
            }
            case "W": {
                format.case_type = tcase.UPPER;
                format.primary = formats.WORDS;
                break;
            }
            case "Ww": {
                format.case_type = tcase.TITLE;
                format.primary = formats.WORDS;
                break;
            }
            case "w": {
                format.primary = formats.WORDS;
                break;
            }
            default: {
                Integer zeroCode = null;
                int mandatoryDigits = 0;
                int optionalDigits = 0;
                Vector<GroupingSeparator> groupingSeparators = new Vector<GroupingSeparator>();
                int separatorPosition = 0;
                char[] formatCodepoints = primaryFormat.toCharArray();
                ArrayUtils.reverse(formatCodepoints);
                for (char codePoint : formatCodepoints) {
                    int group;
                    boolean digit = false;
                    int i = 0;
                    if (i < decimalGroups.length && codePoint >= (group = decimalGroups[i]) && codePoint <= group + 9) {
                        digit = true;
                        ++mandatoryDigits;
                        ++separatorPosition;
                        if (zeroCode == null) {
                            zeroCode = group;
                        } else if (group != zeroCode) {
                            throw new EvaluateRuntimeException("In a decimal digit pattern, all digits must be from the same decimal group");
                        }
                    }
                    if (digit) continue;
                    if (codePoint == '#') {
                        ++separatorPosition;
                        ++optionalDigits;
                        continue;
                    }
                    groupingSeparators.add(new GroupingSeparator(separatorPosition, Character.toString(codePoint)));
                }
                if (mandatoryDigits > 0) {
                    format.primary = formats.DECIMAL;
                    format.zeroCode = zeroCode;
                    format.mandatoryDigits = mandatoryDigits;
                    format.optionalDigits = optionalDigits;
                    int regular = DateTimeUtils.getRegularRepeat(groupingSeparators);
                    if (regular > 0) {
                        format.regular = true;
                        format.groupingSeparators.add(new GroupingSeparator(regular, groupingSeparators.elementAt((int)0).character));
                        break;
                    }
                    format.regular = false;
                    format.groupingSeparators = groupingSeparators;
                    break;
                }
                format.primary = formats.SEQUENCE;
                format.token = primaryFormat;
            }
        }
        return format;
    }

    private static int getRegularRepeat(Vector<GroupingSeparator> separators) {
        if (separators.size() == 0) {
            return 0;
        }
        String sepChar = separators.elementAt((int)0).character;
        for (int i = 1; i < separators.size(); ++i) {
            if (separators.elementAt((int)i).character.equals(sepChar)) continue;
            return 0;
        }
        List indexes = separators.stream().map(seperator -> seperator.position).collect(Collectors.toList());
        int factor = (Integer)indexes.stream().reduce((a, b) -> BigInteger.valueOf(a.intValue()).gcd(BigInteger.valueOf(b.intValue())).intValue()).get();
        for (int index = 1; index <= indexes.size(); ++index) {
            if (indexes.indexOf(index * factor) != -1) continue;
            return 0;
        }
        return factor;
    }

    private static Map<Character, String> createDefaultPresentationModifiers() {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('Y'), "1");
        map.put(Character.valueOf('M'), "1");
        map.put(Character.valueOf('D'), "1");
        map.put(Character.valueOf('d'), "1");
        map.put(Character.valueOf('F'), "n");
        map.put(Character.valueOf('W'), "1");
        map.put(Character.valueOf('w'), "1");
        map.put(Character.valueOf('X'), "1");
        map.put(Character.valueOf('x'), "1");
        map.put(Character.valueOf('H'), "1");
        map.put(Character.valueOf('h'), "1");
        map.put(Character.valueOf('P'), "n");
        map.put(Character.valueOf('m'), "01");
        map.put(Character.valueOf('s'), "01");
        map.put(Character.valueOf('f'), "1");
        map.put(Character.valueOf('Z'), "01:01");
        map.put(Character.valueOf('z'), "01:01");
        map.put(Character.valueOf('C'), "n");
        map.put(Character.valueOf('E'), "n");
        return map;
    }

    private static PictureFormat analyseDateTimePicture(String picture) {
        PictureFormat format = new PictureFormat("datetime");
        int start = 0;
        int pos = 0;
        while (pos < picture.length()) {
            if (picture.charAt(pos) == '[') {
                String presMod;
                if (picture.charAt(pos + 1) == '[') {
                    format.addLiteral(picture, start, pos);
                    format.parts.add(new SpecPart("literal", "["));
                    start = pos += 2;
                    continue;
                }
                format.addLiteral(picture, start, pos);
                start = pos;
                pos = picture.indexOf("]", start);
                if (pos == -1) {
                    throw new EvaluateRuntimeException("No matching closing bracket ']' in date/time picture string");
                }
                String marker = picture.substring(start + 1, pos);
                marker = String.join((CharSequence)"", marker.split("\\s+"));
                SpecPart def = new SpecPart("marker", marker.charAt(0));
                int comma = marker.lastIndexOf(",");
                if (comma != -1) {
                    String min;
                    String widthMod = marker.substring(comma + 1);
                    int dash = widthMod.indexOf("-");
                    String max = null;
                    if (dash == -1) {
                        min = widthMod;
                    } else {
                        min = widthMod.substring(0, dash);
                        max = widthMod.substring(dash + 1);
                    }
                    def.width = new ImmutablePair<Integer, Integer>(DateTimeUtils.parseWidth(min), DateTimeUtils.parseWidth(max));
                    presMod = marker.substring(1, comma);
                } else {
                    presMod = marker.substring(1);
                }
                if (presMod.length() == 1) {
                    def.presentation1 = presMod;
                } else if (presMod.length() > 1) {
                    char lastChar = presMod.charAt(presMod.length() - 1);
                    if ("atco".indexOf(lastChar) != -1) {
                        def.presentation2 = Character.valueOf(lastChar);
                        if (lastChar == 'o') {
                            def.ordinal = true;
                        }
                        def.presentation1 = presMod.substring(0, presMod.length() - 1);
                    } else {
                        def.presentation1 = presMod;
                    }
                } else {
                    def.presentation1 = defaultPresentationModifiers.get(Character.valueOf(def.component));
                }
                if (def.presentation1 == null) {
                    throw new EvaluateRuntimeException(String.format("Unknown component specifier %s in date/time picture string", Character.valueOf(def.component)));
                }
                if (def.presentation1.charAt(0) == 'n') {
                    def.names = tcase.LOWER;
                } else if (def.presentation1.charAt(0) == 'N') {
                    def.names = def.presentation1.length() > 1 && def.presentation1.charAt(1) == 'n' ? tcase.TITLE : tcase.UPPER;
                } else if ("YMDdFWwXxHhmsf".indexOf(def.component) != -1) {
                    String integerPattern = def.presentation1;
                    if (def.presentation2 == null) {
                        integerPattern = integerPattern + ";" + def.presentation2;
                    }
                    def.integerFormat = DateTimeUtils.analyseIntegerPicture(integerPattern);
                    def.integerFormat.ordinal = def.ordinal;
                    if (def.width != null && def.width.getLeft() != null && def.integerFormat.mandatoryDigits < def.width.getLeft()) {
                        def.integerFormat.mandatoryDigits = def.width.getLeft();
                    }
                    if (def.component == 'Y') {
                        def.n = -1;
                        if (def.width != null && def.width.getRight() != null) {
                            def.integerFormat.mandatoryDigits = def.n = def.width.getRight().intValue();
                        } else {
                            int w = def.integerFormat.mandatoryDigits + def.integerFormat.optionalDigits;
                            if (w >= 2) {
                                def.n = w;
                            }
                        }
                    }
                }
                if (def.component == 'Z' || def.component == 'z') {
                    def.integerFormat = DateTimeUtils.analyseIntegerPicture(def.presentation1);
                    def.integerFormat.ordinal = def.ordinal;
                }
                format.parts.add(def);
                start = pos + 1;
            }
            ++pos;
        }
        format.addLiteral(picture, start, pos);
        return format;
    }

    private static Integer parseWidth(String wm) {
        if (wm == null || wm.equals("*")) {
            return null;
        }
        return Integer.parseInt(wm);
    }

    public static String formatDateTime(long millis, String picture, String timezone) {
        PictureFormat formatSpec;
        int offsetHours = 0;
        int offsetMinutes = 0;
        if (timezone != null) {
            int offset = Integer.parseInt(timezone);
            offsetHours = offset / 100;
            offsetMinutes = offset % 100;
        }
        if (picture == null) {
            if (iso8601Spec == null) {
                iso8601Spec = DateTimeUtils.analyseDateTimePicture("[Y0001]-[M01]-[D01]T[H01]:[m01]:[s01].[f001][Z01:01t]");
            }
            formatSpec = iso8601Spec;
        } else {
            formatSpec = DateTimeUtils.analyseDateTimePicture(picture);
        }
        int offsetMillis = (60 * offsetHours + offsetMinutes) * 60 * 1000;
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis + (long)offsetMillis), ZoneOffset.UTC);
        String result = "";
        for (SpecPart part : formatSpec.parts) {
            if (part.type.equals("literal")) {
                result = result + part.value;
                continue;
            }
            result = result + DateTimeUtils.formatComponent(dateTime, part, offsetHours, offsetMinutes);
        }
        return result;
    }

    private static String formatComponent(LocalDateTime date, SpecPart markerSpec, int offsetHours, int offsetMinutes) {
        String componentValue = DateTimeUtils.getDateTimeFragment(date, Character.valueOf(markerSpec.component));
        if ("YMDdFWwXxHhms".indexOf(markerSpec.component) != -1) {
            if (markerSpec.component == 'Y' && markerSpec.n != -1) {
                componentValue = "" + (int)((double)Integer.parseInt(componentValue) % Math.pow(10.0, markerSpec.n));
            }
            if (markerSpec.names != null) {
                if (markerSpec.component == 'M' || markerSpec.component == 'x') {
                    componentValue = months[Integer.parseInt(componentValue) - 1];
                } else if (markerSpec.component == 'F') {
                    componentValue = days[Integer.parseInt(componentValue)];
                } else {
                    throw new EvaluateRuntimeException(String.format("The 'name' modifier can only be applied to months and days in the date/time picture string, not %s", Character.valueOf(markerSpec.component)));
                }
                if (markerSpec.names == tcase.UPPER) {
                    componentValue = componentValue.toUpperCase();
                } else if (markerSpec.names == tcase.LOWER) {
                    componentValue = componentValue.toLowerCase();
                }
                if (markerSpec.width != null && componentValue.length() > markerSpec.width.getRight()) {
                    componentValue = componentValue.substring(0, markerSpec.width.getRight());
                }
            } else {
                componentValue = DateTimeUtils.formatInteger(Integer.parseInt(componentValue), markerSpec.integerFormat);
            }
        } else if (markerSpec.component == 'f') {
            componentValue = DateTimeUtils.formatInteger(Integer.parseInt(componentValue), markerSpec.integerFormat);
        } else if (markerSpec.component == 'Z' || markerSpec.component == 'z') {
            int offset = offsetHours * 100 + offsetMinutes;
            if (markerSpec.integerFormat.regular) {
                componentValue = DateTimeUtils.formatInteger(offset, markerSpec.integerFormat);
            } else {
                int numDigits = markerSpec.integerFormat.mandatoryDigits;
                if (numDigits == 1 || numDigits == 2) {
                    componentValue = DateTimeUtils.formatInteger(offsetHours, markerSpec.integerFormat);
                    if (offsetMinutes != 0) {
                        componentValue = componentValue + ":" + DateTimeUtils.formatInteger(offsetMinutes, "00");
                    }
                } else if (numDigits == 3 || numDigits == 4) {
                    componentValue = DateTimeUtils.formatInteger(offset, markerSpec.integerFormat);
                } else {
                    throw new EvaluateRuntimeException("The timezone integer format specifier cannot have more than four digits");
                }
            }
            if (offset >= 0) {
                componentValue = "+" + componentValue;
            }
            if (markerSpec.component == 'z') {
                componentValue = "GMT" + componentValue;
            }
            if (offset == 0 && markerSpec.presentation2 != null && markerSpec.presentation2.charValue() == 't') {
                componentValue = "Z";
            }
        }
        return componentValue;
    }

    private static String getDateTimeFragment(LocalDateTime date, Character component) {
        String componentValue = "";
        switch (component.charValue()) {
            case 'Y': {
                componentValue = "" + date.getYear();
                break;
            }
            case 'M': {
                componentValue = "" + date.getMonthValue();
                break;
            }
            case 'D': {
                componentValue = "" + date.getDayOfMonth();
                break;
            }
            case 'd': {
                componentValue = "" + date.getDayOfYear();
                break;
            }
            case 'F': {
                componentValue = "" + date.getDayOfWeek().getValue();
                break;
            }
            case 'W': {
                componentValue = "" + date.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
                break;
            }
            case 'w': {
                componentValue = "" + date.get(WeekFields.ISO.weekOfMonth());
                break;
            }
            case 'X': 
            case 'x': {
                componentValue = "-1";
                break;
            }
            case 'H': {
                componentValue = "" + date.getHour();
                break;
            }
            case 'h': {
                int hour = date.getHour();
                if (hour > 12) {
                    hour -= 12;
                } else if (hour == 0) {
                    hour = 12;
                }
                componentValue = "" + hour;
                break;
            }
            case 'P': {
                componentValue = date.getHour() < 12 ? "am" : "pm";
                break;
            }
            case 'm': {
                componentValue = "" + date.getMinute();
                break;
            }
            case 's': {
                componentValue = "" + date.getSecond();
                break;
            }
            case 'f': {
                componentValue = "" + date.getNano() / 1000000;
                break;
            }
            case 'Z': 
            case 'z': {
                break;
            }
            case 'C': {
                componentValue = "ISO";
                break;
            }
            case 'E': {
                componentValue = "ISO";
            }
        }
        return componentValue;
    }

    public static Long parseDateTime(String timestamp, String picture) {
        PictureFormat formatSpec = DateTimeUtils.analyseDateTimePicture(picture);
        PictureMatcher matchSpec = DateTimeUtils.generateRegex(formatSpec);
        String fullRegex = "^";
        for (MatcherPart part : matchSpec.parts) {
            fullRegex = fullRegex + "(" + part.regex + ")";
        }
        Pattern pattern = Pattern.compile(fullRegex = fullRegex + "$", 2);
        Matcher matcher = pattern.matcher(timestamp);
        if (matcher.find()) {
            boolean timeB;
            int dmA = 161;
            int dmB = 130;
            int dmC = 84;
            int dmD = 72;
            int tmA = 23;
            int tmB = 47;
            HashMap<Character, Integer> components = new HashMap<Character, Integer>();
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                MatcherPart mpart = matchSpec.parts.get(i - 1);
                try {
                    components.put(Character.valueOf(mpart.component), mpart.parse(matcher.group(i)));
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            if (components.size() == 0) {
                return null;
            }
            int mask = 0;
            for (Object part : (MatcherPart)"YXMxWwdD".toCharArray()) {
                mask <<= 1;
                if (components.get(Character.valueOf((char)part)) == null) continue;
                ++mask;
            }
            boolean dateA = DateTimeUtils.isType(dmA, mask);
            boolean dateB = !dateA && DateTimeUtils.isType(dmB, mask);
            boolean dateC = DateTimeUtils.isType(dmC, mask);
            boolean dateD = !dateC && DateTimeUtils.isType(dmD, mask);
            mask = 0;
            for (char part : "PHhmsf".toCharArray()) {
                mask <<= 1;
                if (components.get(Character.valueOf(part)) == null) continue;
                ++mask;
            }
            boolean timeA = DateTimeUtils.isType(tmA, mask);
            boolean bl = timeB = !timeA && DateTimeUtils.isType(tmB, mask);
            String dateComps = dateB ? "YB" : (dateC ? "XxwF" : (dateD ? "XWF" : "YMD"));
            String timeComps = timeB ? "Phmsf" : "Hmsf";
            String comps = dateComps + timeComps;
            LocalDateTime now = LocalDateTime.now(ZoneOffset.UTC);
            boolean startSpecified = false;
            boolean endSpecified = false;
            for (char part : comps.toCharArray()) {
                if (components.get(Character.valueOf(part)) == null) {
                    if (startSpecified) {
                        components.put(Character.valueOf(part), "MDd".indexOf(part) != -1 ? 1 : 0);
                        endSpecified = true;
                        continue;
                    }
                    components.put(Character.valueOf(part), Integer.parseInt(DateTimeUtils.getDateTimeFragment(now, Character.valueOf(part))));
                    continue;
                }
                startSpecified = true;
                if (!endSpecified) continue;
                throw new EvaluateRuntimeException("The date/time picture string is missing specifiers required to parse the timestamp");
            }
            if (components.get(Character.valueOf('M')) != null && (Integer)components.get(Character.valueOf('M')) > 0) {
                components.put(Character.valueOf('M'), (Integer)components.get(Character.valueOf('M')) - 1);
            } else {
                components.put(Character.valueOf('M'), 0);
            }
            if (dateB) {
                LocalDateTime firstJan = LocalDateTime.of((int)((Integer)components.get(Character.valueOf('Y'))), Month.JANUARY, 1, 0, 0);
                firstJan = firstJan.withDayOfYear((Integer)components.get(Character.valueOf('d')));
                components.put(Character.valueOf('M'), firstJan.getMonthValue() - 1);
                components.put(Character.valueOf('D'), firstJan.getDayOfMonth());
            }
            if (dateC) {
                throw new EvaluateRuntimeException("The date/time picture string is missing specifiers required to parse the timestamp");
            }
            if (dateD) {
                throw new EvaluateRuntimeException("The date/time picture string is missing specifiers required to parse the timestamp");
            }
            if (timeB) {
                components.put(Character.valueOf('H'), (Integer)components.get(Character.valueOf('h')) == 12 ? 0 : (Integer)components.get(Character.valueOf('h')));
                if ((Integer)components.get(Character.valueOf('P')) == 1) {
                    components.put(Character.valueOf('H'), (Integer)components.get(Character.valueOf('H')) + 12);
                }
            }
            LocalDateTime cal = LocalDateTime.of((int)((Integer)components.get(Character.valueOf('Y'))), (Integer)components.get(Character.valueOf('M')) + 1, (int)((Integer)components.get(Character.valueOf('D'))), (int)((Integer)components.get(Character.valueOf('H'))), (int)((Integer)components.get(Character.valueOf('m'))), (int)((Integer)components.get(Character.valueOf('s'))), (Integer)components.get(Character.valueOf('f')) * 1000000);
            long millis = cal.toInstant(ZoneOffset.UTC).toEpochMilli();
            if (components.get(Character.valueOf('Z')) != null) {
                millis -= (long)((Integer)components.get(Character.valueOf('Z')) * 60 * 1000);
            } else if (components.get(Character.valueOf('z')) != null) {
                millis -= (long)((Integer)components.get(Character.valueOf('z')) * 60 * 1000);
            }
            return millis;
        }
        return null;
    }

    private static boolean isType(int type, int mask) {
        return (~type & mask) == 0 && (type & mask) != 0;
    }

    private static PictureMatcher generateRegex(PictureFormat formatSpec) {
        PictureMatcher matcher = new PictureMatcher();
        for (final SpecPart part : formatSpec.parts) {
            MatcherPart res;
            if (part.type.equals("literal")) {
                Pattern p = Pattern.compile("[.*+?^${}()|\\[\\]\\\\]");
                Matcher m = p.matcher(part.value);
                String regex = m.replaceAll("\\\\$0");
                res = new MatcherPart(regex){

                    @Override
                    public int parse(String value) {
                        throw new UnsupportedOperationException();
                    }
                };
            } else if (part.component == 'Z' || part.component == 'z') {
                final boolean separator = part.integerFormat.groupingSeparators.size() == 1 && part.integerFormat.regular;
                String regex = "";
                if (part.component == 'z') {
                    regex = "GMT";
                }
                regex = regex + "[-+][0-9]+";
                if (separator) {
                    regex = regex + part.integerFormat.groupingSeparators.get((int)0).character + "[0-9]+";
                }
                res = new MatcherPart(regex){

                    @Override
                    public int parse(String value) {
                        if (part.component == 'z') {
                            value = value.substring(3);
                        }
                        int offsetHours = 0;
                        int offsetMinutes = 0;
                        if (separator) {
                            offsetHours = Integer.parseInt(value.substring(0, value.indexOf(part.integerFormat.groupingSeparators.get((int)0).character)));
                            offsetMinutes = Integer.parseInt(value.substring(value.indexOf(part.integerFormat.groupingSeparators.get((int)0).character) + 1));
                        } else {
                            int numdigits = value.length() - 1;
                            if (numdigits <= 2) {
                                offsetHours = Integer.parseInt(value);
                            } else {
                                offsetHours = Integer.parseInt(value.substring(0, 3));
                                offsetMinutes = Integer.parseInt(value.substring(3));
                            }
                        }
                        return offsetHours * 60 + offsetMinutes;
                    }
                };
            } else if (part.integerFormat != null) {
                res = DateTimeUtils.generateRegex(part.component, part.integerFormat);
            } else {
                String regex = "[a-zA-Z]+";
                final HashMap<String, Integer> lookup = new HashMap<String, Integer>();
                if (part.component == 'M' || part.component == 'x') {
                    for (int i = 0; i < months.length; ++i) {
                        if (part.width != null && part.width.getRight() != null) {
                            lookup.put(months[i].substring(0, part.width.getRight()), i + 1);
                            continue;
                        }
                        lookup.put(months[i], i + 1);
                    }
                } else if (part.component == 'F') {
                    for (int i = 1; i < days.length; ++i) {
                        if (part.width != null && part.width.getRight() != null) {
                            lookup.put(days[i].substring(0, part.width.getRight()), i);
                            continue;
                        }
                        lookup.put(days[i], i);
                    }
                } else if (part.component == 'P') {
                    lookup.put("am", 0);
                    lookup.put("AM", 0);
                    lookup.put("pm", 1);
                    lookup.put("PM", 1);
                } else {
                    throw new EvaluateRuntimeException(String.format("The 'name' modifier can only be applied to months and days in the date/time picture string, not %s", Character.valueOf(part.component)));
                }
                res = new MatcherPart(regex){

                    @Override
                    public int parse(String value) {
                        return (Integer)lookup.get(value);
                    }
                };
            }
            res.component = part.component;
            matcher.parts.add(res);
        }
        return matcher;
    }

    private static MatcherPart generateRegex(char component, final Format formatSpec) {
        MatcherPart matcher;
        final boolean isUpper = formatSpec.case_type == tcase.UPPER;
        switch (formatSpec.primary) {
            case LETTERS: {
                String regex = isUpper ? "[A-Z]+" : "[a-z]+";
                matcher = new MatcherPart(regex){

                    @Override
                    public int parse(String value) {
                        return DateTimeUtils.lettersToDecimal(value, isUpper ? (char)'A' : 'a');
                    }
                };
                break;
            }
            case ROMAN: {
                String regex = isUpper ? "[MDCLXVI]+" : "[mdclxvi]+";
                matcher = new MatcherPart(regex){

                    @Override
                    public int parse(String value) {
                        return DateTimeUtils.romanToDecimal(isUpper ? value : value.toUpperCase());
                    }
                };
                break;
            }
            case WORDS: {
                HashSet<String> words = new HashSet<String>();
                words.addAll(wordValues.keySet());
                words.add("and");
                words.add("[\\-, ]");
                String regex = "(?:" + String.join((CharSequence)"|", words.toArray(new String[words.size()])) + ")+";
                matcher = new MatcherPart(regex){

                    @Override
                    public int parse(String value) {
                        return DateTimeUtils.wordsToNumber(value.toLowerCase());
                    }
                };
                break;
            }
            case DECIMAL: {
                String regex = "[0-9]+";
                switch (component) {
                    case 'Y': {
                        regex = "[0-9]{2,4}";
                        break;
                    }
                    case 'D': 
                    case 'H': 
                    case 'M': 
                    case 'h': 
                    case 'm': 
                    case 's': {
                        regex = "[0-9]{1,2}";
                        break;
                    }
                }
                if (formatSpec.ordinal) {
                    regex = regex + "(?:th|st|nd|rd)";
                }
                matcher = new MatcherPart(regex){

                    @Override
                    public int parse(String value) {
                        String digits = value;
                        if (formatSpec.ordinal) {
                            digits = value.substring(0, value.length() - 2);
                        }
                        if (formatSpec.regular) {
                            digits = String.join((CharSequence)"", digits.split(","));
                        } else {
                            for (GroupingSeparator sep : formatSpec.groupingSeparators) {
                                digits = String.join((CharSequence)"", digits.split(sep.character));
                            }
                        }
                        if (formatSpec.zeroCode != 48) {
                            char[] chars = digits.toCharArray();
                            for (int i = 0; i < chars.length; ++i) {
                                chars[i] = (char)(chars[i] - formatSpec.zeroCode + 48);
                            }
                            digits = new String(chars);
                        }
                        return Integer.parseInt(digits);
                    }
                };
                break;
            }
            default: {
                throw new EvaluateRuntimeException("Formatting or parsing an integer as a sequence starting with %s is not supported by this implementation");
            }
        }
        return matcher;
    }

    private static int lettersToDecimal(String letters, char aChar) {
        int decimal = 0;
        char[] chars = letters.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            decimal = (int)((double)decimal + (double)(chars[chars.length - i - 1] - aChar + 1) * Math.pow(26.0, i));
        }
        return decimal;
    }

    static {
        String lword;
        int i;
        few = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"};
        ordinals = new String[]{"Zeroth", "First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth", "Eleventh", "Twelfth", "Thirteenth", "Fourteenth", "Fifteenth", "Sixteenth", "Seventeenth", "Eighteenth", "Nineteenth"};
        decades = new String[]{"Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety", "Hundred"};
        magnitudes = new String[]{"Thousand", "Million", "Billion", "Trillion"};
        wordValues = new HashMap<String, Integer>();
        for (i = 0; i < few.length; ++i) {
            wordValues.put(few[i].toLowerCase(), i);
        }
        for (i = 0; i < ordinals.length; ++i) {
            wordValues.put(ordinals[i].toLowerCase(), i);
        }
        for (i = 0; i < decades.length; ++i) {
            lword = decades[i].toLowerCase();
            wordValues.put(lword, (i + 2) * 10);
            wordValues.put(lword.substring(0, lword.length() - 1) + "ieth", wordValues.get(lword));
        }
        wordValues.put("hundreth", 100);
        for (i = 0; i < magnitudes.length; ++i) {
            lword = magnitudes[i].toLowerCase();
            int val = (int)Math.pow(10.0, (i + 1) * 3);
            wordValues.put(lword, val);
            wordValues.put(lword + "th", val);
        }
        romanNumerals = new RomanNumeral[]{new RomanNumeral(1000, "m"), new RomanNumeral(900, "cm"), new RomanNumeral(500, "d"), new RomanNumeral(400, "cd"), new RomanNumeral(100, "c"), new RomanNumeral(90, "xc"), new RomanNumeral(50, "l"), new RomanNumeral(40, "xl"), new RomanNumeral(10, "x"), new RomanNumeral(9, "ix"), new RomanNumeral(5, "v"), new RomanNumeral(4, "iv"), new RomanNumeral(1, "i")};
        romanValues = DateTimeUtils.createRomanValues();
        suffix123 = DateTimeUtils.createSuffixMap();
        decimalGroups = new int[]{48, 1632, 1776, 1984, 2406, 2534, 2662, 2790, 2918, 3046, 3174, 3302, 3430, 3558, 3664, 3792, 3872, 4160, 4240, 6112, 6160, 6470, 6608, 6784, 6800, 6992, 7088, 7232, 7248, 42528, 43216, 43264, 43472, 43504, 43600, 44016, 65296};
        defaultPresentationModifiers = DateTimeUtils.createDefaultPresentationModifiers();
        days = new String[]{"", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        iso8601Spec = null;
    }

    private static abstract class MatcherPart {
        String regex;
        char component;

        public abstract int parse(String var1);

        public MatcherPart(String regex) {
            this.regex = regex;
        }
    }

    private static class PictureMatcher {
        Vector<MatcherPart> parts = new Vector();

        private PictureMatcher() {
        }
    }

    private static class SpecPart {
        String type;
        String value;
        char component;
        Pair<Integer, Integer> width;
        String presentation1;
        Character presentation2;
        boolean ordinal = false;
        public tcase names;
        public Format integerFormat;
        public int n;

        public SpecPart(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public SpecPart(String type, char component) {
            this.type = type;
            this.component = component;
        }
    }

    private static class PictureFormat {
        String type;
        Vector<SpecPart> parts = new Vector();

        public PictureFormat(String type) {
            this.type = type;
        }

        public void addLiteral(String picture, int start, int end) {
            if (end > start) {
                String literal = picture.substring(start, end);
                literal = String.join((CharSequence)"]", literal.split("]]"));
                this.parts.add(new SpecPart("literal", literal));
            }
        }
    }

    private static class GroupingSeparator {
        public int position;
        public String character;

        public GroupingSeparator(int position, String character) {
            this.position = position;
            this.character = character;
        }
    }

    private static class Format {
        public String type = "integer";
        public formats primary = formats.DECIMAL;
        public tcase case_type = tcase.LOWER;
        public boolean ordinal = false;
        public int zeroCode = 0;
        public int mandatoryDigits = 0;
        public int optionalDigits = 0;
        public boolean regular = false;
        public Vector<GroupingSeparator> groupingSeparators = new Vector();
        public String token;

        private Format() {
        }
    }

    static enum tcase {
        UPPER("upper"),
        LOWER("lower"),
        TITLE("title");

        public String value;

        private tcase(String value) {
            this.value = value;
        }
    }

    static enum formats {
        DECIMAL("decimal"),
        LETTERS("letters"),
        ROMAN("roman"),
        WORDS("words"),
        SEQUENCE("sequence");

        public String value;

        private formats(String value) {
            this.value = value;
        }
    }

    private static class RomanNumeral {
        private int value;
        private String letters;

        public RomanNumeral(int value, String letters) {
            this.value = value;
            this.letters = letters;
        }

        public int getValue() {
            return this.value;
        }

        public String getLetters() {
            return this.letters;
        }
    }
}

