/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.testerui;

import com.api.jsonata4java.testerui.TesterUI;
import com.api.jsonata4java.testerui.TesterUIColors;
import com.api.jsonata4java.testerui.TesterUIFontChooser;
import com.api.jsonata4java.testerui.TesterUIJsonataExample;
import com.api.jsonata4java.testerui.TesterUISettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class TesterUIPreferences {
    private static final int FRAME_SIZE_X = 800;
    private static final int FRAME_SIZE_Y = 600;
    private static final int PAD = 5;
    private static final Insets INSETS = new Insets(5, 5, 5, 5);
    private static final String DOTS_3 = "...";
    private final TesterUI ui;
    private final TesterUISettings settings;
    private final JFrame frame = new JFrame("JSONata4Java Tester UI Settings");
    private final JTextField pathInput = new JTextField();
    private final JButton changePathInput = new JButton("...");
    private final JTextField pathJsonata = new JTextField();
    private final JButton changePathJsonata = new JButton("...");
    private final JComboBox<TesterUIJsonataExample> examples = new JComboBox<TesterUIJsonataExample>(TesterUIJsonataExample.values());
    private final JComboBox<TesterUIColors> colors = new JComboBox<TesterUIColors>(TesterUIColors.values());
    private final JTextField colorInput = new JTextField();
    private final JButton chooseColorInput = new JButton("Choose");
    private final JTextField colorJsonata = new JTextField();
    private final JButton chooseColorJsonata = new JButton("Choose");
    private final JTextField colorOutput = new JTextField();
    private final JButton chooseColorOutput = new JButton("Choose");
    private final JTextField colorError = new JTextField();
    private final JButton chooseColorError = new JButton("Choose");
    private final JTextField font = new JTextField();
    private final JButton chooseFont = new JButton("Choose");
    private final JPanel inputPanel = new JPanel();
    private final JPanel southPanel = new JPanel();
    private final JPanel buttonsPanel = new JPanel();
    private final JButton okButton = new JButton("Ok");

    public TesterUIPreferences(TesterUI ui, TesterUISettings settings) {
        this.ui = ui;
        this.settings = settings;
    }

    public void open() {
        this.readProps();
        this.initUi();
        this.frame.setVisible(true);
    }

    private void changeFilePath(JTextField textField, final String description, final String ... suffix) {
        File fileChosenBefore;
        JFileChooser fc = new JFileChooser();
        String path = textField.getText();
        File file = fileChosenBefore = path != null && path.trim().length() > 0 ? new File(path) : null;
        if (fileChosenBefore != null && fileChosenBefore.getParentFile().exists()) {
            fc.setCurrentDirectory(fileChosenBefore.getParentFile());
        }
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public boolean accept(File f) {
                return TesterUIPreferences.this.acceptFile(f, suffix);
            }
        });
        int ret = fc.showOpenDialog(this.frame.getContentPane());
        switch (ret) {
            case 0: {
                textField.setText(fc.getSelectedFile().getAbsolutePath());
                break;
            }
        }
    }

    private boolean acceptFile(File f, String ... suffix) {
        if (f.isDirectory()) {
            return true;
        }
        try {
            for (int i = 0; i < suffix.length; ++i) {
                if (!f.getName().endsWith(suffix[i])) continue;
                return true;
            }
            return false;
        }
        catch (StringIndexOutOfBoundsException e) {
            return false;
        }
    }

    private void readProps() {
        this.examples.setSelectedItem((Object)this.settings.getExample());
        this.pathInput.setText(this.settings.getPathInput().toString());
        this.pathJsonata.setText(this.settings.getPathJsonata().toString());
        this.colors.setSelectedItem((Object)TesterUIColors.fromColors(this.settings.getBackgroundInput(), this.settings.getBackgroundJsonata(), this.settings.getBackgroundOutput(), this.settings.getBackgroundError()));
        this.colorInput.setText(TesterUIPreferences.colorToUIText(this.settings.getBackgroundInput()));
        this.colorJsonata.setText(TesterUIPreferences.colorToUIText(this.settings.getBackgroundJsonata()));
        this.colorOutput.setText(TesterUIPreferences.colorToUIText(this.settings.getBackgroundOutput()));
        this.colorError.setText(TesterUIPreferences.colorToUIText(this.settings.getBackgroundError()));
        this.font.setText(TesterUISettings.fontToText(this.settings.getFont()));
    }

    private void close() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    private void initUi() {
        this.uiConfigure();
        this.uiSetListeners();
        this.uiCompose();
    }

    private void uiConfigure() {
        this.pathInput.setEditable(false);
        this.pathJsonata.setEditable(false);
        this.colorInput.setEditable(false);
        this.colorJsonata.setEditable(false);
        this.colorOutput.setEditable(false);
        this.colorError.setEditable(false);
        this.font.setEditable(false);
        this.frame.setLayout(new BorderLayout(0, 0));
        this.frame.setSize(800, 600);
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(2);
        this.inputPanel.setLayout(new GridBagLayout());
        this.southPanel.setLayout(new BorderLayout());
        this.buttonsPanel.setLayout(new GridBagLayout());
    }

    private void uiCompose() {
        int x = 1;
        int y = 1;
        this.inputPanel.add((Component)new JLabel("JSONata Examples"), new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add(this.examples, new GridBagConstraints(2, y++, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        x = 1;
        this.inputPanel.add((Component)new JLabel("Input JSON / XML Path"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add((Component)this.pathInput, new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        this.inputPanel.add((Component)this.changePathInput, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 13, 2, INSETS, 0, 0));
        x = 1;
        this.inputPanel.add((Component)new JLabel("JSONata Expression Path"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add((Component)this.pathJsonata, new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        this.inputPanel.add((Component)this.changePathJsonata, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 13, 2, INSETS, 0, 0));
        x = 1;
        this.inputPanel.add((Component)new JLabel("Default color schemas"), new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add(this.colors, new GridBagConstraints(2, y++, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        x = 1;
        this.inputPanel.add((Component)new JLabel("Input area background color"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add((Component)this.colorInput, new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        this.inputPanel.add((Component)this.chooseColorInput, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 13, 2, INSETS, 0, 0));
        x = 1;
        this.inputPanel.add((Component)new JLabel("Jsonata area background color"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add((Component)this.colorJsonata, new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        this.inputPanel.add((Component)this.chooseColorJsonata, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 13, 2, INSETS, 0, 0));
        x = 1;
        this.inputPanel.add((Component)new JLabel("Output area background color"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add((Component)this.colorOutput, new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        this.inputPanel.add((Component)this.chooseColorOutput, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 13, 2, INSETS, 0, 0));
        x = 1;
        this.inputPanel.add((Component)new JLabel("Error background color"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add((Component)this.colorError, new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        this.inputPanel.add((Component)this.chooseColorError, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 13, 2, INSETS, 0, 0));
        x = 1;
        this.inputPanel.add((Component)new JLabel("Font"), new GridBagConstraints(x++, y, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.inputPanel.add((Component)this.font, new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 13, 2, INSETS, 0, 0));
        this.inputPanel.add((Component)this.chooseFont, new GridBagConstraints(x++, y++, 1, 1, 0.0, 0.0, 13, 2, INSETS, 0, 0));
        this.buttonsPanel.add((Component)this.okButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.southPanel.add((Component)this.buttonsPanel, "South");
        this.frame.add((Component)this.inputPanel, "North");
        this.frame.add((Component)this.southPanel, "South");
    }

    private void uiSetListeners() {
        this.uiListenerFrame();
        this.uiListenerExamples();
        this.uiListenerChangePathInput();
        this.uiListenerChangePathJsonata();
        this.uiListenerColors();
        this.uiListenerColorInput(this.frame);
        this.uiListenerColorJsonata(this.frame);
        this.uiListenerColorOutput(this.frame);
        this.uiListenerColorError(this.frame);
        this.uiListenerFont(this);
        this.uiListenerOkButton();
    }

    private void uiListenerFrame() {
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                TesterUIPreferences.this.close();
            }
        });
    }

    private void uiListenerExamples() {
        this.examples.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterUIJsonataExample example = (TesterUIJsonataExample)((Object)TesterUIPreferences.this.examples.getSelectedItem());
                TesterUIPreferences.this.pathInput.setText(example.getPathInput().toAbsolutePath().toString());
                TesterUIPreferences.this.ui.loadInput(example.getPathInput());
                TesterUIPreferences.this.pathJsonata.setText(example.getPathJsonata().toAbsolutePath().toString());
                TesterUIPreferences.this.ui.loadJsonata(example.getPathJsonata());
                TesterUIPreferences.this.settings.setExample((TesterUIJsonataExample)((Object)TesterUIPreferences.this.examples.getSelectedItem()));
            }
        });
    }

    private void uiListenerChangePathInput() {
        this.changePathInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pathBefore = TesterUIPreferences.this.pathInput.getText();
                TesterUIPreferences.this.changeFilePath(TesterUIPreferences.this.pathInput, "JSON or XML", ".json", ".xml");
                if (!TesterUIPreferences.this.pathInput.getText().equals(pathBefore)) {
                    TesterUIPreferences.this.ui.loadInput(new File(TesterUIPreferences.this.pathInput.getText()).toPath());
                    TesterUIPreferences.this.settings.setPathInput(new File(TesterUIPreferences.this.pathInput.getText()).toPath());
                }
            }
        });
    }

    private void uiListenerChangePathJsonata() {
        this.changePathJsonata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pathBefore = TesterUIPreferences.this.pathInput.getText();
                TesterUIPreferences.this.changeFilePath(TesterUIPreferences.this.pathJsonata, "JSONata mapping description", ".jsonata");
                if (!TesterUIPreferences.this.pathJsonata.getText().equals(pathBefore)) {
                    TesterUIPreferences.this.ui.loadJsonata(new File(TesterUIPreferences.this.pathJsonata.getText()).toPath());
                    TesterUIPreferences.this.settings.setPathJsonata(new File(TesterUIPreferences.this.pathJsonata.getText()).toPath());
                }
            }
        });
    }

    private void uiListenerColors() {
        this.colors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterUIColors selColors = (TesterUIColors)((Object)TesterUIPreferences.this.colors.getSelectedItem());
                if (selColors == TesterUIColors.CUSTOM) {
                    return;
                }
                TesterUIPreferences.this.colorInput.setText(TesterUIPreferences.colorToUIText(selColors.getColorInput()));
                TesterUIPreferences.this.settings.setBackgroundInput(selColors.getColorInput());
                TesterUIPreferences.this.ui.setBackgroundInput(selColors.getColorInput());
                TesterUIPreferences.this.colorJsonata.setText(TesterUIPreferences.colorToUIText(selColors.getColorJsonata()));
                TesterUIPreferences.this.settings.setBackgroundJsonata(selColors.getColorJsonata());
                TesterUIPreferences.this.ui.setBackgroundJsonata(selColors.getColorJsonata());
                TesterUIPreferences.this.colorOutput.setText(TesterUIPreferences.colorToUIText(selColors.getColorOutput()));
                TesterUIPreferences.this.settings.setBackgroundOutput(selColors.getColorOutput());
                TesterUIPreferences.this.ui.setBackgroundOutput(selColors.getColorOutput());
                TesterUIPreferences.this.colorError.setText(TesterUIPreferences.colorToUIText(selColors.getColorError()));
                TesterUIPreferences.this.settings.setBackgroundError(selColors.getColorError());
            }
        });
    }

    private void uiListenerColorInput(final JFrame parent) {
        this.chooseColorInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(parent, "JSONata4Java: Choose Background Color For Input Area", TesterUIPreferences.this.settings.getBackgroundInput());
                if (newColor == null) {
                    return;
                }
                TesterUIPreferences.this.colorInput.setText(TesterUIPreferences.colorToUIText(newColor));
                TesterUIPreferences.this.settings.setBackgroundInput(newColor);
                TesterUIPreferences.this.ui.setBackgroundInput(newColor);
                TesterUIPreferences.this.colors.setSelectedItem((Object)TesterUIColors.fromColors(TesterUIPreferences.this.settings.getBackgroundInput(), TesterUIPreferences.this.settings.getBackgroundJsonata(), TesterUIPreferences.this.settings.getBackgroundOutput(), TesterUIPreferences.this.settings.getBackgroundError()));
            }
        });
    }

    private void uiListenerColorJsonata(final JFrame parent) {
        this.chooseColorJsonata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(parent, "JSONata4Java: Choose Background Color For JSONata Area", TesterUIPreferences.this.settings.getBackgroundJsonata());
                if (newColor == null) {
                    return;
                }
                TesterUIPreferences.this.colorJsonata.setText(TesterUIPreferences.colorToUIText(newColor));
                TesterUIPreferences.this.settings.setBackgroundJsonata(newColor);
                TesterUIPreferences.this.ui.setBackgroundJsonata(newColor);
                TesterUIPreferences.this.colors.setSelectedItem((Object)TesterUIColors.fromColors(TesterUIPreferences.this.settings.getBackgroundInput(), TesterUIPreferences.this.settings.getBackgroundJsonata(), TesterUIPreferences.this.settings.getBackgroundOutput(), TesterUIPreferences.this.settings.getBackgroundError()));
            }
        });
    }

    private void uiListenerColorOutput(final JFrame parent) {
        this.chooseColorOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(parent, "JSONata4Java: Choose Background Color For Output area", TesterUIPreferences.this.settings.getBackgroundOutput());
                if (newColor == null) {
                    return;
                }
                TesterUIPreferences.this.colorOutput.setText(TesterUIPreferences.colorToUIText(newColor));
                TesterUIPreferences.this.settings.setBackgroundOutput(newColor);
                TesterUIPreferences.this.ui.setBackgroundOutput(newColor);
                TesterUIPreferences.this.colors.setSelectedItem((Object)TesterUIColors.fromColors(TesterUIPreferences.this.settings.getBackgroundInput(), TesterUIPreferences.this.settings.getBackgroundJsonata(), TesterUIPreferences.this.settings.getBackgroundOutput(), TesterUIPreferences.this.settings.getBackgroundError()));
            }
        });
    }

    private void uiListenerColorError(final JFrame parent) {
        this.chooseColorError.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(parent, "JSONata4Java: Choose Background Color For Areas With Error", TesterUIPreferences.this.settings.getBackgroundError());
                if (newColor == null) {
                    return;
                }
                TesterUIPreferences.this.colorError.setText(TesterUIPreferences.colorToUIText(newColor));
                TesterUIPreferences.this.settings.setBackgroundError(newColor);
                TesterUIPreferences.this.colors.setSelectedItem((Object)TesterUIColors.fromColors(TesterUIPreferences.this.settings.getBackgroundInput(), TesterUIPreferences.this.settings.getBackgroundJsonata(), TesterUIPreferences.this.settings.getBackgroundOutput(), TesterUIPreferences.this.settings.getBackgroundError()));
            }
        });
    }

    private void uiListenerFont(final TesterUIPreferences dialog) {
        this.chooseFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TesterUIFontChooser(TesterUIPreferences.this.ui, TesterUIPreferences.this.settings, dialog).open();
            }
        });
    }

    private void uiListenerOkButton() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TesterUIPreferences.this.close();
            }
        });
    }

    private static String colorToUIText(Color in) {
        return "#" + Integer.toHexString(in.getRGB()).substring(2).toUpperCase();
    }

    public void setFont(Font newFont) {
        this.font.setText(TesterUISettings.fontToText(newFont));
    }
}

