/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client.staging;

public class StagingStringRange {
    private String _low;
    private String _high;

    public StagingStringRange() {
    }

    public StagingStringRange(String low, String high) {
        if (low == null || high == null) {
            throw new IllegalStateException("Invalid range");
        }
        if (low.length() != high.length()) {
            throw new IllegalStateException("Range strings must be the same length: '" + low + "-" + high + "'");
        }
        if (low.compareTo(high) > 0) {
            throw new IllegalStateException("Low value of range is greater than high value: '" + low + "-" + high + "'");
        }
        this._low = low;
        this._high = high;
    }

    private boolean matchesAll() {
        return this._low == null && this._high == null;
    }

    public boolean contains(String value) {
        return this.matchesAll() || value != null && this._low.compareTo(value) <= 0 && this._high.compareTo(value) >= 0;
    }
}

