/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerapi.client.disease;

import com.imsweb.seerapi.client.disease.Disease;
import com.imsweb.seerapi.client.disease.DiseaseChangelogResults;
import com.imsweb.seerapi.client.disease.DiseaseSearchResults;
import com.imsweb.seerapi.client.disease.DiseaseVersion;
import com.imsweb.seerapi.client.disease.PrimarySite;
import com.imsweb.seerapi.client.disease.SamePrimaries;
import com.imsweb.seerapi.client.disease.SiteCategory;
import java.util.List;
import java.util.Map;
import retrofit.http.Body;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.Path;
import retrofit.http.Query;
import retrofit.http.QueryMap;

public interface DiseaseService {
    @GET(value="/disease/versions")
    public List<DiseaseVersion> versions();

    @GET(value="/disease/{version}")
    public DiseaseSearchResults search(@Path(value="version") String var1, @Query(value="q") String var2);

    @GET(value="/disease/{version}")
    public DiseaseSearchResults search(@Path(value="version") String var1, @QueryMap Map<String, String> var2);

    @GET(value="/disease/{version}/id/{id}")
    public Disease getById(@Path(value="version") String var1, @Path(value="id") String var2);

    @GET(value="/disease/{version}/id/{id}")
    public Disease getById(@Path(value="version") String var1, @Path(value="id") String var2, @Query(value="glossary") boolean var3);

    @GET(value="/disease/primary_site")
    public List<PrimarySite> primarySites();

    @GET(value="/disease/primary_site/{code}")
    public List<PrimarySite> primarySiteCode(@Path(value="code") String var1);

    @GET(value="/disease/site_categories")
    public List<SiteCategory> siteCategories();

    @GET(value="/disease/{version}/same_primary")
    public SamePrimaries samePrimaries(@Path(value="version") String var1, @Query(value="d1") String var2, @Query(value="d2") String var3, @Query(value="year") String var4);

    @POST(value="/disease/reportability")
    public Disease reportability(@Body Disease var1);

    @GET(value="/disease/{version}/changelog")
    public DiseaseChangelogResults diseaseChangelogs(@Path(value="version") String var1, @Query(value="from") String var2, @Query(value="to") String var3, @Query(value="count") Integer var4);
}

