/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.staging.entities;

import com.imsweb.decisionengine.DecisionEngine;
import com.imsweb.decisionengine.Range;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Property;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

@Embedded
@Entity(noClassnameStored=true)
public class StagingRange
extends Range {
    @Property(value="low")
    private String _low;
    @Property(value="high")
    private String _high;

    public StagingRange() {
    }

    public StagingRange(String low, String high) {
        if (low == null || high == null) {
            throw new IllegalStateException("Invalid range");
        }
        this._low = low;
        this._high = high;
    }

    public static boolean isNumeric(String value) {
        return NumberUtils.isParsable((String)value);
    }

    public String getLow() {
        return this._low;
    }

    public String getHigh() {
        return this._high;
    }

    public boolean matchesAll() {
        return this._low == null && this._high == null;
    }

    @Override
    public boolean contains(String value, Map<String, String> context) {
        String high;
        String low;
        if (this.matchesAll()) {
            return true;
        }
        if (value == null) {
            value = "";
        }
        if (!(low = DecisionEngine.translateValue(this._low, context)).equals(high = DecisionEngine.translateValue(this._high, context)) && StagingRange.isNumeric(low) && StagingRange.isNumeric(high)) {
            if (!StagingRange.isNumeric(value)) {
                return false;
            }
            Float converted = NumberUtils.createFloat((String)value);
            return converted.floatValue() >= NumberUtils.createFloat((String)low).floatValue() && converted.floatValue() <= NumberUtils.createFloat((String)high).floatValue();
        }
        if (low.length() != high.length() || low.length() != value.length()) {
            return false;
        }
        return low.compareTo(value) <= 0 && high.compareTo(value) >= 0;
    }
}

