/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.functionality.Functionality;
import com.metaring.framework.functionality.FunctionalityStackElement;
import com.metaring.framework.functionality.FunctionalityStackElementSeries;
import java.util.LinkedList;
import java.util.List;

class FunctionalityStack {
    private LinkedList<Functionality> linkedList = new LinkedList();

    public int getCardinality() {
        return this.linkedList.size();
    }

    public void add(Functionality functionality) {
        this.linkedList.addLast(functionality);
    }

    public Functionality removeLast() {
        return this.linkedList.removeLast();
    }

    public Functionality getFirst() {
        return this.linkedList.getFirst();
    }

    public Functionality getPenultimate() {
        if (this.linkedList.size() == 1) {
            return null;
        }
        return this.linkedList.get(this.linkedList.size() - 2);
    }

    public Functionality getLast() {
        return this.linkedList.getLast();
    }

    public Functionality getAt(int index) {
        return this.linkedList.get(index);
    }

    public Functionality getFirstOfType(String functionalityFullyQualifiedName) {
        try {
            return this.linkedList.stream().filter(f -> f.getInfo().getFunctionalityFullyQualifiedName().equals(functionalityFullyQualifiedName)).findFirst().get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Functionality getPenultimateOfType(String functionalityFullyQualifiedName) {
        try {
            Functionality[] functionalities = (Functionality[])this.linkedList.stream().filter(f -> f.getInfo().getFunctionalityFullyQualifiedName().equals(functionalityFullyQualifiedName)).toArray();
            return functionalities[functionalities.length - 2];
        }
        catch (Exception e) {
            return null;
        }
    }

    public Functionality getLastOfType(String functionalityFullyQualifiedName) {
        try {
            Functionality[] functionalities = (Functionality[])this.linkedList.stream().filter(f -> f.getInfo().getFunctionalityFullyQualifiedName().equals(functionalityFullyQualifiedName)).toArray();
            return functionalities[functionalities.length - 1];
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isEmpty() {
        return this.linkedList.isEmpty();
    }

    public void purge() {
        this.linkedList.clear();
        this.linkedList = null;
    }

    public FunctionalityStackElementSeries toStackElementSeries() {
        return this.getStackElementSeries(this.linkedList);
    }

    public FunctionalityStackElementSeries toStackElementSeriesTillNow(Functionality functionality) {
        return this.getStackElementSeries(this.linkedList.subList(0, this.linkedList.indexOf(functionality) + 1));
    }

    private final FunctionalityStackElementSeries getStackElementSeries(List<Functionality> functionalities) {
        LinkedList<FunctionalityStackElement> stack = new LinkedList<FunctionalityStackElement>();
        for (Functionality functionality : functionalities) {
            stack.addLast(FunctionalityStackElement.create(functionality.getInfo().getFunctionalityFullyQualifiedName(), functionality.getCurrentStep()));
        }
        return FunctionalityStackElementSeries.create(stack.toArray(new FunctionalityStackElement[stack.size()]));
    }
}

