/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.Tools;
import com.metaring.framework.functionality.AbstractFunctionalityExecutionError;
import com.metaring.framework.functionality.FunctionalityErrorTypeEnumerator;
import com.metaring.framework.functionality.FunctionalityStackElementSeries;
import com.metaring.framework.functionality.FunctionalityStepErrorData;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.type.series.TextSeries;

public class FunctionalityExecutionError
extends AbstractFunctionalityExecutionError {
    private static final String INTERNAL_PLATFORM_ERROR = "InternalPlatformError";

    protected FunctionalityExecutionError(FunctionalityStackElementSeries functionalityStackElementSeries, FunctionalityStepErrorData errorData) {
        super(functionalityStackElementSeries, errorData);
    }

    public static FunctionalityExecutionError fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        FunctionalityStackElementSeries stack = null;
        if (dataRepresentation.hasProperty("stack").booleanValue()) {
            stack = (FunctionalityStackElementSeries)dataRepresentation.get("stack", FunctionalityStackElementSeries.class);
        }
        FunctionalityStepErrorData errorData = null;
        if (dataRepresentation.hasProperty("errorData").booleanValue()) {
            errorData = (FunctionalityStepErrorData)dataRepresentation.get("errorData", FunctionalityStepErrorData.class);
        } else if (dataRepresentation.hasProperty("codeName").booleanValue()) {
            errorData = FunctionalityStepErrorData.create(FunctionalityErrorTypeEnumerator.MANAGED, dataRepresentation.getText("codeName"), dataRepresentation.getTextSeries("payload"), null, -1L);
        }
        FunctionalityExecutionError functionalityExecutionError = FunctionalityExecutionError.create(stack, errorData);
        return functionalityExecutionError;
    }

    @Override
    public DataRepresentation toDataRepresentation() {
        TextSeries payload;
        FunctionalityStepErrorData errorData = this.getErrorData();
        if (errorData == null) {
            return Tools.FACTORY_DATA_REPRESENTATION.fromJson("null");
        }
        String name = errorData.getName();
        FunctionalityErrorTypeEnumerator type = errorData.getType();
        if (name == null || type == FunctionalityErrorTypeEnumerator.UNMANAGED) {
            name = INTERNAL_PLATFORM_ERROR;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        dataRepresentation.add("codeName", name);
        if (type == FunctionalityErrorTypeEnumerator.MANAGED && (payload = errorData.getPayload()) != null) {
            dataRepresentation.add("payload", payload);
        }
        return dataRepresentation;
    }
}

