/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.controller.AbstractBaseController;
import com.metaring.framework.exception.ManagedException;
import com.metaring.framework.functionality.Functionality;
import com.metaring.framework.functionality.FunctionalityContext;
import com.metaring.framework.functionality.FunctionalityControllerManager;
import com.metaring.framework.functionality.FunctionalityErrorTypeEnumerator;
import com.metaring.framework.functionality.FunctionalityExecutionError;
import com.metaring.framework.functionality.FunctionalityExecutionResult;
import com.metaring.framework.functionality.FunctionalityExecutionStepEnumerator;
import com.metaring.framework.functionality.FunctionalityExecutionVerdictEnumerator;
import com.metaring.framework.functionality.FunctionalityExecutionWarningDataSeries;
import com.metaring.framework.functionality.FunctionalityInfo;
import com.metaring.framework.functionality.FunctionalityInstance;
import com.metaring.framework.functionality.FunctionalityStepErrorData;
import com.metaring.framework.functionality.GeneratedFunctionality;
import com.metaring.framework.functionality.InternalStepExectutionException;
import com.metaring.framework.functionality.UnmanagedException;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.type.Email;
import com.metaring.framework.type.series.DigitSeries;
import com.metaring.framework.type.series.EmailSeries;
import com.metaring.framework.type.series.RealDigitSeries;
import com.metaring.framework.type.series.TextSeries;
import com.metaring.framework.type.series.TruthSeries;
import com.metaring.framework.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;

public abstract class AbstractFunctionality
extends AbstractBaseController
implements Functionality {
    protected static final CompletableFuture<Void> end = CompletableFuture.completedFuture(null);
    protected static final Executor EXECUTOR = FunctionalityControllerManager.INSTANCE;
    private final FunctionalityInfo functionalityInfo;
    private final String functionalityName;
    private final Class<?> outputClass;
    private final List<BiFunction<Object, Object, CompletableFuture<?>>> steps = new ArrayList();
    private final LinkedList<FunctionalityInstance> queue = new LinkedList();

    protected AbstractFunctionality(FunctionalityInfo functionalityInfo, Class<?> outputClass) {
        this.functionalityInfo = functionalityInfo;
        this.functionalityName = "[" + functionalityInfo.getFunctionalityFullyQualifiedName() + "] [";
        this.outputClass = outputClass;
        this.setLoggerStackPosition();
        this.fillSteps();
    }

    private final void fillSteps() {
        if (!this.steps.isEmpty()) {
            return;
        }
        this.steps.add(null);
        this.steps.add((input, output) -> {
            try {
                return this.beforePreConditionCheck(input);
            }
            catch (Exception e) {
                throw new InternalStepExectutionException(e);
            }
        });
        this.steps.add((input, output) -> {
            try {
                return this.preConditionCheck(input);
            }
            catch (Exception e) {
                throw new InternalStepExectutionException(e);
            }
        });
        this.steps.add((input, output) -> {
            try {
                return this.afterPreConditionCheck(input);
            }
            catch (Exception e) {
                throw new InternalStepExectutionException(e);
            }
        });
        this.steps.add((input, output) -> {
            try {
                return this.beforeCall(input);
            }
            catch (Exception e) {
                throw new InternalStepExectutionException(e);
            }
        });
        this.steps.add((input, output) -> {
            try {
                return this.call(input);
            }
            catch (Exception e) {
                throw new InternalStepExectutionException(e);
            }
        });
        this.steps.add((input, output) -> {
            try {
                return this.afterCall(input, output);
            }
            catch (Exception e) {
                throw new InternalStepExectutionException(e);
            }
        });
        this.steps.add((input, output) -> {
            try {
                return this.beforePostConditionCheck(input, output);
            }
            catch (Exception e) {
                throw new InternalStepExectutionException(e);
            }
        });
        this.steps.add((input, output) -> {
            try {
                return this.postConditionCheck(input, output);
            }
            catch (Exception e) {
                throw new InternalStepExectutionException(e);
            }
        });
        this.steps.add((input, output) -> {
            try {
                return this.afterPostConditionCheck(input, output);
            }
            catch (Exception e) {
                throw new InternalStepExectutionException(e);
            }
        });
    }

    private static final CompletableFuture<Object> wrap(Object input, Object output, BiFunction<Object, Object, CompletableFuture<?>> function) {
        if (function == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Object> wrap = new CompletableFuture<Object>();
        CompletableFuture.runAsync(() -> {
            try {
                ((CompletableFuture)function.apply(input, output)).whenComplete((result, error) -> {
                    if (error != null) {
                        wrap.completeExceptionally((Throwable)error);
                        return;
                    }
                    wrap.complete(result);
                });
            }
            catch (Exception e) {
                wrap.completeExceptionally(e);
            }
        }, EXECUTOR);
        return wrap;
    }

    @Override
    public final FunctionalityInfo getInfo() {
        return this.functionalityInfo;
    }

    @Override
    public FunctionalityExecutionStepEnumerator getCurrentStep() {
        return FunctionalityExecutionStepEnumerator.getByNumericValue(this.queue.getFirst().currentStep);
    }

    @Override
    public final FunctionalityContext getContext() {
        return this.queue.getFirst().functionalityContext;
    }

    protected final CompletableFuture<FunctionalityExecutionResult> execute(FunctionalityContext functionalityContext, Object input) {
        functionalityContext.getStack().add(this);
        FunctionalityInstance functionalityInstance = new FunctionalityInstance(functionalityContext, input);
        this.queue.addLast(functionalityInstance);
        if (this.queue.size() == 1) {
            CompletableFuture.runAsync(this::run, EXECUTOR);
        }
        return functionalityInstance.response;
    }

    private final void run() {
        if (this.queue.isEmpty()) {
            return;
        }
        FunctionalityInstance functionalityInstance = this.queue.getFirst();
        AbstractFunctionality.wrap(functionalityInstance.input, functionalityInstance.output, this.steps.get(functionalityInstance.currentStep.intValue())).whenCompleteAsync((result, error) -> {
            if (error != null) {
                AbstractFunctionality.errorOccurred(functionalityInstance.functionalityContext, error);
            } else if (FunctionalityExecutionStepEnumerator.getByNumericValue(functionalityInstance.currentStep) == FunctionalityExecutionStepEnumerator.CALL) {
                functionalityInstance.output = AbstractFunctionality.cleanOutput(result, this.outputClass);
            }
            Long l = functionalityInstance.currentStep;
            Long l2 = functionalityInstance.currentStep = Long.valueOf(functionalityInstance.currentStep + 1L);
            this.queue.removeFirst();
            if (error == null && functionalityInstance.currentStep <= FunctionalityExecutionStepEnumerator.AFTER_POST_CONDITION_CHECK.getNumericValue()) {
                this.queue.addLast(functionalityInstance);
            } else {
                AbstractFunctionality.terminateStepExecution(functionalityInstance.functionalityContext).whenComplete((v, e) -> {
                    if (e != null) {
                        functionalityInstance.response.completeExceptionally((Throwable)e);
                        return;
                    }
                    functionalityInstance.response.complete(AbstractFunctionality.buildResult(functionalityInstance, this.outputClass));
                });
            }
            if (!this.queue.isEmpty()) {
                CompletableFuture.runAsync(this::run, EXECUTOR);
            }
        }, EXECUTOR);
    }

    private static final FunctionalityExecutionResult buildResult(FunctionalityInstance functionalityInstance, Class<?> outputClass) {
        FunctionalityExecutionError executionError = functionalityInstance.functionalityContext.executionError;
        FunctionalityExecutionWarningDataSeries warnings = functionalityInstance.functionalityContext.getWarnings();
        FunctionalityExecutionVerdictEnumerator verdict = executionError == null ? (warnings == null || warnings.isEmpty() ? FunctionalityExecutionVerdictEnumerator.SUCCESS : FunctionalityExecutionVerdictEnumerator.WARNING) : FunctionalityExecutionVerdictEnumerator.FAULT;
        functionalityInstance.functionalityContext.getStack().removeLast();
        if (functionalityInstance.functionalityContext.getStack().isEmpty()) {
            try {
                functionalityInstance.functionalityContext.purge();
            }
            catch (UnmanagedException unmanagedException) {
                // empty catch block
            }
        }
        return FunctionalityExecutionResult.create(verdict, warnings, executionError, outputClass == null ? null : outputClass.getName(), Tools.FACTORY_DATA_REPRESENTATION.fromObject(functionalityInstance.output));
    }

    private static final void errorOccurred(FunctionalityContext functionalityContext, Throwable throwable) {
        if (functionalityContext.executionError != null) {
            return;
        }
        while (throwable != null && throwable.getCause() != null && (throwable instanceof InternalStepExectutionException || throwable instanceof CompletionException || throwable != throwable.getCause())) {
            throwable = throwable.getCause();
        }
        long row = -1L;
        try {
            StackTraceElement[] elements = throwable.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                if (!GeneratedFunctionality.class.isAssignableFrom(Class.forName(elements[i].getClassName()))) continue;
                row = elements[i].getLineNumber();
                break;
            }
        }
        catch (Exception elements) {
            // empty catch block
        }
        FunctionalityErrorTypeEnumerator type = FunctionalityErrorTypeEnumerator.UNMANAGED;
        String errorMessage = StringUtil.fromThrowableToString((Throwable)throwable);
        String errorName = null;
        TextSeries errorPayload = null;
        if (throwable instanceof ManagedException) {
            type = FunctionalityErrorTypeEnumerator.MANAGED;
            ManagedException me = (ManagedException)throwable;
            errorName = me.getName();
            errorPayload = me.getPayload();
        }
        functionalityContext.executionError = FunctionalityExecutionError.create(functionalityContext.getStackElementSeries(), FunctionalityStepErrorData.create(type, errorName, errorPayload, errorMessage, row));
    }

    protected final <T> CompletableFuture<T> end(T t) {
        return CompletableFuture.completedFuture(t);
    }

    protected abstract CompletableFuture<Void> beforePreConditionCheck(Object var1) throws Exception;

    protected abstract CompletableFuture<Void> preConditionCheck(Object var1) throws Exception;

    protected abstract CompletableFuture<Void> afterPreConditionCheck(Object var1) throws Exception;

    protected abstract CompletableFuture<Void> beforeCall(Object var1) throws Exception;

    protected abstract CompletableFuture<Object> call(Object var1) throws Exception;

    protected abstract CompletableFuture<Void> afterCall(Object var1, Object var2) throws Exception;

    protected abstract CompletableFuture<Void> beforePostConditionCheck(Object var1, Object var2) throws Exception;

    protected abstract CompletableFuture<Void> postConditionCheck(Object var1, Object var2) throws Exception;

    protected abstract CompletableFuture<Void> afterPostConditionCheck(Object var1, Object var2) throws Exception;

    private static final Object cleanOutput(Object output, Class<?> outputClass) {
        if (outputClass == null) {
            return null;
        }
        if (output == null) {
            return null;
        }
        boolean simpleInstance = outputClass.isInstance(output);
        if (simpleInstance) {
            return output;
        }
        if (output instanceof DataRepresentation) {
            Class<GeneratedCoreType> generatedCoreTypeClass;
            DataRepresentation dataRepresentation = (DataRepresentation)output;
            if (outputClass.equals(String.class) && dataRepresentation.isText().booleanValue()) {
                return dataRepresentation.asText();
            }
            if (outputClass.equals(Long.class) && dataRepresentation.isDigit().booleanValue()) {
                return dataRepresentation.asDigit();
            }
            if (outputClass.equals(Double.class) && dataRepresentation.isRealDigit().booleanValue()) {
                return dataRepresentation.asRealDigit();
            }
            if (outputClass.equals(Boolean.class) && dataRepresentation.isTruth().booleanValue()) {
                return dataRepresentation.asTruth();
            }
            if (outputClass.equals(Email.class) && dataRepresentation.isEmail().booleanValue()) {
                return dataRepresentation.asEmail();
            }
            if (outputClass.equals(TextSeries.class) && dataRepresentation.isTextSeries().booleanValue()) {
                return dataRepresentation.asTextSeries();
            }
            if (outputClass.equals(DigitSeries.class) && dataRepresentation.isDigitSeries().booleanValue()) {
                return dataRepresentation.asDigitSeries();
            }
            if (outputClass.equals(RealDigitSeries.class) && dataRepresentation.isRealDigitSeries().booleanValue()) {
                return dataRepresentation.asRealDigitSeries();
            }
            if (outputClass.equals(TruthSeries.class) && dataRepresentation.isTruthSeries().booleanValue()) {
                return dataRepresentation.asTruthSeries();
            }
            if (outputClass.equals(EmailSeries.class) && dataRepresentation.isEmailSeries().booleanValue()) {
                return dataRepresentation.asEmailSeries();
            }
            if (outputClass.isAssignableFrom(GeneratedCoreType.class) && dataRepresentation.is(generatedCoreTypeClass = outputClass).booleanValue()) {
                return dataRepresentation.as(generatedCoreTypeClass);
            }
        }
        return null;
    }

    private static final CompletableFuture<Void> terminateStepExecution(FunctionalityContext functionalityContext) {
        if (functionalityContext.executionError != null) {
            return functionalityContext.rollbackTransaction();
        }
        if (functionalityContext.getStack().getCardinality() == 1) {
            return functionalityContext.commitTransaction();
        }
        return end;
    }

    private final String getPrologue() {
        return this.functionalityName + Thread.currentThread().getName() + "] [" + this.getCurrentStep().getName() + "] [" + new Exception().getStackTrace()[2].getLineNumber() + "] ";
    }

    protected final void entering() {
        super.entering(this.getPrologue());
    }

    protected final void exiting() {
        super.exiting(this.getPrologue());
    }

    protected final void info(String messageString, String ... messages) {
        ArrayList<String> list = messages != null && messages.length > 0 ? Arrays.asList(messages) : new ArrayList<String>();
        list.add(0, messageString);
        super.info(this.getPrologue(), list.toArray(new String[list.size()]));
    }

    protected final void debug(String messageString, String ... messages) {
        ArrayList<String> list = messages != null && messages.length > 0 ? Arrays.asList(messages) : new ArrayList<String>();
        list.add(0, messageString);
        super.debug(this.getPrologue(), list.toArray(new String[list.size()]));
    }

    protected final void config(String parameterNameString, Object parameterValue) {
        super.config(this.getPrologue() + parameterNameString, parameterValue);
    }

    protected final void warning(String messageString, String ... messages) {
        ArrayList<String> list = messages != null && messages.length > 0 ? Arrays.asList(messages) : new ArrayList<String>();
        list.add(0, messageString);
        super.warning(this.getPrologue(), list.toArray(new String[list.size()]));
    }

    protected final void severe(String messageString, String ... messages) {
        ArrayList<String> list = messages != null && messages.length > 0 ? Arrays.asList(messages) : new ArrayList<String>();
        list.add(0, messageString);
        super.severe(this.getPrologue(), list.toArray(new String[list.size()]));
    }

    protected final void severe(Throwable t, String ... messages) {
        ArrayList<String> list = messages != null && messages.length > 0 ? Arrays.asList(messages) : new ArrayList<String>();
        list.add(0, StringUtil.fromThrowableToString((Throwable)t));
        super.severe(this.getPrologue(), list.toArray(new String[list.size()]));
    }

    @Override
    public final Object getInputFromJson(String inputJson) {
        if (StringUtil.isNullOrEmpty((String)inputJson)) {
            return null;
        }
        if (inputJson.trim().equalsIgnoreCase("null")) {
            return null;
        }
        return this.getInputFromJsonWork(inputJson);
    }

    protected Object getInputFromJsonWork(String inputJson) {
        return null;
    }

    protected final void setContextData(String key, Object value) {
        this.queue.getFirst().functionalityContext.getData().put(key, value);
    }

    protected final <T> T getContextData(String key) {
        return (T)this.queue.getFirst().functionalityContext.getData().get(key);
    }

    protected final <T extends GeneratedCoreType> T getContextData(String key, Class<? extends T> clazz) {
        return (T)((DataRepresentation)this.getContextData(key)).as(clazz);
    }
}

