/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.functionality;

import com.metaring.framework.Core;
import com.metaring.framework.SysKB;
import com.metaring.framework.functionality.FunctionalityController;
import com.metaring.framework.type.DataRepresentation;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

final class FunctionalityControllerManager {
    private static final String CFG_FUNCTIONALITY = "functionality";
    private static final String CFG_CONTROLLER = "controller";
    static final Executor INSTANCE;

    FunctionalityControllerManager() {
    }

    static {
        SysKB sysKB = Core.SYSKB;
        if (sysKB == null) {
            INSTANCE = ForkJoinPool.commonPool();
        } else if (!sysKB.hasProperty(CFG_FUNCTIONALITY).booleanValue()) {
            INSTANCE = ForkJoinPool.commonPool();
        } else {
            DataRepresentation functionalityDataRepresentation = sysKB.get(CFG_FUNCTIONALITY);
            if (!functionalityDataRepresentation.hasProperty(CFG_CONTROLLER).booleanValue()) {
                INSTANCE = ForkJoinPool.commonPool();
            } else {
                String className = functionalityDataRepresentation.getText(CFG_CONTROLLER);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("An error occurred while creating Functionality Controller class " + className, e);
                }
                try {
                    INSTANCE = ((FunctionalityController)clazz.newInstance()).init(sysKB);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                    throw new IllegalArgumentException("An error occurred while trying to access to Functionality Controller init " + className, e);
                }
            }
        }
    }
}

