/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.metaring.framework.CoreType;
import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.type.Email;
import com.metaring.framework.type.factory.DataRepresentationFactory;
import com.metaring.framework.type.factory.DigitSeriesFactory;
import com.metaring.framework.type.factory.EmailFactory;
import com.metaring.framework.type.factory.EmailSeriesFactory;
import com.metaring.framework.type.factory.RealDigitSeriesFactory;
import com.metaring.framework.type.factory.TextSeriesFactory;
import com.metaring.framework.type.factory.TruthSeriesFactory;
import com.metaring.framework.type.series.DigitSeries;
import com.metaring.framework.type.series.EmailSeries;
import com.metaring.framework.type.series.RealDigitSeries;
import com.metaring.framework.type.series.TextSeries;
import com.metaring.framework.type.series.TruthSeries;
import com.metaring.framework.util.log.LogMessageType;
import com.metaring.framework.util.log.LogMessageTypeProvider;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

class DataRepresentationImpl
implements DataRepresentation,
DataRepresentationFactory {
    private static final Gson GSON = new GsonBuilder().create();
    private JsonElement instance;
    protected final TextSeriesFactory textSeriesFactory;
    protected final DigitSeriesFactory digitSeriesFactory;
    protected final RealDigitSeriesFactory realDigitSeriesFactory;
    protected final TruthSeriesFactory truthSeriesFactory;
    protected final EmailFactory emailFactory;
    protected final EmailSeriesFactory emailSeriesFactory;
    protected final LogMessageTypeProvider logMessageTypeProvider;

    DataRepresentationImpl(String filenameOrContent, TextSeriesFactory textSeriesFactory, DigitSeriesFactory digitSeriesFactory, RealDigitSeriesFactory realDigitSeriesFactory, TruthSeriesFactory truthSeriesFactory, EmailFactory emailFactory, EmailSeriesFactory emailSeriesFactory, LogMessageTypeProvider logMessageTypeProvider) {
        this.textSeriesFactory = textSeriesFactory;
        this.digitSeriesFactory = digitSeriesFactory;
        this.realDigitSeriesFactory = realDigitSeriesFactory;
        this.truthSeriesFactory = truthSeriesFactory;
        this.emailFactory = emailFactory;
        this.emailSeriesFactory = emailSeriesFactory;
        this.logMessageTypeProvider = logMessageTypeProvider;
        this.instance = this.reinit(filenameOrContent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final JsonElement reinit(String filenameOrContent) {
        if (filenameOrContent == null) return JsonNull.INSTANCE;
        if (filenameOrContent.trim().isEmpty()) {
            return JsonNull.INSTANCE;
        }
        try (FileReader reader = new FileReader(filenameOrContent);){
            JsonElement throwable3 = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            return throwable3;
        }
        catch (Exception e1) {
            try (InputStreamReader reader2 = new InputStreamReader(this.getClass().getResourceAsStream(filenameOrContent));){
                JsonElement throwable11 = (JsonElement)GSON.fromJson((Reader)reader2, JsonElement.class);
                return throwable11;
            }
            catch (Exception e2) {
                try (InputStreamReader reader3 = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(filenameOrContent));){
                    JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)reader3, JsonElement.class);
                    return jsonElement;
                }
                catch (Exception e3) {
                    try (InputStreamReader reader4 = new InputStreamReader(new URL(filenameOrContent).openStream());){
                        JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)reader4, JsonElement.class);
                        return jsonElement;
                    }
                    catch (Exception e4) {
                        try {
                            return (JsonElement)GSON.fromJson(filenameOrContent, JsonElement.class);
                        }
                        catch (Exception e5) {
                            try {
                                return (JsonElement)GSON.fromJson("\"" + filenameOrContent + "\"", JsonElement.class);
                            }
                            catch (Exception e6) {
                                return JsonNull.INSTANCE;
                            }
                        }
                    }
                }
            }
        }
    }

    public DataRepresentation merge(DataRepresentation extension) {
        if (extension == null || extension.isNull().booleanValue()) {
            return this;
        }
        TextSeries listOriginal = this.textSeriesFactory.create(new String[0]);
        if (!this.isNull().booleanValue() && this.hasProperties().booleanValue()) {
            listOriginal.addAll((Collection)this.getProperties());
        }
        if (!extension.isNull().booleanValue() && extension.hasProperties().booleanValue()) {
            listOriginal.addAll((Collection)extension.getProperties());
        }
        List properties = listOriginal.asEnumerable().distinct().toList();
        Collections.sort(properties);
        for (String property : properties) {
            if (!this.hasProperty(property).booleanValue()) {
                this.add(property, extension.get(property));
                continue;
            }
            if (!extension.hasProperty(property).booleanValue()) continue;
            this.add(property, this.hasProperties(property) != false && extension.hasProperties(property) != false ? this.get(property).merge(extension.get(property)) : extension.get(property));
        }
        return this;
    }

    public DataRepresentation merge(DataRepresentation extension2, DataRepresentation ... extensions) {
        this.merge(extension2);
        for (int i = 0; i < extensions.length; ++i) {
            this.merge(extensions[i]);
        }
        return this;
    }

    public final String toJson() {
        return this.instance == null ? "null" : this.instance.toString();
    }

    public final Boolean hasProperty(String property) {
        try {
            return this.instance.getAsJsonObject().entrySet().stream().anyMatch(it -> ((String)it.getKey()).equals(property));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final Boolean isNull(String property) {
        try {
            return this.instance.getAsJsonObject().get(property).isJsonNull();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public final Boolean isNull() {
        try {
            return this.instance.isJsonNull();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public DataRepresentation add(String property, Iterable<?> values) {
        if (values == null || !values.iterator().hasNext()) {
            this.getOrCreateJsonObject().add(property, (JsonElement)(values == null ? JsonNull.INSTANCE : new JsonArray()));
            return this;
        }
        Object o = values.iterator().next();
        if (o instanceof String) {
            return this.add(property, this.textSeriesFactory.create(values));
        }
        if (o instanceof Long) {
            return this.add(property, this.digitSeriesFactory.create(values));
        }
        if (o instanceof Double) {
            return this.add(property, this.realDigitSeriesFactory.create(values));
        }
        if (o instanceof Boolean) {
            return this.add(property, this.truthSeriesFactory.create(values));
        }
        if (o instanceof Email) {
            return this.add(property, this.emailSeriesFactory.create(values));
        }
        if (o instanceof CoreType) {
            JsonArray jsonArray = new JsonArray();
            Iterable<?> types = values;
            types.forEach(it -> jsonArray.add(this.toJsonElement(it)));
            this.getOrCreateJsonObject().add(property, (JsonElement)jsonArray);
            return this;
        }
        throw new IllegalArgumentException("values type is not recognized (" + o.getClass().getName() + ")");
    }

    public DataRepresentation add(Iterable<?> values) {
        if (values == null || !values.iterator().hasNext()) {
            this.getOrCreateJsonArray().add((JsonElement)(values == null ? JsonNull.INSTANCE : new JsonArray()));
            return this;
        }
        Object o = values.iterator().next();
        if (o instanceof String) {
            return this.add(this.textSeriesFactory.create(values));
        }
        if (o instanceof Long) {
            return this.add(this.digitSeriesFactory.create(values));
        }
        if (o instanceof Double) {
            return this.add(this.realDigitSeriesFactory.create(values));
        }
        if (o instanceof Boolean) {
            return this.add(this.truthSeriesFactory.create(values));
        }
        if (o instanceof Email) {
            return this.add(this.emailSeriesFactory.create(values));
        }
        if (o instanceof CoreType) {
            JsonArray jsonArray = new JsonArray();
            Iterable<?> types = values;
            types.forEach(it -> jsonArray.add(this.toJsonElement(it)));
            this.getOrCreateJsonArray().add((JsonElement)jsonArray);
            return this;
        }
        throw new IllegalArgumentException("values type is not recognized (" + o.getClass().getName() + ")");
    }

    public DataRepresentation remove(String property, String ... properties) {
        try {
            JsonObject jsonObject = this.instance.getAsJsonObject();
            jsonObject.remove(property);
            for (String p : properties) {
                jsonObject.remove(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(String property, LogMessageType value) {
        try {
            this.getOrCreateJsonObject().add(property, (JsonElement)(value == null ? JsonNull.INSTANCE : new JsonPrimitive(value.getName())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isLogMessageType(String property) {
        return this.getLogMessageType(property) != null;
    }

    public final LogMessageType getLogMessageType(String property) {
        try {
            return this.logMessageTypeProvider.getByName(this.instance.getAsJsonObject().get(property).getAsString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final LogMessageType getLogMessageType() {
        try {
            return this.logMessageTypeProvider.getByName(this.instance.getAsString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Boolean isLogMessageType() {
        return this.getLogMessageType() != null;
    }

    public DataRepresentation add(String property, String value) {
        try {
            this.getOrCreateJsonObject().add(property, (JsonElement)(value == null ? JsonNull.INSTANCE : new JsonPrimitive(value)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(String property, String ... values) {
        try {
            return this.add(property, this.textSeriesFactory.create(values));
        }
        catch (Exception exception) {
            return this;
        }
    }

    public DataRepresentation add(String property, TextSeries value) {
        try {
            this.getOrCreateJsonObject().add(property, this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isText(String property) {
        return this.get(property).isText();
    }

    public final Boolean isTextSeries(String property) {
        return this.getTextSeries(property) != null;
    }

    public final Boolean isText() {
        return this.isSimple() != false && this.isNull() == false && this.isDigit() == false && this.isRealDigit() == false && this.isTruth() == false;
    }

    public final Boolean isTextSeries() {
        return this.asTextSeries() != null;
    }

    public final String asText() {
        try {
            return DataRepresentationImpl.getCleanString(this.instance);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final TextSeries asTextSeries() {
        try {
            return this.textSeriesFactory.fromJson(this.instance.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final String getText(String property) {
        try {
            return DataRepresentationImpl.getCleanString(this.instance.getAsJsonObject().get(property));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final TextSeries getTextSeries(String property) {
        try {
            return this.textSeriesFactory.fromJson(this.instance.getAsJsonObject().get(property).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(String property, Long value) {
        try {
            this.getOrCreateJsonObject().add(property, (JsonElement)(value == null ? JsonNull.INSTANCE : new JsonPrimitive((Number)value)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(String property, Long ... values) {
        try {
            return this.add(property, this.digitSeriesFactory.create(values));
        }
        catch (Exception exception) {
            return this;
        }
    }

    public DataRepresentation add(String property, DigitSeries value) {
        try {
            this.getOrCreateJsonObject().add(property, this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isDigit(String property) {
        return this.getDigit(property) != null;
    }

    public final Boolean isDigitSeries(String property) {
        return this.getDigitSeries(property) != null;
    }

    public final Boolean isDigit() {
        return this.asDigit() != null;
    }

    public final Boolean isDigitSeries() {
        return this.asDigit() != null;
    }

    public final Long asDigit() {
        try {
            return this.instance.getAsLong();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final DigitSeries asDigitSeries() {
        try {
            return this.digitSeriesFactory.fromJson(this.instance.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Long getDigit(String property) {
        try {
            return this.instance.getAsJsonObject().get(property).getAsLong();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final DigitSeries getDigitSeries(String property) {
        try {
            return this.digitSeriesFactory.fromJson(this.instance.getAsJsonObject().get(property).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(String property, Double value) {
        try {
            this.getOrCreateJsonObject().add(property, (JsonElement)(value == null ? JsonNull.INSTANCE : new JsonPrimitive((Number)value)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(String property, Double ... values) {
        try {
            return this.add(property, this.realDigitSeriesFactory.create(values));
        }
        catch (Exception exception) {
            return this;
        }
    }

    public DataRepresentation add(String property, RealDigitSeries value) {
        try {
            this.getOrCreateJsonObject().add(property, this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isRealDigit(String property) {
        return this.getRealDigit(property) != null;
    }

    public final Boolean isRealDigitSeries(String property) {
        return this.getRealDigitSeries(property) != null;
    }

    public final Boolean isRealDigit() {
        return this.asRealDigit() != null;
    }

    public final Boolean isRealDigitSeries() {
        return this.asRealDigitSeries() != null;
    }

    public final Double asRealDigit() {
        try {
            return this.instance.getAsDouble();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final RealDigitSeries asRealDigitSeries() {
        try {
            return this.realDigitSeriesFactory.fromJson(this.instance.getAsString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Double getRealDigit(String property) {
        try {
            return this.instance.getAsJsonObject().get(property).getAsDouble();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final RealDigitSeries getRealDigitSeries(String property) {
        try {
            return this.realDigitSeriesFactory.fromJson(this.instance.getAsJsonObject().get(property).getAsString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(String property, Boolean value) {
        try {
            this.getOrCreateJsonObject().add(property, (JsonElement)(value == null ? JsonNull.INSTANCE : new JsonPrimitive(value)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(String property, Boolean ... values) {
        try {
            return this.add(property, this.truthSeriesFactory.create(values));
        }
        catch (Exception exception) {
            return this;
        }
    }

    public DataRepresentation add(String property, TruthSeries value) {
        try {
            this.getOrCreateJsonObject().add(property, this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isTruth(String property) {
        return this.getTruth(property) != null;
    }

    public final Boolean isTruthSeries(String property) {
        return this.getTruthSeries(property) != null;
    }

    public final Boolean isTruth() {
        return this.asTruth() != null;
    }

    public final Boolean isTruthSeries() {
        return this.asTruthSeries() != null;
    }

    private final Boolean booleanize(JsonElement element) {
        try {
            String elementToString = element.toString();
            if (elementToString.equals("true") || elementToString.equals("false")) {
                return Boolean.parseBoolean(elementToString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final Boolean asTruth() {
        try {
            return this.booleanize(this.instance);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final TruthSeries asTruthSeries() {
        try {
            return this.truthSeriesFactory.fromJson(this.instance.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Boolean getTruth(String property) {
        try {
            return this.booleanize(this.instance.getAsJsonObject().get(property));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final TruthSeries getTruthSeries(String property) {
        try {
            return this.truthSeriesFactory.fromJson(this.instance.getAsJsonObject().get(property).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(String property, Email value) {
        try {
            this.getOrCreateJsonObject().add(property, this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(String property, Email ... values) {
        try {
            return this.add(property, this.emailSeriesFactory.create(values));
        }
        catch (Exception exception) {
            return this;
        }
    }

    public DataRepresentation add(String property, EmailSeries value) {
        try {
            this.getOrCreateJsonObject().add(property, this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isEmail(String property) {
        return this.getEmail(property) != null;
    }

    public final Boolean isEmailSeries(String property) {
        return this.getEmailSeries(property) != null;
    }

    public final Boolean isEmail() {
        return this.asEmail() != null;
    }

    public final Boolean isEmailSeries() {
        return this.asEmailSeries() != null;
    }

    public final Email asEmail() {
        try {
            return this.emailFactory.fromJson(this.instance.getAsString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final EmailSeries asEmailSeries() {
        try {
            return this.emailSeriesFactory.fromJson(this.instance.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Email getEmail(String property) {
        try {
            return this.emailFactory.fromJson(this.instance.getAsJsonObject().get(property).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final EmailSeries getEmailSeries(String property) {
        try {
            return this.emailSeriesFactory.fromJson(this.instance.getAsJsonObject().get(property).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(String property, DataRepresentation value) {
        try {
            this.getOrCreateJsonObject().add(property, this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(String property, DataRepresentation ... values) {
        try {
            if (values == null) {
                this.getOrCreateJsonObject().add(property, (JsonElement)JsonNull.INSTANCE);
                return this;
            }
            JsonArray jsonArray = new JsonArray();
            Stream.of(values).forEach(it -> jsonArray.add(this.toJsonElement(it)));
            return this.add(property, (Iterable<?>)jsonArray);
        }
        catch (Exception exception) {
            return this;
        }
    }

    public final Boolean hasProperties(String property) {
        try {
            return this.get(property).hasProperties();
        }
        catch (Exception e) {
            return false;
        }
    }

    public final Boolean hasProperties(int position) {
        try {
            return this.get(position).hasProperties();
        }
        catch (Exception e) {
            return false;
        }
    }

    public final Boolean hasProperties() {
        return this.instance.isJsonObject();
    }

    public DataRepresentation get(String property) {
        try {
            return this.fromJson(this.instance.getAsJsonObject().get(property).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(String property, CoreType value) {
        try {
            this.getOrCreateJsonObject().add(property, this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(String property, CoreType ... values) {
        if (values == null || values.length == 0) {
            this.getOrCreateJsonObject().add(property, (JsonElement)(values == null ? JsonNull.INSTANCE : new JsonArray()));
            return this;
        }
        try {
            JsonArray jsonArray = new JsonArray();
            for (CoreType value : values) {
                jsonArray.add(this.toJsonElement(value));
            }
            this.getOrCreateJsonObject().add(property, (JsonElement)jsonArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final <T extends GeneratedCoreType> T as(Class<T> generatedCoreTypeClass) {
        try {
            return this.get(this.instance, generatedCoreTypeClass);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final <T extends GeneratedCoreType> T get(String property, Class<T> generatedCoreTypeClass) {
        try {
            return this.get(this.instance.getAsJsonObject().get(property), generatedCoreTypeClass);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final <T extends GeneratedCoreType> T get(JsonElement jsonElement, Class<T> generatedCoreTypeClass) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        try {
            Method method = generatedCoreTypeClass.getDeclaredMethod("fromJson", String.class);
            method.setAccessible(true);
            return (T)((GeneratedCoreType)method.invoke(null, DataRepresentationImpl.getCleanString(jsonElement)));
        }
        catch (Exception e) {
            try {
                Method method = generatedCoreTypeClass.getMethod("fromJson", String.class);
                method.setAccessible(true);
                return (T)((GeneratedCoreType)method.invoke(null, DataRepresentationImpl.getCleanString(jsonElement)));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public final Boolean hasLength() {
        try {
            return this.instance.isJsonArray();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final Integer length() {
        try {
            return this.instance.getAsJsonArray().size();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Boolean isEmpty() {
        return this.hasLength() != false && this.length() == 0;
    }

    public final Boolean isEmpty(String property) {
        return this.hasLength(property) != false && this.getLength(property) == 0;
    }

    public final Boolean isEmpty(int position) {
        return this.hasLength(position) != false && this.getLength(position) == 0;
    }

    public DataRepresentation remove(int position, int ... otherPositions) {
        try {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            positions.add(position);
            if (otherPositions != null && otherPositions.length > 0) {
                for (int pos : otherPositions) {
                    positions.add(pos);
                }
            }
            Collections.sort(positions);
            Collections.reverse(positions);
            JsonArray jsonArray = this.instance.getAsJsonArray();
            Iterator iterator = positions.iterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                jsonArray.remove(pos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isText(int position) {
        return this.get(position).isText();
    }

    public final Boolean isTextSeries(int position) {
        return this.getTextSeries(position) != null;
    }

    public final String getText(int position) {
        try {
            return DataRepresentationImpl.getCleanString(this.instance.getAsJsonArray().get(position));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final TextSeries getTextSeries(int position) {
        try {
            return this.textSeriesFactory.fromJson(this.instance.getAsJsonArray().get(position).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(String value) {
        try {
            this.getOrCreateJsonArray().add(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(String ... values) {
        try {
            for (String value : values) {
                this.getOrCreateJsonArray().add(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(TextSeries values) {
        try {
            for (String value : values) {
                this.getOrCreateJsonArray().add(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isDigit(int position) {
        return this.getDigit(position) != null;
    }

    public final Boolean isDigitSeries(int position) {
        return this.getDigitSeries(position) != null;
    }

    public final Long getDigit(int position) {
        try {
            return this.instance.getAsJsonArray().get(position).getAsLong();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final DigitSeries getDigitSeries(int position) {
        try {
            return this.digitSeriesFactory.fromJson(this.instance.getAsJsonArray().get(position).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(Long value) {
        try {
            this.getOrCreateJsonArray().add((Number)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(Long ... values) {
        try {
            for (Long value : values) {
                this.getOrCreateJsonArray().add((Number)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(DigitSeries values) {
        try {
            for (Long value : values) {
                this.getOrCreateJsonArray().add((Number)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isRealDigit(int position) {
        return this.getRealDigit(position) != null;
    }

    public final Boolean isRealDigitSeries(int position) {
        return this.getRealDigitSeries(position) != null;
    }

    public final Double getRealDigit(int position) {
        try {
            return this.instance.getAsJsonArray().get(position).getAsDouble();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final RealDigitSeries getRealDigitSeries(int position) {
        try {
            return this.realDigitSeriesFactory.fromJson(this.instance.getAsJsonArray().get(position).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(Double value) {
        try {
            this.getOrCreateJsonArray().add((Number)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(Double ... values) {
        try {
            for (Double value : values) {
                this.getOrCreateJsonArray().add((Number)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(RealDigitSeries values) {
        try {
            for (Double value : values) {
                this.getOrCreateJsonArray().add((Number)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isTruth(int position) {
        return this.getTruth(position) != null;
    }

    public final Boolean isTruthSeries(int position) {
        return this.getTruthSeries(position) != null;
    }

    public final Boolean getTruth(int position) {
        try {
            return this.booleanize(this.instance.getAsJsonArray().get(position));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final TruthSeries getTruthSeries(int position) {
        try {
            return this.truthSeriesFactory.fromJson(this.instance.getAsJsonArray().get(position).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(Boolean value) {
        try {
            this.getOrCreateJsonArray().add(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(Boolean ... values) {
        try {
            for (Boolean value : values) {
                this.getOrCreateJsonArray().add(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(TruthSeries values) {
        try {
            for (Boolean value : values) {
                this.getOrCreateJsonArray().add(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public final Boolean isEmail(int position) {
        return this.getEmail(position) != null;
    }

    public final Boolean isEmailSeries(int position) {
        return this.getEmailSeries(position) != null;
    }

    public final Email getEmail(int position) {
        try {
            return this.emailFactory.create(this.instance.getAsJsonArray().get(position).getAsString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final EmailSeries getEmailSeries(int position) {
        try {
            return this.emailSeriesFactory.fromJson(this.instance.getAsJsonArray().get(position).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(Email value) {
        try {
            this.getOrCreateJsonArray().add(this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(Email ... values) {
        try {
            for (Email value : values) {
                this.getOrCreateJsonArray().add(this.toJsonElement(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(EmailSeries values) {
        try {
            for (Email value : values) {
                this.getOrCreateJsonArray().add(this.toJsonElement(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation get(int position) {
        try {
            return this.fromJson(this.instance.getAsJsonArray().get(position).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataRepresentation add(DataRepresentation value) {
        try {
            this.getOrCreateJsonArray().add(this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(DataRepresentation ... values) {
        try {
            for (DataRepresentation value : values) {
                this.getOrCreateJsonArray().add(this.toJsonElement(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(CoreType value) {
        try {
            this.getOrCreateJsonArray().add(this.toJsonElement(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public DataRepresentation add(CoreType ... values) {
        try {
            for (CoreType value : values) {
                this.getOrCreateJsonArray().add(this.toJsonElement(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private final DataRepresentation createWork(String json) {
        return new DataRepresentationImpl(json, this.textSeriesFactory, this.digitSeriesFactory, this.realDigitSeriesFactory, this.truthSeriesFactory, this.emailFactory, this.emailSeriesFactory, this.logMessageTypeProvider);
    }

    public final DataRepresentation create() {
        return this.createWork(null);
    }

    public final DataRepresentation fromJson(String json) {
        return this.createWork(json);
    }

    public final DataRepresentation fromObject(Object object) {
        if (object == null) {
            return null;
        }
        return this.fromJson(object instanceof CoreType ? ((CoreType)object).toJson() : GSON.toJson(object));
    }

    static final Stream<String> getStrings(String json) {
        if (json == null || json.trim().isEmpty() || json.replace(" ", "").toLowerCase().equals("null")) {
            return null;
        }
        JsonArray jsonArray = ((JsonElement)GSON.fromJson(json, JsonElement.class)).getAsJsonArray();
        ArrayList<String> strings = new ArrayList<String>();
        for (JsonElement jsonElement : jsonArray) {
            strings.add(DataRepresentationImpl.getCleanString(jsonElement));
        }
        return strings.parallelStream();
    }

    public final TextSeries getProperties() {
        try {
            return this.textSeriesFactory.create((String[])this.instance.getAsJsonObject().entrySet().parallelStream().map(it -> (String)it.getKey()).toArray(String[]::new));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final <T extends GeneratedCoreType> T get(int position, Class<T> generatedCoreTypeClass) {
        try {
            return this.get(this.instance.getAsJsonArray().get(position), generatedCoreTypeClass);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final String toString() {
        return this.toJson();
    }

    private static final String getCleanString(JsonElement jsonElement) {
        return jsonElement.isJsonPrimitive() ? jsonElement.getAsString() : jsonElement.toString();
    }

    public final Boolean is(Class<? extends GeneratedCoreType> generatedCoreTypeClass) {
        return this.as(generatedCoreTypeClass) != null;
    }

    public final Boolean is(String property, Class<? extends GeneratedCoreType> generatedCoreTypeClass) {
        return this.get(property, generatedCoreTypeClass) != null;
    }

    public final Boolean is(int position, Class<? extends GeneratedCoreType> generatedCoreTypeClass) {
        return this.get(position, generatedCoreTypeClass) != null;
    }

    public final Boolean isNull(int position) {
        JsonElement element = null;
        try {
            element = this.instance.getAsJsonArray().get(position);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element == null || element.isJsonNull();
    }

    public final Boolean isSimple() {
        JsonPrimitive element = null;
        try {
            element = this.instance.getAsJsonPrimitive();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element != null && element.isJsonPrimitive();
    }

    public final Boolean isSimple(String property) {
        JsonElement element = null;
        try {
            element = this.instance.getAsJsonObject().get(property);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element != null && element.isJsonPrimitive();
    }

    public final Boolean isSimple(int position) {
        JsonElement element = null;
        try {
            element = this.instance.getAsJsonArray().get(position);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element != null && element.isJsonPrimitive();
    }

    public final Boolean hasLength(String property) {
        JsonElement element = null;
        try {
            element = this.instance.getAsJsonObject().get(property);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element != null && element.isJsonArray();
    }

    public final Boolean hasLength(int position) {
        JsonElement element = null;
        try {
            element = this.instance.getAsJsonArray().get(position);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element != null && element.isJsonArray();
    }

    public final Integer getLength(String property) {
        try {
            return this.instance.getAsJsonObject().get(property).getAsJsonArray().size();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Integer getLength(int position) {
        try {
            return this.instance.getAsJsonArray().get(position).getAsJsonArray().size();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final DataRepresentation first() {
        return this.get(0);
    }

    public final String firstAsText() {
        return this.get(0).asText();
    }

    public final TextSeries firstAsTextSeries() {
        return this.get(0).asTextSeries();
    }

    public final Long firstAsDigit() {
        return this.get(0).asDigit();
    }

    public final DigitSeries firstAsDigitSeries() {
        return this.get(0).asDigitSeries();
    }

    public final Double firstAsRealDigit() {
        return this.get(0).asRealDigit();
    }

    public final RealDigitSeries firstAsRealDigitSeries() {
        return this.get(0).asRealDigitSeries();
    }

    public final Boolean firstAsTruth() {
        return this.get(0).asTruth();
    }

    public final TruthSeries firstAsTruthSeries() {
        return this.get(0).asTruthSeries();
    }

    public final Email firstAsEmail() {
        return this.get(0).asEmail();
    }

    public final EmailSeries firstAsEmailSeries() {
        return this.get(0).asEmailSeries();
    }

    public final <T extends GeneratedCoreType> T firstAs(Class<T> generatedCoreTypeClass) {
        return (T)this.get(0).as(generatedCoreTypeClass);
    }

    public final TextSeries getProperties(int position) {
        try {
            return this.textSeriesFactory.create((String[])this.instance.getAsJsonArray().get(position).getAsJsonObject().entrySet().parallelStream().map(it -> (String)it.getKey()).toArray(String[]::new));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final TextSeries getProperties(String property) {
        try {
            return this.textSeriesFactory.create((String[])this.instance.getAsJsonObject().get(property).getAsJsonObject().entrySet().parallelStream().map(it -> (String)it.getKey()).toArray(String[]::new));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Iterator<DataRepresentation> iterator() {
        return this.hasProperties() != false ? new ObjectIterator(this.getProperties()) : new ArrayIterator(this.isNull() != false ? 0 : this.length());
    }

    private final JsonObject getOrCreateJsonObject() {
        return this.getOrCreateJsonObjectOrJsonArray(true).getAsJsonObject();
    }

    private final JsonArray getOrCreateJsonArray() {
        return this.getOrCreateJsonObjectOrJsonArray(false).getAsJsonArray();
    }

    private final JsonElement getOrCreateJsonObjectOrJsonArray(boolean object) {
        if (this.instance == null || this.instance instanceof JsonNull) {
            try {
                this.instance = object ? new JsonObject() : new JsonArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.instance;
    }

    private final JsonElement toJsonElement(Object object) {
        return object == null ? JsonNull.INSTANCE : (JsonElement)GSON.fromJson(object instanceof CoreType ? ((CoreType)object).toJson() : GSON.toJson(object), JsonElement.class);
    }

    public DataRepresentation set(int position, Iterable<?> values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, String value) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(value));
        return this;
    }

    public DataRepresentation set(int position, String ... values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, TextSeries values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, Long value) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(value));
        return this;
    }

    public DataRepresentation set(int position, Long ... values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, DigitSeries values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, Double value) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(value));
        return this;
    }

    public DataRepresentation set(int position, Double ... values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, RealDigitSeries values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, Boolean value) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(value));
        return this;
    }

    public DataRepresentation set(int position, Boolean ... values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, TruthSeries values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, Email value) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(value));
        return this;
    }

    public DataRepresentation set(int position, Email ... values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, EmailSeries values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, DataRepresentation value) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(value));
        return this;
    }

    public DataRepresentation set(int position, DataRepresentation ... values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    public DataRepresentation set(int position, CoreType value) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(value));
        return this;
    }

    public DataRepresentation set(int position, CoreType ... values) {
        this.getOrCreateJsonArray().set(position, this.toJsonElement(values));
        return this;
    }

    class ObjectIterator
    implements Iterator<DataRepresentation> {
        private TextSeries properties;
        private int position = 0;

        ObjectIterator(TextSeries properties) {
            this.properties = properties;
        }

        @Override
        public DataRepresentation next() {
            return DataRepresentationImpl.this.get((String)this.properties.get(this.position++));
        }

        @Override
        public boolean hasNext() {
            return this.position < this.properties.size();
        }
    }

    class ArrayIterator
    implements Iterator<DataRepresentation> {
        private int length;
        private int position = 0;

        ArrayIterator(int length) {
            this.length = length;
        }

        @Override
        public DataRepresentation next() {
            return DataRepresentationImpl.this.get(this.position++);
        }

        @Override
        public boolean hasNext() {
            return this.position < this.length;
        }
    }
}

