/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework;

import com.metaring.framework.RealDigitSeriesImpl;
import com.metaring.framework.type.factory.RealDigitSeriesFactory;
import com.metaring.framework.type.series.RealDigitSeries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;

final class RealDigitSeriesFactoryImpl
implements RealDigitSeriesFactory {
    private final Function<String, Stream<String>> fromJsonToStringsFunction;

    RealDigitSeriesFactoryImpl(Function<String, Stream<String>> fromJsonToStringsFunction) {
        this.fromJsonToStringsFunction = fromJsonToStringsFunction;
    }

    public RealDigitSeries create(Iterable<Double> iterable) {
        return new RealDigitSeriesImpl(iterable);
    }

    public RealDigitSeries create(Double ... digits) {
        return this.create(digits == null ? new ArrayList() : Arrays.asList(digits));
    }

    public RealDigitSeries fromJson(String json) {
        Stream<String> strings = this.fromJsonToStringsFunction.apply(json);
        return strings == null ? null : this.create((Double[])strings.map(Double::new).toArray(Double[]::new));
    }
}

