/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework;

import com.metaring.framework.ExecutionEnvironment;
import com.metaring.framework.ExecutionEnvironmentProvider;
import com.metaring.framework.ImmutableDataRepresentation;
import com.metaring.framework.SysKB;
import com.metaring.framework.SysKBFactory;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.type.factory.DigitSeriesFactory;
import com.metaring.framework.type.factory.EmailFactory;
import com.metaring.framework.type.factory.EmailSeriesFactory;
import com.metaring.framework.type.factory.RealDigitSeriesFactory;
import com.metaring.framework.type.factory.TextSeriesFactory;
import com.metaring.framework.type.factory.TruthSeriesFactory;
import com.metaring.framework.util.log.LogMessageType;
import com.metaring.framework.util.log.LogMessageTypeProvider;
import com.metaring.framework.util.log.Logger;
import com.metaring.framework.util.log.LoggerFactory;

final class SysKBImpl
extends ImmutableDataRepresentation
implements SysKB,
SysKBFactory {
    private String filenameOrContent;
    private final ExecutionEnvironmentProvider executionEnvironmentProvider;
    private final LoggerFactory loggerFactory;
    private String systemName;
    private LogMessageType systemLoggerMessageType;
    private Logger systemLogger;
    private Boolean systemTestMode;
    private String systemDataRepresentationPropertyName;
    private String systemNamePropertyName;
    private String systemExecutionEnvironmentPropertyName;
    private String systemLoggerLevelPropertyName;
    private String systemTestModePropertyName;
    private ExecutionEnvironment executionEnvironment;

    private SysKBImpl(String filenameOrContent, TextSeriesFactory textSeriesFactory, DigitSeriesFactory digitSeriesFactory, RealDigitSeriesFactory realDigitSeriesFactory, TruthSeriesFactory truthSeriesFactory, EmailFactory emailFactory, EmailSeriesFactory emailSeriesFactory, LogMessageTypeProvider logMessageTypeProvider, ExecutionEnvironmentProvider executionEnvironmentProvider, LoggerFactory loggerFactory, String systemDataRepresentationPropertyName, String systemNamePropertyName, String systemExecutionEnvironmentPropertyName, String systemLoggerLevelPropertyName, String systemTestModePropertyName) {
        super(filenameOrContent, textSeriesFactory, digitSeriesFactory, realDigitSeriesFactory, truthSeriesFactory, emailFactory, emailSeriesFactory, logMessageTypeProvider);
        this.filenameOrContent = filenameOrContent;
        this.executionEnvironmentProvider = executionEnvironmentProvider;
        this.loggerFactory = loggerFactory;
        this.systemDataRepresentationPropertyName = systemDataRepresentationPropertyName;
        this.systemNamePropertyName = systemNamePropertyName;
        this.systemExecutionEnvironmentPropertyName = systemExecutionEnvironmentPropertyName;
        this.systemLoggerLevelPropertyName = systemLoggerLevelPropertyName;
        this.systemTestModePropertyName = systemTestModePropertyName;
        this.initProperties();
    }

    SysKBImpl(TextSeriesFactory textSeriesFactory, DigitSeriesFactory digitSeriesFactory, RealDigitSeriesFactory realDigitSeriesFactory, TruthSeriesFactory truthSeriesFactory, EmailFactory emailFactory, EmailSeriesFactory emailSeriesFactory, LogMessageTypeProvider logMessageTypeProvider, ExecutionEnvironmentProvider executionEnvironmentProvider, LoggerFactory loggerFactory, String systemDataRepresentationPropertyName, String systemNamePropertyName, String systemExecutionEnvironmentPropertyName, String systemLoggerLevelPropertyName, String systemTestModePropertyName) {
        this(null, textSeriesFactory, digitSeriesFactory, realDigitSeriesFactory, truthSeriesFactory, emailFactory, emailSeriesFactory, logMessageTypeProvider, executionEnvironmentProvider, loggerFactory, systemDataRepresentationPropertyName, systemNamePropertyName, systemExecutionEnvironmentPropertyName, systemLoggerLevelPropertyName, systemTestModePropertyName);
    }

    public ExecutionEnvironment getSystemExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void reinit() {
        this.reinit(this.filenameOrContent);
        this.initProperties();
    }

    private void initProperties() {
        this.executionEnvironment = null;
        this.systemName = null;
        this.systemLoggerMessageType = null;
        this.systemLogger = null;
        if (!this.hasProperty(this.systemDataRepresentationPropertyName).booleanValue()) {
            return;
        }
        DataRepresentation systemDataRepresentation = this.get(this.systemDataRepresentationPropertyName);
        this.executionEnvironment = this.executionEnvironmentProvider.getByName(systemDataRepresentation.getText(this.systemExecutionEnvironmentPropertyName));
        this.systemName = systemDataRepresentation.getText(this.systemNamePropertyName);
        this.systemLoggerMessageType = systemDataRepresentation.getLogMessageType(this.systemLoggerLevelPropertyName);
        this.systemTestMode = systemDataRepresentation.getTruth(this.systemTestModePropertyName);
        this.systemTestMode = this.systemTestMode != null && this.systemTestMode != false;
    }

    public SysKB load(String filenameOrContent) {
        if (filenameOrContent == null && Thread.currentThread().getStackTrace()[2].getClassName().equals(this.getClass().getPackage().getName() + ".Core")) {
            filenameOrContent = "";
        }
        return new SysKBImpl(filenameOrContent, this.textSeriesFactory, this.digitSeriesFactory, this.realDigitSeriesFactory, this.truthSeriesFactory, this.emailFactory, this.emailSeriesFactory, this.logMessageTypeProvider, this.executionEnvironmentProvider, this.loggerFactory, this.systemDataRepresentationPropertyName, this.systemNamePropertyName, this.systemExecutionEnvironmentPropertyName, this.systemLoggerLevelPropertyName, this.systemTestModePropertyName);
    }

    public SysKB create(String systemName, LogMessageType logMessageType, Boolean systemTestMode) {
        SysKBImpl sysKB = new SysKBImpl("", this.textSeriesFactory, this.digitSeriesFactory, this.realDigitSeriesFactory, this.truthSeriesFactory, this.emailFactory, this.emailSeriesFactory, this.logMessageTypeProvider, this.executionEnvironmentProvider, this.loggerFactory, this.systemDataRepresentationPropertyName, this.systemNamePropertyName, this.systemExecutionEnvironmentPropertyName, this.systemLoggerLevelPropertyName, this.systemTestModePropertyName);
        sysKB.systemName = systemName;
        sysKB.systemLoggerMessageType = logMessageType;
        sysKB.systemTestMode = systemTestMode;
        return sysKB;
    }

    public SysKB create(String systemName, LogMessageType logMessageType) {
        return this.create(systemName, logMessageType, false);
    }

    public SysKB create(String systemName, Boolean systemTestMode) {
        return this.create(systemName, this.logMessageTypeProvider.INFO(), systemTestMode);
    }

    public SysKB create(String systemName) {
        return this.create(systemName, this.logMessageTypeProvider.INFO(), false);
    }

    public SysKB create(DataRepresentation dataRepresentation) {
        return new SysKBImpl(dataRepresentation.toJson(), this.textSeriesFactory, this.digitSeriesFactory, this.realDigitSeriesFactory, this.truthSeriesFactory, this.emailFactory, this.emailSeriesFactory, this.logMessageTypeProvider, this.executionEnvironmentProvider, this.loggerFactory, this.systemDataRepresentationPropertyName, this.systemNamePropertyName, this.systemExecutionEnvironmentPropertyName, this.systemLoggerLevelPropertyName, this.systemTestModePropertyName);
    }

    public String getSystemName() {
        return this.systemName;
    }

    public Logger getSystemLogger() {
        if (this.systemLogger == null) {
            this.systemLogger = this.createSystemLogger();
        }
        return this.systemLogger;
    }

    public LogMessageType getSystemLoggerMessageType() {
        return this.systemLoggerMessageType;
    }

    public Boolean isSystemInTestMode() {
        return this.systemTestMode;
    }

    public Logger createSystemLogger() {
        return this.loggerFactory.create(this.getSystemName(), this.getSystemLoggerMessageType());
    }
}

