/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.localization;

import com.metaring.framework.CoreType;
import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.localization.LocaleEnumerator;
import com.metaring.framework.type.DataRepresentation;

public class LocaleInfo
implements GeneratedCoreType {
    public static final String FULLY_QUALIFIED_NAME = "com.metaring.framework.localization.localeInfo";
    private LocaleEnumerator locale;
    private String currency;

    private LocaleInfo(LocaleEnumerator locale, String currency) {
        this.locale = locale;
        this.currency = currency;
    }

    public LocaleEnumerator getLocale() {
        return this.locale;
    }

    public String getCurrency() {
        return this.currency;
    }

    public static LocaleInfo create(LocaleEnumerator locale, String currency) {
        return new LocaleInfo(locale, currency);
    }

    public static LocaleInfo fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        LocaleEnumerator locale = null;
        if (dataRepresentation.hasProperty("locale").booleanValue()) {
            try {
                locale = (LocaleEnumerator)dataRepresentation.get("locale", LocaleEnumerator.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String currency = null;
        if (dataRepresentation.hasProperty("currency").booleanValue()) {
            try {
                currency = dataRepresentation.getText("currency");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LocaleInfo localeInfo = LocaleInfo.create(locale, currency);
        return localeInfo;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.locale != null) {
            dataRepresentation.add("locale", (CoreType)this.locale);
        }
        if (this.currency != null) {
            dataRepresentation.add("currency", this.currency);
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

