/*
 * Decompiled with CFR 0.152.
 */
package com.metaring.framework.persistence;

import com.metaring.framework.GeneratedCoreType;
import com.metaring.framework.Tools;
import com.metaring.framework.type.DataRepresentation;
import com.metaring.framework.type.series.TextSeries;

public class OperationResult
implements GeneratedCoreType {
    public static final String FULLY_QUALIFIED_NAME = "com.metaring.framework.persistence.operationResult";
    private Long manipulationNumber;
    private TextSeries keys;

    private OperationResult(Long manipulationNumber, TextSeries keys) {
        this.manipulationNumber = manipulationNumber;
        this.keys = keys;
    }

    public Long getManipulationNumber() {
        return this.manipulationNumber;
    }

    public TextSeries getKeys() {
        return this.keys;
    }

    public static OperationResult create(Long manipulationNumber, TextSeries keys) {
        return new OperationResult(manipulationNumber, keys);
    }

    public static OperationResult fromJson(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if ((jsonString = jsonString.trim()).isEmpty()) {
            return null;
        }
        if (jsonString.equalsIgnoreCase("null")) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromJson(jsonString);
        Long manipulationNumber = null;
        if (dataRepresentation.hasProperty("manipulationNumber").booleanValue()) {
            try {
                manipulationNumber = dataRepresentation.getDigit("manipulationNumber");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TextSeries keys = null;
        if (dataRepresentation.hasProperty("keys").booleanValue()) {
            try {
                keys = dataRepresentation.getTextSeries("keys");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OperationResult operationResult = OperationResult.create(manipulationNumber, keys);
        return operationResult;
    }

    public static OperationResult fromObject(Object object) {
        if (object == null) {
            return null;
        }
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.fromObject(object);
        Long manipulationNumber = null;
        if (dataRepresentation.hasProperty("manipulationNumber").booleanValue()) {
            try {
                manipulationNumber = dataRepresentation.getDigit("manipulationNumber");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TextSeries keys = null;
        if (dataRepresentation.hasProperty("keys").booleanValue()) {
            try {
                keys = dataRepresentation.getTextSeries("keys");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OperationResult operationResult = OperationResult.create(manipulationNumber, keys);
        return operationResult;
    }

    public DataRepresentation toDataRepresentation() {
        DataRepresentation dataRepresentation = Tools.FACTORY_DATA_REPRESENTATION.create();
        if (this.manipulationNumber != null) {
            dataRepresentation.add("manipulationNumber", this.manipulationNumber);
        }
        if (this.keys != null) {
            dataRepresentation.add("keys", this.keys.toArray());
        }
        return dataRepresentation;
    }

    public String toJson() {
        return this.toDataRepresentation().toJson();
    }

    public String toString() {
        return this.toJson();
    }
}

