/*
 * Decompiled with CFR 0.152.
 */
package multiversx;

import java.io.IOException;
import java.math.BigInteger;
import multiversx.AccountOnNetwork;
import multiversx.Address;
import multiversx.Exceptions;
import multiversx.IProvider;

public class Account {
    private final Address address;
    private long nonce = 0L;
    private BigInteger balance = BigInteger.valueOf(0L);

    public Account(Address address) {
        this.address = address;
    }

    public void sync(IProvider provider) throws Exceptions.AddressException, IOException, Exceptions.ProxyRequestException {
        AccountOnNetwork accountOnNetwork = provider.getAccount(this.address);
        this.nonce = accountOnNetwork.getNonce();
        this.balance = accountOnNetwork.getBalance();
    }

    public Address getAddress() {
        return this.address;
    }

    public long getNonce() {
        return this.nonce;
    }

    public void incrementNonce() {
        ++this.nonce;
    }

    public BigInteger getBalance() {
        return this.balance;
    }
}

