/*
 * Decompiled with CFR 0.152.
 */
package multiversx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import multiversx.Address;
import multiversx.BigIntegerCodec;
import multiversx.Exceptions;
import multiversx.IProvider;
import multiversx.NetworkConfig;
import multiversx.Wallet;
import multiversx.proto.TransactionOuterClass;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class Transaction {
    public static final int VERSION = 1;
    private static final int TRANSACTION_HASH_LENGTH = 32;
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private long nonce;
    private BigInteger value = BigInteger.valueOf(0L);
    private Address sender = Address.createZeroAddress();
    private Address receiver = Address.createZeroAddress();
    private long gasPrice = NetworkConfig.getDefault().getMinGasPrice();
    private long gasLimit = NetworkConfig.getDefault().getMinGasLimit();
    private String data = "";
    private String chainID = NetworkConfig.getDefault().getChainID();
    private String signature = "";
    private String txHash = "";

    public String serialize() throws Exceptions.CannotSerializeTransactionException {
        try {
            Map<String, Object> map = this.toMap();
            return gson.toJson(map);
        }
        catch (Exceptions.AddressException error) {
            throw new Exceptions.CannotSerializeTransactionException();
        }
    }

    private Map<String, Object> toMap() throws Exceptions.AddressException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("nonce", this.nonce);
        map.put("value", this.value.toString(10));
        map.put("receiver", this.receiver.bech32());
        map.put("sender", this.sender.bech32());
        map.put("gasPrice", this.gasPrice);
        map.put("gasLimit", this.gasLimit);
        if (this.data.length() > 0) {
            map.put("data", this.getDataEncoded());
        }
        map.put("chainID", this.chainID);
        map.put("version", 1);
        if (this.signature.length() > 0) {
            map.put("signature", this.signature);
        }
        return map;
    }

    public void sign(Wallet wallet) throws Exceptions.CannotSignTransactionException {
        try {
            String serialized = this.serialize();
            this.signature = wallet.sign(serialized);
        }
        catch (Exceptions.CannotSerializeTransactionException error) {
            throw new Exceptions.CannotSignTransactionException();
        }
    }

    public void send(IProvider provider) throws Exceptions.CannotSerializeTransactionException, IOException, Exceptions.ProxyRequestException {
        this.txHash = provider.sendTransaction(this);
    }

    public String computeHash() {
        TransactionOuterClass.Transaction.Builder builder = TransactionOuterClass.Transaction.newBuilder().setNonce(this.getNonce()).setValue(BigIntegerCodec.serializeValue(this.getValue())).setRcvAddr(ByteString.copyFrom((byte[])this.getReceiver().pubkey())).setSndAddr(ByteString.copyFrom((byte[])this.getSender().pubkey())).setGasPrice(this.getGasPrice()).setGasLimit(this.getGasLimit()).setChainID(ByteString.copyFrom((byte[])this.getChainID().getBytes(StandardCharsets.UTF_8))).setData(ByteString.copyFrom((byte[])this.getData().getBytes(StandardCharsets.UTF_8))).setVersion(1);
        if (this.data.length() > 0) {
            builder = builder.setData(ByteString.copyFromUtf8((String)this.getData()));
        }
        if (this.signature.length() > 0) {
            builder = builder.setSignature(ByteString.copyFrom((byte[])Hex.decode((String)this.getSignature())));
        }
        TransactionOuterClass.Transaction transaction = builder.build();
        Blake2bDigest hash = new Blake2bDigest(256);
        hash.update(transaction.toByteArray(), 0, transaction.toByteArray().length);
        byte[] out = new byte[hash.getDigestSize()];
        hash.doFinal(out, 0);
        this.txHash = new String(Hex.encode((byte[])out));
        return this.txHash;
    }

    public void setNonce(long nonce) {
        this.nonce = nonce;
    }

    public long getNonce() {
        return this.nonce;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setSender(Address sender) {
        this.sender = sender;
    }

    public Address getSender() {
        return this.sender;
    }

    public void setReceiver(Address receiver) {
        this.receiver = receiver;
    }

    public Address getReceiver() {
        return this.receiver;
    }

    public void setGasPrice(long gasPrice) {
        this.gasPrice = gasPrice;
    }

    public long getGasPrice() {
        return this.gasPrice;
    }

    public void setGasLimit(long gasLimit) {
        this.gasLimit = gasLimit;
    }

    public long getGasLimit() {
        return this.gasLimit;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public String getDataEncoded() {
        byte[] dataAsBytes = this.data.getBytes(StandardCharsets.UTF_8);
        byte[] encodedAsBytes = Base64.encode((byte[])dataAsBytes);
        return new String(encodedAsBytes);
    }

    public void setChainID(String chainID) {
        this.chainID = chainID;
    }

    public String getChainID() {
        return this.chainID;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getTxHash() {
        return this.txHash;
    }
}

