/*
 * Decompiled with CFR 0.152.
 */
package multiversx.esdt.builders;

import java.math.BigInteger;
import multiversx.Address;
import multiversx.esdt.common.TokenPayment;
import org.apache.commons.codec.binary.Hex;

public class ESDTNFTTransferBuilder {
    private TokenPayment payment;
    private Address receiver;

    public ESDTNFTTransferBuilder setPayment(TokenPayment payment) {
        this.payment = payment;
        return this;
    }

    public ESDTNFTTransferBuilder setReceiver(Address receiver) {
        this.receiver = receiver;
        return this;
    }

    public String build() {
        BigInteger nonceBI = new BigInteger(this.payment.getNonce().toString());
        String nonceHex = Hex.encodeHexString((byte[])nonceBI.toByteArray());
        return String.join((CharSequence)"@", "ESDTNFTTransfer", this.payment.getTokenIdentifier().toHexString(), nonceHex, this.payment.valueToHexString(), this.receiver.hex());
    }
}

