/*
 * Decompiled with CFR 0.152.
 */
package multiversx.esdt.common;

import java.nio.charset.StandardCharsets;
import multiversx.esdt.common.Utils;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class TokenIdentifier {
    private String hexTokenIdentifier;

    private TokenIdentifier() {
    }

    public static TokenIdentifier fromString(String tokenIdentifier) {
        TokenIdentifier ti = new TokenIdentifier();
        ti.hexTokenIdentifier = Utils.castToPaddedHex(tokenIdentifier);
        return ti;
    }

    public static TokenIdentifier fromHex(String hexTokenIdentifier) {
        TokenIdentifier ti = new TokenIdentifier();
        ti.hexTokenIdentifier = hexTokenIdentifier;
        return ti;
    }

    public String toRegularString() throws DecoderException {
        byte[] bytes = Hex.decodeHex((char[])this.hexTokenIdentifier.toCharArray());
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public String toHexString() {
        return this.hexTokenIdentifier;
    }
}

