/*
 * Decompiled with CFR 0.152.
 */
package multiversx.esdt.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import multiversx.esdt.common.Constants;
import multiversx.esdt.common.TokenIdentifier;
import org.apache.commons.codec.binary.Hex;

public class TokenPayment {
    private final TokenIdentifier tokenIdentifier;
    private final BigDecimal amountAsBigDecimal;
    private final Integer numDecimals;
    private final Long nonce;

    public TokenPayment(TokenIdentifier identifier, BigDecimal amountAsBigDecimal, Integer numDecimals, Long nonce) {
        this.tokenIdentifier = identifier;
        this.amountAsBigDecimal = amountAsBigDecimal;
        this.numDecimals = numDecimals;
        this.nonce = nonce;
    }

    public static TokenPayment egldFromAmount(String amount) {
        BigDecimal amountAsBigDecimal = TokenPayment.increaseMagnitude(new BigDecimal(amount), Constants.EGLDNumDecimals);
        return TokenPayment.egldFromBigDecimal(amountAsBigDecimal);
    }

    public static TokenPayment egldFromBigDecimal(BigDecimal amountAsBigDecimal) {
        return new TokenPayment(Constants.EGLDIdentifier, amountAsBigDecimal, Constants.EGLDNumDecimals, 0L);
    }

    public static TokenPayment fungibleFromAmount(TokenIdentifier tokenIdentifier, String amount, Integer numDecimals) {
        BigDecimal amountAsBigDecimal = TokenPayment.increaseMagnitude(new BigDecimal(amount), numDecimals);
        return TokenPayment.fungibleFromBigDecimal(tokenIdentifier, amountAsBigDecimal, numDecimals);
    }

    public static TokenPayment fungibleFromBigDecimal(TokenIdentifier tokenIdentifier, BigDecimal amountAsBigDecimal, Integer numDecimals) {
        return new TokenPayment(tokenIdentifier, amountAsBigDecimal, numDecimals, 0L);
    }

    public static TokenPayment metaEsdtFromAmount(TokenIdentifier tokenIdentifier, String amount, Integer numDecimals, Long nonce) {
        BigDecimal amountAsBigDecimal = TokenPayment.increaseMagnitude(new BigDecimal(amount), numDecimals);
        return TokenPayment.metaEsdtFromBigDecimal(tokenIdentifier, amountAsBigDecimal, numDecimals, nonce);
    }

    public static TokenPayment metaEsdtFromBigDecimal(TokenIdentifier tokenIdentifier, BigDecimal amountAsBigDecimal, Integer numDecimals, Long nonce) {
        return new TokenPayment(tokenIdentifier, amountAsBigDecimal, numDecimals, nonce);
    }

    public static TokenPayment semiFungible(TokenIdentifier tokenIdentifier, Integer quantity, Long nonce) {
        return new TokenPayment(tokenIdentifier, new BigDecimal(quantity.toString()), 0, nonce);
    }

    public static TokenPayment nonFungible(TokenIdentifier tokenIdentifier, Long nonce) {
        return new TokenPayment(tokenIdentifier, TokenPayment.increaseMagnitude(new BigDecimal("1"), 0), 0, nonce);
    }

    private static BigDecimal increaseMagnitude(BigDecimal input, Integer numDecimals) {
        String inputStr = "1" + String.join((CharSequence)"", Collections.nCopies(numDecimals, "0"));
        BigDecimal multipliedBy = new BigDecimal(inputStr);
        return input.multiply(multipliedBy);
    }

    public String toString() {
        return this.amountAsBigDecimal.toBigInteger().toString(10);
    }

    public String valueToHexString() {
        BigInteger bi = this.amountAsBigDecimal.toBigInteger();
        return Hex.encodeHexString((byte[])bi.toByteArray());
    }

    public Integer getNumDecimals() {
        return this.numDecimals;
    }

    public Long getNonce() {
        return this.nonce;
    }

    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }
}

